/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Map;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.util.JsonParser;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.WikiGet;

public class ApertiumTranslate
extends BaseTranslate {
    protected static final String GT_URL = "https://www.apertium.org/apy/translate?q=";
    protected static final String GT_URL2 = "&markUnknown=no&langpair=#sourceLang#|#targetLang#&key=bwuxb5jS+VwSJ8mLz1qMfmMrDGA";

    @Override
    protected String getPreferenceName() {
        return "allow_apertium_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_APERTIUM");
    }

    private String apertiumCode(Language language) {
        String lCode = language.getLanguageCode().toLowerCase(Locale.ENGLISH);
        String locale = language.getLocaleCode();
        if (!StringUtil.isEmpty(language.getCountryCode())) {
            if (locale.equalsIgnoreCase("en_us") || locale.equalsIgnoreCase("pt_br")) {
                return locale;
            }
            if (locale.equalsIgnoreCase("oc_ar")) {
                return "oc_aran";
            }
            if (locale.equalsIgnoreCase("ca_va")) {
                return "ca_valencia";
            }
        }
        return lCode;
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String v;
        String prev = this.getFromCache(sLang, tLang, text);
        if (prev != null) {
            return prev;
        }
        String trText = text;
        String sourceLang = this.apertiumCode(sLang);
        String targetLang = this.apertiumCode(tLang);
        String url2 = GT_URL2.replace("#sourceLang#", sourceLang).replace("#targetLang#", targetLang);
        String url = GT_URL + URLEncoder.encode(trText, "UTF-8") + url2;
        try {
            v = WikiGet.getURL(url);
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
        String tr = this.getJsonResults(v);
        this.putToCache(sLang, tLang, trText, tr);
        return tr;
    }

    protected String getJsonResults(String json) {
        Map rootNode;
        try {
            rootNode = (Map)JsonParser.parse(json);
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_JSON_ERROR", new Object[0]);
            return OStrings.getString("MT_JSON_ERROR");
        }
        Integer code = 0;
        String tr = null;
        if (rootNode.containsKey("responseStatus")) {
            code = (Integer)rootNode.get("responseStatus");
        }
        if (rootNode.containsKey("responseData")) {
            Map data = (Map)rootNode.get("responseData");
            tr = (String)data.get("translatedText");
        }
        if (tr == null || code != 200) {
            String details = (String)rootNode.get("responseDetails");
            return StringUtil.format(OStrings.getString("APERTIUM_ERROR"), code, details);
        }
        return tr;
    }
}

