/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.multtrans;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.multtrans.MultipleTransFindThread;
import org.omegat.gui.multtrans.MultipleTransFoundEntry;
import org.omegat.util.Java8Compat;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.IPaneMenu;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.UIThreadsUtil;

public class MultipleTransPane
extends EntryInfoThreadPane<List<MultipleTransFoundEntry>>
implements IPaneMenu {
    private static final String EXPLANATION = OStrings.getString("GUI_MULTIPLETRANSLATIONSWINDOW_explanation");
    private List<DisplayedEntry> entries = new ArrayList<DisplayedEntry>();
    private final DockableScrollPane scrollPane;
    protected final transient MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopup(e.getPoint());
            }
        }

        private void doPopup(Point p) {
            if (MultipleTransPane.this.entries.isEmpty()) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            MultipleTransPane.this.populateContextMenu(popup, Java8Compat.viewToModel(MultipleTransPane.this, p));
            popup.show(MultipleTransPane.this, p.x, p.y);
        }
    };

    public MultipleTransPane(IMainWindow mw) {
        super(true);
        String title = OStrings.getString("MULT_TITLE");
        this.scrollPane = new DockableScrollPane("MULTIPLE_TRANS", title, this, true);
        mw.addDockable(this.scrollPane);
        this.setEditable(false);
        StaticUIUtils.makeCaretAlwaysVisible(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        Core.getEditor().registerPopupMenuConstructors(600, new IPopupMenuConstructor(){

            @Override
            public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
                if (isInActiveEntry && Core.getProject().getProjectProperties().isSupportDefaultTranslations()) {
                    JMenuItem miDefault = menu.add(OStrings.getString("MULT_MENU_DEFAULT"));
                    JMenuItem miMultiple = menu.add(OStrings.getString("MULT_MENU_MULTIPLE"));
                    miDefault.setEnabled(!sb.isDefaultTranslation());
                    miMultiple.setEnabled(sb.isDefaultTranslation());
                    miDefault.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Core.getEditor().setAlternateTranslationForCurrentEntry(false);
                            Core.getEditor().commitAndLeave();
                        }
                    });
                    miMultiple.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Core.getEditor().setAlternateTranslationForCurrentEntry(true);
                        }
                    });
                }
            }
        });
        this.addMouseListener(this.mouseListener);
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        this.scrollPane.stopNotifying();
        super.onEntryActivated(newEntry);
    }

    @Override
    protected void setFoundResult(SourceTextEntry processedEntry, List<MultipleTransFoundEntry> data) {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        if (data.size() == 1 && data.get((int)0).key == null) {
            return;
        }
        if (!data.isEmpty() && Preferences.isPreference("notify_multiple_translations")) {
            this.scrollPane.notify(true);
        }
        StringBuilder o = new StringBuilder();
        for (MultipleTransFoundEntry e : data) {
            DisplayedEntry de = new DisplayedEntry();
            de.entry = e;
            de.start = o.length();
            if (e.entry.translation == null) continue;
            if (e.key != null) {
                o.append(e.entry.translation).append('\n');
                o.append('<').append(e.key.file);
                if (e.key.id != null) {
                    o.append('/').append(e.key.id);
                }
                o.append(">\n");
                if (e.key.prev != null && e.key.next != null) {
                    o.append('(').append(StringUtil.truncate(e.key.prev, 10));
                    o.append(" <...> ").append(StringUtil.truncate(e.key.next, 10)).append(")\n");
                }
            } else {
                o.append(e.entry.translation).append('\n');
            }
            de.end = o.length();
            this.entries.add(de);
            o.append('\n');
        }
        this.setText(o.toString());
    }

    @Override
    public void clear() {
        super.clear();
        this.entries.clear();
    }

    @Override
    protected void onProjectOpen() {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
    }

    @Override
    protected void onProjectClose() {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        this.setText(EXPLANATION);
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        new MultipleTransFindThread(this, Core.getProject(), newEntry).start();
    }

    private DisplayedEntry getEntryAtPosition(int pos) {
        for (DisplayedEntry de : this.entries) {
            if (de.start > pos || de.end < pos) continue;
            return de;
        }
        return null;
    }

    private void populateContextMenu(JPopupMenu popup, int pos) {
        DisplayedEntry de = this.getEntryAtPosition(pos);
        JMenuItem item = popup.add(OStrings.getString("MULT_POPUP_DEFAULT"));
        item.setEnabled(de != null && de.entry.key != null);
        if (de != null && de.entry.key != null) {
            item.addActionListener(e -> {
                Core.getEditor().replaceEditText(de.entry.entry.translation);
                Core.getEditor().setAlternateTranslationForCurrentEntry(false);
                Core.getEditor().commitAndLeave();
            });
        }
        item = popup.add(OStrings.getString("MULT_POPUP_REPLACE"));
        item.setEnabled(de != null);
        if (de != null) {
            item.addActionListener(e -> Core.getEditor().replaceEditText(de.entry.entry.translation));
        }
        item = popup.add(OStrings.getString("MULT_POPUP_GOTO"));
        item.setEnabled(de != null);
        if (de != null) {
            item.addActionListener(e -> Core.getEditor().gotoEntry(de.entry.sourceText, de.entry.key));
        }
    }

    @Override
    public void populatePaneMenu(JPopupMenu menu) {
        JCheckBoxMenuItem notify = new JCheckBoxMenuItem(OStrings.getString("MULT_SETTINGS_NOTIFY"));
        notify.setSelected(Preferences.isPreference("notify_multiple_translations"));
        notify.addActionListener(e -> Preferences.setPreference("notify_multiple_translations", notify.isSelected()));
        menu.add(notify);
    }

    protected static class DisplayedEntry {
        int start;
        int end;
        MultipleTransFoundEntry entry;

        protected DisplayedEntry() {
        }
    }
}

