/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.util.Collection;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc16.SVNCopyClient16;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldRepositoryAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnOperationOptionsProvider;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRemoteCopy;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnNgReposToReposCopy
extends SvnRemoteOperationRunner<SVNCommitInfo, SvnRemoteCopy> {
    @Override
    public boolean isApplicable(SvnRemoteCopy operation, SvnWcGeneration wcGeneration) throws SVNException {
        return this.areAllSourcesRemote(operation) && !operation.getFirstTarget().isLocal();
    }

    private boolean areAllSourcesRemote(SvnRemoteCopy operation) {
        for (SvnCopySource source : operation.getSources()) {
            if (source.getSource().isURL() || source.getRevision() != SVNRevision.WORKING && source.getRevision() != SVNRevision.UNDEFINED) continue;
            return false;
        }
        return true;
    }

    @Override
    protected SVNCommitInfo run() throws SVNException {
        Collection<SvnTarget> targets;
        SVNCopyClient16 client = new SVNCopyClient16(((SvnRemoteCopy)this.getOperation()).getRepositoryPool(), ((SvnRemoteCopy)this.getOperation()).getOptions());
        client.setEventHandler(((SvnRemoteCopy)this.getOperation()).getEventHandler());
        client.setExternalsHandler(ISVNExternalsHandler.DEFAULT);
        client.setOptions(((SvnRemoteCopy)this.getOperation()).getOptions());
        client.setCommitHandler(SvnCodec.commitHandler(((SvnRemoteCopy)this.getOperation()).getCommitHandler()));
        SvnTarget target = ((SvnRemoteCopy)this.getOperation()).getFirstTarget();
        SVNCopySource[] sources = new SVNCopySource[((SvnRemoteCopy)this.getOperation()).getSources().size()];
        int i = 0;
        for (SvnCopySource newSource : ((SvnRemoteCopy)this.getOperation()).getSources()) {
            if (newSource.getSource().isFile()) {
                SvnWcGeneration wcGeneration = SvnOperationFactory.detectWcGeneration(newSource.getSource().getFile(), false);
                newSource = wcGeneration == SvnWcGeneration.V16 ? new SvnOldRepositoryAccess((ISvnOperationOptionsProvider)this.getOperation()).createRemoteCopySource(this.getWcContext(), newSource) : new SvnNgRepositoryAccess((ISvnOperationOptionsProvider)this.getOperation(), this.getWcContext()).createRemoteCopySource(this.getWcContext(), newSource);
            }
            sources[i] = SvnCodec.copySource(newSource);
            ++i;
        }
        SVNCommitInfo info = client.doCopy(sources, target.getURL(), ((SvnRemoteCopy)this.getOperation()).isMove(), ((SvnRemoteCopy)this.getOperation()).isMakeParents(), ((SvnRemoteCopy)this.getOperation()).isFailWhenDstExists(), ((SvnRemoteCopy)this.getOperation()).isPinExternals(), ((SvnRemoteCopy)this.getOperation()).getExternalsToPin(), ((SvnRemoteCopy)this.getOperation()).getCommitMessage(), ((SvnRemoteCopy)this.getOperation()).getRevisionProperties());
        if (info != null && (targets = ((SvnRemoteCopy)this.getOperation()).getTargets()) != null && targets.size() != 0) {
            SvnTarget firstTarget = targets.iterator().next();
            SVNRepository repository = this.getRepositoryAccess().createRepository(firstTarget.getURL(), null, true);
            SVNURL repositoryRoot = repository.getRepositoryRoot(true);
            ((SvnRemoteCopy)this.getOperation()).receive(SvnTarget.fromURL(repositoryRoot), info);
        }
        return info;
    }
}

