/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.util.Collections;
import java.util.List;
import org.languagetool.rules.spelling.hunspell.Hunspell;
import org.omegat.core.spellchecker.ISpellCheckerProvider;
import org.omegat.util.Log;

public class SpellCheckerLangToolHunspell
implements ISpellCheckerProvider {
    private final String dictBasename;
    private final Hunspell.Dictionary dict;

    public SpellCheckerLangToolHunspell(String dictBasename) throws Throwable {
        this.dictBasename = dictBasename;
        this.dict = Hunspell.getInstance().getDictionary(dictBasename);
    }

    @Override
    public boolean isCorrect(String word) {
        return !this.dict.misspelled(word);
    }

    @Override
    public List<String> suggest(String word) {
        try {
            return this.dict.suggest(word);
        }
        catch (CharacterCodingException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public void learnWord(String word) {
        try {
            this.dict.addWord(word);
        }
        catch (UnsupportedEncodingException e) {
            Log.log(e);
        }
    }

    @Override
    public void destroy() {
        this.dict.destroy();
        Hunspell.getInstance().destroyDictionary(this.dictBasename);
    }
}

