/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.trie4j.Trie;
import org.trie4j.bv.BitVector01Divider;
import org.trie4j.bv.BytesRank0OnlySuccinctBitVector;
import org.trie4j.bv.BytesRank1OnlySuccinctBitVector;
import org.trie4j.bv.BytesSuccinctBitVector;
import org.trie4j.bv.LongsSuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.io.Constants;
import org.trie4j.louds.TailLOUDSTrie;
import org.trie4j.louds.bvtree.BvTree;
import org.trie4j.louds.bvtree.LOUDSBvTree;
import org.trie4j.louds.bvtree.LOUDSPPBvTree;
import org.trie4j.tail.DefaultTailArray;
import org.trie4j.tail.TailArray;
import org.trie4j.tail.index.ArrayTailIndex;
import org.trie4j.tail.index.DenseArrayTailIndex;
import org.trie4j.tail.index.SBVTailIndex;
import org.trie4j.tail.index.TailIndex;
import org.trie4j.util.IntArray;

public class TrieWriter
implements Constants {
    private DataOutputStream dos;

    public TrieWriter(OutputStream os) {
        this.dos = new DataOutputStream(os);
    }

    public void flush() throws IOException {
        this.dos.flush();
    }

    public void write(Trie trie) throws IOException {
        if (!(trie instanceof TailLOUDSTrie)) {
            throw new IOException("unknown trie: " + trie.getClass().getName());
        }
        this.dos.writeShort(49);
        this.writeTailLOUDSTrie((TailLOUDSTrie)trie);
    }

    public void writeTailLOUDSTrie(TailLOUDSTrie trie) throws IOException {
        trie.trimToSize();
        this.dos.writeInt(trie.size());
        this.dos.writeInt(trie.nodeSize());
        this.writeBvTree(trie.getBvTree());
        this.writeChars(trie.getLabels());
        this.writeTailArray(trie.getTailArray());
        this.writeSuccinctBitVector(trie.getTerm());
    }

    public void writeBvTree(BvTree bvTree) throws IOException {
        if (bvTree instanceof LOUDSBvTree) {
            this.dos.writeShort(64);
            this.writeLOUDSBvTree((LOUDSBvTree)bvTree);
        } else if (bvTree instanceof LOUDSPPBvTree) {
            this.dos.writeShort(65);
            this.writeLOUDSPPBvTree((LOUDSPPBvTree)bvTree);
        } else {
            throw new IOException("unknown bv tree: " + bvTree.getClass().getName());
        }
    }

    public void writeLOUDSBvTree(LOUDSBvTree bvTree) throws IOException {
        bvTree.trimToSize();
        this.writeSuccinctBitVector(bvTree.getSbv());
    }

    public void writeLOUDSPPBvTree(LOUDSPPBvTree bvTree) throws IOException {
        bvTree.trimToSize();
        this.writeBitVector01Divider(bvTree.getDivider());
        this.writeSuccinctBitVector(bvTree.getR0());
        this.writeSuccinctBitVector(bvTree.getR1());
    }

    public void writeTailArray(TailArray tailArray) throws IOException {
        if (!(tailArray instanceof DefaultTailArray)) {
            throw new IOException("unknown tail array: " + tailArray.getClass().getName());
        }
        this.dos.writeShort(80);
        this.writeDefaultTailArray((DefaultTailArray)tailArray);
    }

    public void writeDefaultTailArray(DefaultTailArray tailArray) throws IOException {
        this.writeChars(tailArray.getTail());
        this.writeTailIndex(tailArray.getTailIndex());
    }

    public void writeTailIndex(TailIndex tailIndex) throws IOException {
        if (tailIndex instanceof ArrayTailIndex) {
            this.dos.writeShort(96);
            this.writeArrayTailIndex((ArrayTailIndex)tailIndex);
        } else if (tailIndex instanceof DenseArrayTailIndex) {
            this.dos.writeShort(97);
            this.writeDenseArrayTailIndex((DenseArrayTailIndex)tailIndex);
        } else if (tailIndex instanceof SBVTailIndex) {
            this.dos.writeShort(98);
            this.writeSBVTailIndex((SBVTailIndex)tailIndex);
        } else {
            throw new IOException("unknown tail index: " + tailIndex.getClass().getName());
        }
    }

    public void writeArrayTailIndex(ArrayTailIndex tailIndex) throws IOException {
        this.writeInts(tailIndex.getIndexes());
    }

    public void writeDenseArrayTailIndex(DenseArrayTailIndex tailIndex) throws IOException {
        this.writeSuccinctBitVector(tailIndex.getSbv());
        this.writeInts(tailIndex.getTail());
    }

    public void writeSBVTailIndex(SBVTailIndex tailIndex) throws IOException {
        this.writeSuccinctBitVector(tailIndex.getSbv());
        this.dos.writeInt(tailIndex.size());
    }

    public void writeBitVector01Divider(BitVector01Divider divider) throws IOException {
        this.dos.writeBoolean(divider.isFirst());
        this.dos.writeBoolean(divider.isZeroCounting());
    }

    public void writeSuccinctBitVector(SuccinctBitVector sbv) throws IOException {
        if (sbv instanceof BytesSuccinctBitVector) {
            this.dos.writeShort(112);
            this.writeBytesSuccinctBitVector((BytesSuccinctBitVector)sbv);
        } else if (sbv instanceof BytesRank0OnlySuccinctBitVector) {
            this.dos.writeShort(113);
            this.writeRank0OnlySuccinctBitVector((BytesRank0OnlySuccinctBitVector)sbv);
        } else if (sbv instanceof BytesRank1OnlySuccinctBitVector) {
            this.dos.writeShort(114);
            this.writeRank1OnlySuccinctBitVector((BytesRank1OnlySuccinctBitVector)sbv);
        } else if (sbv instanceof BytesRank1OnlySuccinctBitVector) {
            this.dos.writeShort(115);
            this.writeLongsSuccinctBitVector((LongsSuccinctBitVector)sbv);
        } else {
            throw new IOException("unknown sbv: " + sbv.getClass().getName());
        }
    }

    public void writeRank0OnlySuccinctBitVector(BytesRank0OnlySuccinctBitVector sbv) throws IOException {
        sbv.trimToSize();
        this.writeBytes(sbv.getVector());
        this.dos.writeInt(sbv.size());
        this.writeInts(sbv.getCountCache0());
    }

    public void writeRank1OnlySuccinctBitVector(BytesRank1OnlySuccinctBitVector sbv) throws IOException {
        sbv.trimToSize();
        this.writeBytes(sbv.getBytes());
        this.dos.writeInt(sbv.size());
        this.writeInts(sbv.getCountCache1());
    }

    public void writeBytesSuccinctBitVector(BytesSuccinctBitVector sbv) throws IOException {
        sbv.trimToSize();
        this.writeBytes(sbv.getBytes());
        this.dos.writeInt(sbv.size());
        this.dos.writeInt(sbv.getSize0());
        this.dos.writeInt(sbv.getNode1pos());
        this.dos.writeInt(sbv.getNode2pos());
        this.dos.writeInt(sbv.getNode3pos());
        this.writeInts(sbv.getCountCache0());
        this.writeIntArray(sbv.getIndexCache0());
    }

    public void writeLongsSuccinctBitVector(LongsSuccinctBitVector sbv) throws IOException {
        sbv.trimToSize();
        this.writeLongs(sbv.getLongs());
        this.dos.writeInt(sbv.size());
        this.dos.writeInt(sbv.getSize0());
        this.dos.writeInt(sbv.getNode1pos());
        this.dos.writeInt(sbv.getNode2pos());
        this.dos.writeInt(sbv.getNode3pos());
        this.writeInts(sbv.getCountCache0());
        this.writeIntArray(sbv.getIndexCache0());
    }

    public void writeBytes(byte[] data) throws IOException {
        this.dos.writeInt(data.length);
        this.dos.write(data);
    }

    public void writeChars(char[] data) throws IOException {
        this.dos.writeInt(data.length);
        for (char d : data) {
            this.dos.writeChar(d);
        }
    }

    public void writeChars(CharSequence data) throws IOException {
        if (data instanceof StringBuilder) {
            ((StringBuilder)data).trimToSize();
        }
        int n = data.length();
        this.dos.writeInt(data.length());
        for (int i = 0; i < n; ++i) {
            this.dos.writeChar(data.charAt(i));
        }
    }

    public void writeInts(int[] data) throws IOException {
        this.dos.writeInt(data.length);
        for (int d : data) {
            this.dos.writeInt(d);
        }
    }

    public void writeLongs(long[] data) throws IOException {
        this.dos.writeInt(data.length);
        for (long d : data) {
            this.dos.writeLong(d);
        }
    }

    public void writeIntArray(IntArray data) throws IOException {
        this.writeInts(data.getElements());
    }
}

