/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.trie4j.patricia.PatriciaTrie;

public class WordCompleter {
    static final int MIN_CHARS = 3;
    private PatriciaTrie data;

    public WordCompleter() {
        this.reset();
    }

    public void reset() {
        this.data = new PatriciaTrie();
    }

    public void train(String[] tokens) {
        for (String token : tokens) {
            if (token.codePointCount(0, token.length()) <= 3) continue;
            this.data.insert(token);
        }
    }

    public List<String> completeWord(String seed) {
        if (this.data.size() == 0 || seed.codePointCount(0, seed.length()) < 3) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.data.predictiveSearch(seed)) {
            if (s.equalsIgnoreCase(seed)) continue;
            result.add(s);
        }
        return result;
    }
}

