/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.UIManager;

public class AutoHideButton
extends JLabel {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ZONE = "autohide.zone";
    public static final String uiClassID = "AutoHideButtonUI";
    private boolean selected = false;
    private DockKey key;
    private Dockable dockable;
    private int zone;
    private boolean isNotification = false;
    private Timer notificationTimer;
    private int blinkCount = 0;
    private int MAX_BLINKS = UIManager.getInt("DockingDesktop.notificationBlinkCount");
    private Color highlightColor = UIManager.getColor("VLDocking.highlight");
    private Color bgColor = UIManager.getColor("AutoHideButton.background");
    private PropertyChangeListener keyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("name")) {
                AutoHideButton.this.setText((String)e.getNewValue());
            } else if (e.getPropertyName().equals("tooltip")) {
                AutoHideButton.this.setToolTipText((String)e.getNewValue());
            } else if (e.getPropertyName().equals("icon")) {
                AutoHideButton.this.setIcon((Icon)e.getNewValue());
            } else if (e.getPropertyName().equals("notification")) {
                boolean isOn = (Boolean)e.getNewValue();
                if (isOn) {
                    if (AutoHideButton.this.notificationTimer == null) {
                        AutoHideButton.this.notificationTimer = new Timer(1000, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                AutoHideButton.this.setNotification(!AutoHideButton.this.isNotification);
                                if (!AutoHideButton.this.isNotification) {
                                    AutoHideButton.this.blinkCount++;
                                    if (AutoHideButton.this.blinkCount >= AutoHideButton.this.MAX_BLINKS) {
                                        AutoHideButton.this.blinkCount = 0;
                                        AutoHideButton.this.notificationTimer.stop();
                                    }
                                }
                                AutoHideButton.this.repaint();
                            }
                        });
                    }
                    AutoHideButton.this.setNotification(true);
                    AutoHideButton.this.notificationTimer.restart();
                } else {
                    if (AutoHideButton.this.notificationTimer != null) {
                        AutoHideButton.this.notificationTimer.stop();
                        AutoHideButton.this.blinkCount = 0;
                    }
                    AutoHideButton.this.setNotification(false);
                }
            }
        }
    };

    private void setNotification(boolean notification) {
        this.isNotification = notification;
        if (notification) {
            this.setBackground(UIManager.getColor("DockingDesktop.notificationColor"));
            this.setOpaque(true);
        } else {
            this.setHighlighted(false);
        }
        this.repaint();
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockKey getKey() {
        return this.key;
    }

    public void init(Dockable dockable, int zone) {
        DockKey key = dockable.getDockKey();
        this.dockable = dockable;
        this.key = key;
        int oldZone = this.zone;
        this.zone = zone;
        this.firePropertyChange(PROPERTY_ZONE, oldZone, zone);
        key.addPropertyChangeListener(this.keyListener);
        this.setText(key.getName());
        this.setToolTipText(key.getTooltip());
        if (key.getIcon() != null) {
            this.setIcon(key.getIcon());
        }
        this.setFocusable(true);
        this.setBackground(this.bgColor);
        this.setOpaque(this.bgColor != null);
        this.setIconTextGap(4);
        this.setAlignmentY(1.0f);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.zone == 0 || this.zone == 2) {
            return super.getPreferredSize();
        }
        Dimension d = super.getPreferredSize();
        Insets i = this.getInsets();
        return new Dimension(d.height - i.top - i.bottom + i.left + i.right, d.width - i.left - i.right + i.top + i.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.zone == 0 || this.zone == 2) {
            return super.getMaximumSize();
        }
        Insets i = this.getInsets();
        Dimension d = super.getMaximumSize();
        return new Dimension(d.height - i.top - i.bottom + i.left + i.right, d.width - i.left - i.right + i.top + i.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.zone == 0 || this.zone == 2) {
            return super.getMinimumSize();
        }
        Insets i = this.getInsets();
        Dimension d = super.getMinimumSize();
        return new Dimension(d.height - i.top - i.bottom + i.left + i.right, d.width - i.left - i.right + i.top + i.bottom);
    }

    public int getZone() {
        return this.zone;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.setHighlighted(selected);
        if (selected) {
            this.key.setNotification(false);
        }
    }

    public void setHighlighted(boolean highlighted) {
        if (highlighted) {
            this.setBackground(this.highlightColor);
            this.setOpaque(true);
        } else {
            this.setBackground(this.bgColor);
            this.setOpaque(this.bgColor != null);
        }
        this.repaint();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }
}

