/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.madlonkay.desktopsupport.DesktopSupport;
import org.madlonkay.desktopsupport.QuitStrategy;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.ResourcesUtil;

public final class OSXIntegration {
    public static final Image APP_ICON_MAC = ResourcesUtil.getBundledImage("OmegaT_mac.png");
    private static boolean guiLoaded = false;
    private static final List<Runnable> DO_AFTER_LOAD = new ArrayList<Runnable>();
    private static final IApplicationEventListener APP_LISTENER = new IApplicationEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onApplicationStartup() {
            guiLoaded = true;
            List list = DO_AFTER_LOAD;
            synchronized (list) {
                for (Runnable r : DO_AFTER_LOAD) {
                    r.run();
                }
                DO_AFTER_LOAD.clear();
            }
            JFrame window = Core.getMainWindow().getApplicationFrame();
            OSXIntegration.enableFullScreen(window);
        }

        @Override
        public void onApplicationShutdown() {
            guiLoaded = false;
        }
    };
    private static final IOpenFilesHandler OPEN_FILES_HANDLER = new IOpenFilesHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void openFiles(List<?> files) {
            if (files.isEmpty()) {
                return;
            }
            File firstFile = (File)files.get(0);
            if (firstFile.getName().equals("omegat.project")) {
                firstFile = firstFile.getParentFile();
            }
            if (!StaticUtils.isProjectDir(firstFile)) {
                return;
            }
            final File projDir = firstFile;
            Runnable openProject = new Runnable(){

                @Override
                public void run() {
                    ProjectUICommands.projectOpen(projDir, true);
                }
            };
            if (guiLoaded) {
                SwingUtilities.invokeLater(openProject);
            } else {
                List list = DO_AFTER_LOAD;
                synchronized (list) {
                    DO_AFTER_LOAD.add(openProject);
                }
            }
        }
    };
    private static final IProjectEventListener PROJECT_LISTENER = eventType -> {
        JRootPane rootPane = Core.getMainWindow().getApplicationFrame().getRootPane();
        switch (eventType) {
            case CREATE: 
            case LOAD: {
                String projDir = Core.getProject().getProjectProperties().getProjectRoot();
                OSXIntegration.setProxyIcon(rootPane, new File(projDir));
                break;
            }
            case CLOSE: {
                OSXIntegration.setProxyIcon(rootPane, null);
                break;
            }
            case MODIFIED: {
                OSXIntegration.setModifiedIndicator(rootPane, true);
                break;
            }
            case SAVE: {
                OSXIntegration.setModifiedIndicator(rootPane, false);
                break;
            }
        }
    };

    private OSXIntegration() {
    }

    public static void init() {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "OmegaT");
            DesktopSupport.getSupport().setDockIconImage(APP_ICON_MAC);
            DesktopSupport.getSupport().setQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
            DesktopSupport.getSupport().disableSuddenTermination();
            CoreEvents.registerApplicationEventListener(APP_LISTENER);
            OSXIntegration.setOpenFilesHandler(OPEN_FILES_HANDLER);
            CoreEvents.registerProjectChangeListener(PROJECT_LISTENER);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setAboutHandler(ActionListener al) {
        try {
            DesktopSupport.getSupport().setAboutHandler(e -> al.actionPerformed(null));
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setQuitHandler(ActionListener al) {
        try {
            DesktopSupport.getSupport().setQuitHandler((evt, response) -> {
                if (Preferences.isPreference("always_confirm_quit")) {
                    response.cancelQuit();
                }
                al.actionPerformed(null);
            });
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setOpenFilesHandler(IOpenFilesHandler ofh) {
        try {
            DesktopSupport.getSupport().setOpenFilesHandler(e -> ofh.openFiles(e.getFiles()));
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setPreferencesHandler(ActionListener listener) {
        try {
            DesktopSupport.getSupport().setPreferencesHandler(e -> listener.actionPerformed(null));
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void enableFullScreen(Window window) {
        try {
            DesktopSupport.getSupport().setWindowCanFullScreen(window, true);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public static void setProxyIcon(JRootPane rootPane, File file) {
        rootPane.putClientProperty("Window.documentFile", file);
    }

    public static void setModifiedIndicator(JRootPane rootPane, boolean isModified) {
        rootPane.putClientProperty("Window.documentModified", isModified);
    }

    public static interface IOpenFilesHandler {
        public void openFiles(List<?> var1);
    }
}

