/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.tools.ml.maxent.io.BinaryGISModelWriter;
import opennlp.tools.ml.maxent.io.GISModelWriter;
import opennlp.tools.ml.maxent.io.PlainTextGISModelWriter;
import opennlp.tools.ml.model.AbstractModel;

public class SuffixSensitiveGISModelWriter
extends GISModelWriter {
    private final GISModelWriter suffixAppropriateWriter;

    public SuffixSensitiveGISModelWriter(AbstractModel model, File f) throws IOException {
        super(model);
        FilterOutputStream output;
        String filename = f.getName();
        if (filename.endsWith(".gz")) {
            output = new GZIPOutputStream(new FileOutputStream(f));
            filename = filename.substring(0, filename.length() - 3);
        } else {
            output = new DataOutputStream(new FileOutputStream(f));
        }
        this.suffixAppropriateWriter = filename.endsWith(".bin") ? new BinaryGISModelWriter(model, new DataOutputStream(output)) : new PlainTextGISModelWriter(model, new BufferedWriter(new OutputStreamWriter(output)));
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.suffixAppropriateWriter.writeUTF(s);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.suffixAppropriateWriter.writeInt(i);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.suffixAppropriateWriter.writeDouble(d);
    }

    @Override
    public void close() throws IOException {
        this.suffixAppropriateWriter.close();
    }
}

