/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;

public interface IProject {
    public void saveProjectProperties() throws Exception;

    public void saveProject(boolean var1);

    public void teamSyncPrepare() throws Exception;

    public boolean isTeamSyncPrepared();

    public void teamSync();

    public void closeProject();

    public void compileProject(String var1) throws Exception;

    public void compileProjectAndCommit(String var1, boolean var2, boolean var3) throws Exception;

    public boolean isRemoteProject();

    public void commitSourceFiles() throws Exception;

    public ProjectProperties getProjectProperties();

    public boolean isProjectLoaded();

    public boolean isProjectModified();

    public ITokenizer getSourceTokenizer();

    public ITokenizer getTargetTokenizer();

    public List<SourceTextEntry> getAllEntries();

    public void setTranslation(SourceTextEntry var1, PrepareTMXEntry var2, boolean var3, TMXEntry.ExternalLinked var4);

    public void setTranslation(SourceTextEntry var1, PrepareTMXEntry var2, boolean var3, TMXEntry.ExternalLinked var4, AllTranslations var5) throws OptimisticLockingFail;

    public void setNote(SourceTextEntry var1, TMXEntry var2, String var3);

    public StatisticsInfo getStatistics();

    public TMXEntry getTranslationInfo(SourceTextEntry var1);

    public AllTranslations getAllTranslations(SourceTextEntry var1);

    public void iterateByDefaultTranslations(DefaultTranslationsIterator var1);

    public void iterateByMultipleTranslations(MultipleTranslationsIterator var1);

    public boolean isOrphaned(String var1);

    public boolean isOrphaned(EntryKey var1);

    public Map<String, ExternalTMX> getTransMemories();

    public Map<Language, ProjectTMX> getOtherTargetLanguageTMs();

    public List<FileInfo> getProjectFiles();

    public String getTargetPathForSourceFile(String var1);

    public List<String> getSourceFilesOrder();

    public void setSourceFilesOrder(List<String> var1);

    public static class OptimisticLockingFail
    extends Exception {
        private final String oldTranslationText;
        private final String newTranslationText;
        private final AllTranslations previous;

        public OptimisticLockingFail(String oldTranslationText, String newTranslationText, AllTranslations previous) {
            this.oldTranslationText = oldTranslationText;
            this.newTranslationText = newTranslationText;
            this.previous = previous;
        }

        public String getOldTranslationText() {
            return this.oldTranslationText;
        }

        public String getNewTranslationText() {
            return this.newTranslationText;
        }

        public AllTranslations getPrevious() {
            return this.previous;
        }
    }

    public static class AllTranslations {
        protected TMXEntry defaultTranslation;
        protected TMXEntry alternativeTranslation;
        protected TMXEntry currentTranslation;

        public TMXEntry getDefaultTranslation() {
            return this.defaultTranslation;
        }

        public TMXEntry getAlternativeTranslation() {
            return this.alternativeTranslation;
        }

        public TMXEntry getCurrentTranslation() {
            return this.currentTranslation;
        }
    }

    public static interface MultipleTranslationsIterator {
        public void iterate(EntryKey var1, TMXEntry var2);
    }

    public static interface DefaultTranslationsIterator {
        public void iterate(String var1, TMXEntry var2);
    }

    public static class FileInfo {
        public String filePath;
        public Class<?> filterClass;
        public String filterFileFormatName;
        public String fileEncoding;
        public List<SourceTextEntry> entries = new ArrayList<SourceTextEntry>();
    }
}

