/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.visitors.NodeVisitor;
import org.omegat.core.Core;
import org.omegat.filters2.html2.HTMLFilter2;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.filters2.html2.HTMLUtils;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.StringUtil;

public class FilterVisitor
extends NodeVisitor {
    protected HTMLFilter2 filter;
    private BufferedWriter writer;
    private HTMLOptions options;
    protected boolean recurse = true;
    protected boolean text = false;
    protected boolean preformatting = false;
    protected List<Node> befors;
    protected List<Node> translatable;
    protected List<Node> afters;
    protected List<Tag> sTags;
    protected List<Integer> sTagNumbers;
    protected List<String> sShortcuts;
    int sNumShortcuts;
    boolean firstcall = true;

    public FilterVisitor(HTMLFilter2 htmlfilter, BufferedWriter bufwriter, HTMLOptions opts) {
        this.filter = htmlfilter;
        this.options = opts != null ? opts : new HTMLOptions(new TreeMap<String, String>());
        this.writer = bufwriter;
    }

    public boolean shouldRecurseSelf() {
        return this.recurse;
    }

    public boolean shouldRecurseChildren() {
        return this.recurse;
    }

    public void visitTag(Tag tag) {
        Iterator i;
        Vector tagAttributes;
        boolean intactTag = this.isIntactTag(tag);
        if (!intactTag) {
            tagAttributes = tag.getAttributesEx();
            i = tagAttributes.iterator();
            while (i.hasNext() && !intactTag) {
                Attribute attribute = (Attribute)i.next();
                String name = attribute.getName();
                String value = attribute.getValue();
                if (name == null || value == null) continue;
                intactTag = this.filter.checkIgnoreTags(name, value);
            }
        }
        if (intactTag) {
            if (this.text) {
                this.endup();
            } else {
                this.flushbefors();
            }
            this.writeout(tag.toHtml());
            if (tag.getEndTag() != null) {
                this.recurse = false;
            }
        } else {
            if (this.isParagraphTag(tag) && this.text) {
                this.endup();
            }
            if (this.isPreformattingTag(tag) || Core.getFilterMaster().getConfig().isPreserveSpaces()) {
                this.preformatting = true;
            }
            this.maybeTranslateAttribute(tag, "abbr");
            this.maybeTranslateAttribute(tag, "alt");
            this.maybeTranslateAttribute(tag, "dir");
            if (this.options.getTranslateHref()) {
                this.maybeTranslateAttribute(tag, "href");
            }
            if (this.options.getTranslateHreflang()) {
                this.maybeTranslateAttribute(tag, "hreflang");
            }
            if (this.options.getTranslateLang()) {
                this.maybeTranslateAttribute(tag, "lang");
                this.maybeTranslateAttribute(tag, "xml:lang");
            }
            this.maybeTranslateAttribute(tag, "label");
            if ("IMG".equals(tag.getTagName()) && this.options.getTranslateSrc()) {
                this.maybeTranslateAttribute(tag, "src");
            }
            this.maybeTranslateAttribute(tag, "summary");
            this.maybeTranslateAttribute(tag, "title");
            if ("INPUT".equals(tag.getTagName())) {
                if (this.options.getTranslateValue() || this.options.getTranslateButtonValue() && ("submit".equalsIgnoreCase(tag.getAttribute("type")) || "button".equalsIgnoreCase(tag.getAttribute("type")) || "reset".equalsIgnoreCase(tag.getAttribute("type")))) {
                    this.maybeTranslateAttribute(tag, "value");
                }
                this.maybeTranslateAttribute(tag, "placeholder");
            }
            if ("META".equals(tag.getTagName())) {
                tagAttributes = tag.getAttributesEx();
                i = tagAttributes.iterator();
                boolean doSkipMetaTag = false;
                while (i.hasNext() && !doSkipMetaTag) {
                    Attribute attribute = (Attribute)i.next();
                    String name = attribute.getName();
                    String value = attribute.getValue();
                    if (name == null || value == null) continue;
                    doSkipMetaTag = this.filter.checkDoSkipMetaTag(name, value);
                }
                if (!doSkipMetaTag) {
                    this.maybeTranslateAttribute(tag, "content");
                }
            }
            this.queuePrefix(tag);
        }
    }

    protected void maybeTranslateAttribute(Tag tag, String key) {
        String attr = tag.getAttribute(key);
        if (attr != null) {
            String comment = OStrings.getString("HTMLFILTER_TAG") + " " + tag.getTagName() + " " + OStrings.getString("HTMLFILTER_ATTRIBUTE") + " " + key;
            String trans = this.filter.privateProcessEntry(HTMLUtils.entitiesToChars(attr), comment);
            tag.setAttribute(key, HTMLUtils.charsToEntities(trans, this.filter.getTargetEncoding(), this.sShortcuts));
        }
    }

    public void visitStringNode(Text string) {
        this.recurse = true;
        String trimmedtext = HTMLUtils.entitiesToChars(string.getText()).replace('\u00a0', ' ').trim();
        if (!trimmedtext.isEmpty()) {
            if (this.firstcall && PatternConsts.XML_HEADER.matcher(trimmedtext).matches()) {
                this.writeout(string.toHtml());
                return;
            }
            this.text = true;
            this.firstcall = false;
        } else if (this.preformatting) {
            this.text = true;
        }
        if (this.text) {
            this.queueTranslatable(string);
        } else {
            this.queuePrefix(string);
        }
    }

    public void visitRemarkNode(Remark remark) {
        this.recurse = true;
        if (this.text) {
            this.endup();
        } else {
            this.flushbefors();
        }
        if (!this.options.getRemoveComments()) {
            this.writeout(remark.toHtml());
        }
    }

    public void visitEndTag(Tag tag) {
        this.recurse = true;
        if (this.isParagraphTag(tag) && this.text) {
            this.endup();
        }
        if (this.isPreformattingTag(tag)) {
            this.preformatting = false;
        }
        this.queuePrefix(tag);
    }

    public void beginParsing() {
        this.cleanup();
    }

    public void finishedParsing() {
        if (this.text) {
            this.endup();
        } else {
            this.flushbefors();
        }
    }

    private boolean isParagraphTag(Tag tag) {
        String tagname = tag.getTagName();
        return tagname.equals("ADDRESS") || tagname.equals("BLOCKQUOTE") || tagname.equals("BODY") || tagname.equals("CENTER") || tagname.equals("DIV") || tagname.equals("H1") || tagname.equals("H2") || tagname.equals("H3") || tagname.equals("H4") || tagname.equals("H5") || tagname.equals("H6") || tagname.equals("HTML") || tagname.equals("HEAD") || tagname.equals("TITLE") || tagname.equals("TABLE") || tagname.equals("TR") || tagname.equals("TD") || tagname.equals("TH") || tagname.equals("P") || tagname.equals("PRE") || tagname.equals("OL") || tagname.equals("UL") || tagname.equals("LI") || tagname.equals("DL") || tagname.equals("DT") || tagname.equals("DD") || tagname.equals("FORM") || tagname.equals("TEXTAREA") || tagname.equals("FIELDSET") || tagname.equals("LEGEND") || tagname.equals("LABEL") || tagname.equals("SELECT") || tagname.equals("OPTION") || tagname.equals("HR") || tagname.equals("BR") && this.options.getParagraphOnBr();
    }

    private boolean isIntactTag(Tag tag) {
        String tagname = tag.getTagName();
        return tagname.equals("!DOCTYPE") || tagname.equals("STYLE") || tagname.equals("SCRIPT") || tagname.equals("OBJECT") || tagname.equals("EMBED") || tagname.equals("META") && "content-type".equalsIgnoreCase(tag.getAttribute("http-equiv"));
    }

    private boolean isPreformattingTag(Tag tag) {
        String tagname = tag.getTagName();
        return tagname.equals("PRE") || tagname.equals("TEXTAREA");
    }

    private void writeout(String something) {
        try {
            this.writer.write(something);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
    }

    protected void endup() {
        String translation;
        String uncompressed;
        Node node;
        int i;
        ArrayList<Node> all = new ArrayList<Node>();
        all.addAll(this.befors);
        all.addAll(this.translatable);
        int firstgoodlimit = this.befors.size();
        int firstgood = 0;
        while (firstgood < firstgoodlimit) {
            Node goodNode = (Node)all.get(firstgood);
            if (!(goodNode instanceof Tag)) {
                ++firstgood;
                continue;
            }
            Tag good = (Tag)goodNode;
            int recursion = 1;
            boolean found = false;
            for (i = firstgood + 1; i < all.size(); ++i) {
                Tag cand;
                Node candNode = (Node)all.get(i);
                if (!(candNode instanceof Tag) || !(cand = (Tag)candNode).getTagName().equals(good.getTagName())) continue;
                if (!cand.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                if (i < firstgoodlimit) break;
                found = true;
                break;
            }
            if (found) break;
            ++firstgood;
        }
        int lastgoodlimit = all.size() - 1;
        all.addAll(this.afters);
        int lastgood = all.size() - 1;
        while (lastgood > lastgoodlimit) {
            Node goodNode = (Node)all.get(lastgood);
            if (!(goodNode instanceof Tag)) {
                --lastgood;
                continue;
            }
            Tag good = (Tag)goodNode;
            int recursion = 1;
            boolean found = false;
            for (int i2 = lastgood - 1; i2 >= firstgoodlimit; --i2) {
                Tag cand;
                Node candNode = (Node)all.get(i2);
                if (!(candNode instanceof Tag) || !(cand = (Tag)candNode).getTagName().equals(good.getTagName())) continue;
                if (cand.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                if (i2 > lastgoodlimit) break;
                found = true;
                break;
            }
            if (found) break;
            --lastgood;
        }
        boolean changed = true;
        block4: while (changed) {
            Node node2;
            int i3;
            boolean removeSpacesAround;
            changed = false;
            boolean removeTags = Core.getFilterMaster().getConfig().isRemoveTags();
            if (!removeTags) {
                for (i = 0; i < firstgood; ++i) {
                    node = (Node)all.get(i);
                    if (!(node instanceof Tag)) continue;
                    firstgood = i;
                    changed = true;
                    break;
                }
                for (i = all.size() - 1; i > lastgood; --i) {
                    node = (Node)all.get(i);
                    if (!(node instanceof Tag)) continue;
                    lastgood = i;
                    changed = true;
                    break;
                }
            }
            if (removeSpacesAround = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg()) continue;
            for (i3 = 0; i3 < firstgood; ++i3) {
                node2 = (Node)all.get(i3);
                if (!(node2 instanceof TextNode)) continue;
                firstgood = i3;
                changed = true;
                break;
            }
            for (i3 = all.size() - 1; i3 > lastgood; --i3) {
                node2 = (Node)all.get(i3);
                if (!(node2 instanceof TextNode)) continue;
                lastgood = i3;
                changed = true;
                continue block4;
            }
        }
        for (int i4 = 0; i4 < firstgood; ++i4) {
            Node node3 = (Node)all.get(i4);
            if (node3 instanceof Tag) {
                this.writeout("<" + node3.getText() + ">");
                continue;
            }
            this.writeout(this.compressWhitespace(node3.getText()));
        }
        StringBuilder paragraph = new StringBuilder();
        for (int i5 = firstgood; i5 <= lastgood; ++i5) {
            node = (Node)all.get(i5);
            if (node instanceof Tag) {
                this.shortcut((Tag)node, paragraph);
                continue;
            }
            paragraph.append(HTMLUtils.entitiesToChars(node.toHtml()));
        }
        String compressed = uncompressed = paragraph.toString();
        String spacePrefix = "";
        String spacePostfix = "";
        if (!this.preformatting) {
            spacePrefix = HTMLUtils.getSpacePrefix(uncompressed, this.options.getCompressWhitespace());
            spacePostfix = HTMLUtils.getSpacePostfix(uncompressed, this.options.getCompressWhitespace());
            compressed = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg() ? StringUtil.compressSpaces(uncompressed) : uncompressed;
        }
        if (compressed.equals(translation = this.filter.privateProcessEntry(compressed, null)) && !this.options.getCompressWhitespace()) {
            translation = uncompressed;
            spacePrefix = "";
            spacePostfix = "";
        }
        translation = HTMLUtils.charsToEntities(translation, this.filter.getTargetEncoding(), this.sShortcuts);
        translation = this.unshorcutize(translation);
        this.writeout(spacePrefix);
        this.writeout(translation);
        this.writeout(spacePostfix);
        for (int i6 = lastgood + 1; i6 < all.size(); ++i6) {
            Node node4 = (Node)all.get(i6);
            if (node4 instanceof Tag) {
                this.writeout("<" + node4.getText() + ">");
                continue;
            }
            this.writeout(this.compressWhitespace(node4.getText()));
        }
        this.cleanup();
    }

    private void cleanup() {
        this.text = false;
        this.recurse = true;
        this.befors = new ArrayList<Node>();
        this.translatable = new ArrayList<Node>();
        this.afters = new ArrayList<Node>();
        this.sTags = new ArrayList<Tag>();
        this.sTagNumbers = new ArrayList<Integer>();
        this.sShortcuts = new ArrayList<String>();
        this.sNumShortcuts = 0;
    }

    private void shortcut(Tag tag, StringBuilder paragraph) {
        StringBuilder result = new StringBuilder();
        result.append('<');
        int n = -1;
        if (tag.isEndTag()) {
            result.append('/');
            int recursion = 1;
            for (int i = this.sTags.size() - 1; i >= 0; --i) {
                Tag othertag = this.sTags.get(i);
                if (!othertag.getTagName().equals(tag.getTagName())) continue;
                if (othertag.isEndTag()) {
                    ++recursion;
                    continue;
                }
                if (--recursion != 0) continue;
                n = this.sTagNumbers.get(i);
                break;
            }
            if (n < 0) {
                n = this.sNumShortcuts++;
            }
        } else {
            n = this.sNumShortcuts++;
        }
        if ("BR".equals(tag.getTagName())) {
            result.append("br");
        } else {
            result.appendCodePoint(Character.toLowerCase(tag.getTagName().codePointAt(0)));
        }
        result.append(n);
        if (tag.isEmptyXmlTag()) {
            result.append('/');
        }
        result.append('>');
        String shortcut = result.toString();
        this.sTags.add(tag);
        this.sTagNumbers.add(n);
        this.sShortcuts.add(shortcut);
        paragraph.append(shortcut);
    }

    private String unshorcutize(String str) {
        block2: for (int i = 0; i < this.sShortcuts.size(); ++i) {
            String shortcut = this.sShortcuts.get(i);
            int pos = -1;
            while ((pos = str.indexOf(shortcut, pos + 1)) >= 0) {
                Tag tag = this.sTags.get(i);
                try {
                    str = str.substring(0, pos) + "<" + tag.getText() + ">" + str.substring(pos + shortcut.length());
                }
                catch (StringIndexOutOfBoundsException sioobe) {
                    continue block2;
                }
            }
        }
        return str;
    }

    private void queueTranslatable(Text txt) {
        if (!txt.toHtml().trim().isEmpty() || this.preformatting) {
            this.translatable.addAll(this.afters);
            this.afters.clear();
            this.translatable.add((Node)txt);
        } else {
            this.afters.add((Node)txt);
        }
    }

    private void queueTranslatable(Tag tag) {
        this.afters.add((Node)tag);
    }

    protected void queuePrefix(Tag tag) {
        if (this.text) {
            this.queueTranslatable(tag);
        } else if (this.isParagraphTag(tag)) {
            this.flushbefors();
            this.writeout("<" + tag.getText() + ">");
        } else {
            this.befors.add((Node)tag);
        }
    }

    private void queuePrefix(Text txt) {
        this.befors.add((Node)txt);
    }

    private void flushbefors() {
        for (Node node : this.befors) {
            if (node instanceof Tag) {
                this.writeout("<" + node.getText() + ">");
                continue;
            }
            this.writeout(this.compressWhitespace(node.getText()));
        }
        this.befors.clear();
    }

    private String compressWhitespace(String input) {
        if (this.options.getCompressWhitespace()) {
            Matcher whitespaceMatch = PatternConsts.SPACE_TAB.matcher(input);
            return whitespaceMatch.replaceAll(" ");
        }
        return input;
    }
}

