/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.IGlossaryRenderer;
import org.omegat.util.OStrings;
import org.omegat.util.gui.TooltipAttribute;

public class DefaultGlossaryRenderer
implements IGlossaryRenderer {
    @Override
    public String getName() {
        return OStrings.getString("GLOSSARY_RENDERER_DEFAULT");
    }

    @Override
    public String getId() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void render(GlossaryEntry entry, IGlossaryRenderer.IRenderTarget<?> trg) {
        trg.append(entry.getSrcText(), SOURCE_ATTRIBUTES);
        trg.append(" = ");
        String[] targets = entry.getLocTerms(false);
        String[] comments = entry.getComments();
        boolean[] priorities = entry.getPriorities();
        String[] origins = entry.getOrigins(false);
        StringBuilder commentsBuf = new StringBuilder();
        int commentIndex = 0;
        for (int i = 0; i < targets.length; ++i) {
            if (i > 0 && targets[i].equals(targets[i - 1])) {
                if (comments[i].equals("")) continue;
                commentsBuf.append("\n");
                commentsBuf.append(String.valueOf(commentIndex));
                commentsBuf.append(". ");
                commentsBuf.append(comments[i]);
                continue;
            }
            if (i > 0) {
                trg.append(", ");
            }
            SimpleAttributeSet attrs = new SimpleAttributeSet(TARGET_ATTRIBUTES);
            if (priorities[i]) {
                StyleConstants.setBold(attrs, true);
            }
            attrs.addAttribute("tooltip_payload", new TooltipAttribute(origins[i]));
            trg.append(this.bracketEntry(targets[i]), attrs);
            ++commentIndex;
            if (comments[i].equals("")) continue;
            commentsBuf.append("\n");
            commentsBuf.append(String.valueOf(commentIndex));
            commentsBuf.append(". ");
            commentsBuf.append(comments[i]);
        }
        trg.append(commentsBuf.toString(), NOTES_ATTRIBUTES);
    }

    private String bracketEntry(String entry) {
        if (entry.contains(",") && !entry.contains(";") && !entry.contains("\"")) {
            entry = '\"' + entry + '\"';
        }
        return entry;
    }
}

