/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;

@API(status=API.Status.STABLE, since="1.0")
public class ClassSelector
implements DiscoverySelector {
    private final String className;
    private Class<?> javaClass;

    ClassSelector(String className) {
        this.className = className;
    }

    ClassSelector(Class<?> javaClass) {
        this.className = javaClass.getName();
        this.javaClass = javaClass;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> getJavaClass() {
        if (this.javaClass == null) {
            this.javaClass = (Class)ReflectionUtils.tryToLoadClass((String)this.className).getOrThrow(cause -> new PreconditionViolationException("Could not load class with name: " + this.className, (Throwable)cause));
        }
        return this.javaClass;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSelector that = (ClassSelector)o;
        return Objects.equals(this.className, that.className);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.className.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("className", (Object)this.className).toString();
    }
}

