/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.awt.Window;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.JsonParser;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class DeepLTranslate
extends BaseTranslate {
    protected static final String PROPERTY_API_KEY = "deepl.api.key";
    protected static final String DEEPL_URL = "https://api.deepl.com/v1/translate";
    protected static final Pattern RE_HTML = Pattern.compile("&#([0-9]+);");

    @Override
    protected String getPreferenceName() {
        return "allow_deepl_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_DEEPL");
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String v;
        String trText = text.length() > 5000 ? text.substring(0, 4997) + "..." : text;
        String prev = this.getFromCache(sLang, tLang, trText);
        if (prev != null) {
            return prev;
        }
        String apiKey = this.getCredential(PROPERTY_API_KEY);
        if (apiKey == null || apiKey.isEmpty()) {
            return OStrings.getString("DEEPL_API_KEY_NOTFOUND");
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("text", trText);
        params.put("source_lang", sLang.getLanguageCode().toUpperCase());
        params.put("target_lang", tLang.getLanguageCode().toUpperCase());
        params.put("tag_handling", "xml");
        String splitSentence = Core.getProject().getProjectProperties().isSentenceSegmentingEnabled() ? "1" : "0";
        params.put("split_sentences", splitSentence);
        params.put("preserve_formatting", "1");
        params.put("auth_key", apiKey);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        try {
            v = HttpConnectionUtils.get(DEEPL_URL, params, headers, "UTF-8");
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
        String tr = this.getJsonResults(v);
        if (tr == null) {
            return "";
        }
        tr = this.unescapeHTML(tr);
        tr = this.cleanSpacesAroundTags(tr, trText);
        this.putToCache(sLang, tLang, trText, tr);
        return tr;
    }

    private String unescapeHTML(String text) {
        text = text.replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
        Matcher m = RE_HTML.matcher(text);
        while (m.find()) {
            String g = m.group();
            int codePoint = Integer.parseInt(m.group(1));
            String cpString = String.valueOf(Character.toChars(codePoint));
            text = text.replace(g, cpString);
        }
        return text;
    }

    protected String getJsonResults(String json) {
        Map rootNode;
        try {
            rootNode = (Map)JsonParser.parse(json);
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_JSON_ERROR", new Object[0]);
            return OStrings.getString("MT_JSON_ERROR");
        }
        try {
            List translationsList = (List)rootNode.get("translations");
            Map translationNode = (Map)translationsList.get(0);
            return (String)translationNode.get("text");
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                String key = this.panel.valueField1.getText().trim();
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                DeepLTranslate.this.setCredential(DeepLTranslate.PROPERTY_API_KEY, key, temporary);
            }
        };
        dialog.panel.valueLabel1.setText(OStrings.getString("MT_ENGINE_DEEPL_API_KEY_LABEL"));
        dialog.panel.valueField1.setText(this.getCredential(PROPERTY_API_KEY));
        dialog.panel.valueLabel2.setVisible(false);
        dialog.panel.valueField2.setVisible(false);
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(PROPERTY_API_KEY));
        dialog.show();
    }
}

