; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFUN process-rule (V122 V123 V124)
 (abs->horn-clause V122 V123 (compile '<abs-rule> V124)))

(DEFUN <abs-rule> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<side-conditions> (<side-conditions> Stream)))
    (IF (NOT (failure? <side-conditions>))
     (LET ((<premises> (<premises> <side-conditions>)))
      (IF (NOT (failure? <premises>))
       (LET ((<singleunderline> (<singleunderline> <premises>)))
        (IF (NOT (failure? <singleunderline>))
         (LET ((<conclusion> (<conclusion> <singleunderline>)))
          (IF (NOT (failure? <conclusion>))
           (LIST (FIRST <conclusion>)
            (@p 'single
             (CONS (SECOND <side-conditions>)
              (CONS (SECOND <premises>) (CONS (SECOND <conclusion>) NIL)))))
           NIL))
         NIL))
       NIL))
     NIL)))))

(DEFUN abs->horn-clause (V131 V132 V133)
 (COND
  ((AND (EQ 'single V131) (TUPLE-P V133))
   (PROGV (LIST '*rule-bound*) (LIST T)
    (LET ((HornClause (rule->horn-clause (gensym "anon") (snd V133))))
     (LET ((Elimt* (process-calls-to-t* 'single HornClause)))
      (LET ((InsertUnif (LIST (insert-bound V132 Elimt*))))
       (LET ((Proc (head (s-prolog InsertUnif))))
        (rule-abstraction 'single Proc)))))))
  ((AND (EQ 'multi V131) (TUPLE-P V133))
   (PROGV (LIST '*rule-bound*) (LIST 'T)
    (LET ((Anon (gensym "anon")))
     (LET ((HornClause (rule->horn-clause Anon (snd V133))))
      (LET ((Elimt* (process-calls-to-t* 'multi HornClause)))
       (LET
        ((InsertUnif
          (LIST (insert-bound V132 Elimt*) (default-horn-clause Anon))))
        (LET ((Proc (head (s-prolog InsertUnif))))
         (rule-abstraction 'multi Proc))))))))
  (T (implementration_error 'abs->horn-clause))))

(DEFUN default-horn-clause (V134)
 (LIST (LIST V134 '_ '_ '_) ':- (LIST (LIST 'return (LIST 'value '*multi*)))))

(DEFUN insert-bound (V135 V136)
 (COND ((NULL V135) V136)
  ((AND (CONSP V135) (CONSP V136) (CONSP (CDR V136)) (EQ ':- (CAR (CDR V136)))
    (CONSP (CDR (CDR V136))) (NULL (CDR (CDR (CDR V136)))))
   (LET* ((V137 (CAR V135)))
    (insert-bound (CDR V135)
     (LIST (CAR V136) ':-
      (CONS (LIST 'unify V137 (LIST 'lkb V137)) (CAR (CDR (CDR V136))))))))
  (T (implementration_error 'insert-bound))))

(DEFUN process-calls-to-t* (V138 V139)
 (COND
  ((AND (CONSP V139) (CONSP (CDR V139)) (EQ ':- (CAR (CDR V139)))
    (CONSP (CDR (CDR V139))) (NULL (CDR (CDR (CDR V139)))))
   (LIST (APPEND (CAR V139) (LIST 'Sequents)) ':-
    (pctt*-help V138 (CAR (CDR (CDR V139))))))
  (T (implementration_error 'process-calls-to-t*))))

(DEFUN pctt*-help (V140 V141)
 (COND ((AND (EQ 'single V140) (NULL V141)) 
        (LIST (LIST 'return-success-or-sequents 'Sequents)))
  ((AND (EQ 'multi V140) (NULL V141)) (LIST (LIST 'fail)))
  ((AND (CONSP V141) (CONSP (CAR V141)) (EQ 't* (CAR (CAR V141)))
    (CONSP (CDR (CAR V141))) (CONSP (CDR (CDR (CAR V141))))
    (NULL (CDR (CDR (CDR (CAR V141))))))
   (return-sequents V140 V141))
  ((CONSP V141) (CONS (CAR V141) (pctt*-help V140 (CDR V141))))
  (T (implementration_error 'pctt*-help))))

(DEFUN return-success-or-sequents (Sequents Continuation)
  (DECLARE (IGNORE Continuation))
  (IF (NULL Sequents)
      'success
      (deref Sequents)))

(DEFUN return-sequents (V142 V143)
 (COND
  ((EQ 'single V142)
   (LIST
    (LIST 'return
     (LIST 'append (CONS 'list (THE LIST (map 'sequentise-t* V143)))
      'Sequents))))
  ((EQ 'multi V142)
   (LIST
    (LIST 'store-and-fail
     (LIST 'append (CONS 'list (THE LIST (MAPCAR 'sequentise-t* V143)))
      'Sequents))))
  (T (implementration_error 'return-sequents))))

(DEFUN store-and-fail (V152 V153) 
 (DECLARE (IGNORE V153))
 (PUSH (deref V152) *multi*) 
 NIL)

(DEFMACRO lkb (V) `(CDR (ASSOC (QUOTE ,V) *alist*)))  

(DEFUN sequentise-t* (V154)
 (COND
  ((AND (CONSP V154) (EQ 't* (CAR V154)) (CONSP (CDR V154))
    (CONSP (CDR (CDR V154))) (NULL (CDR (CDR (CDR V154)))))
   (LET* ((V155 (CDR V154))) (LIST '@p (CAR (CDR V155)) (CAR V155))))
  (T (implementation_error 'sequentise-t*))))

(DEFUN rule-abstraction (V156 V157)
 (COND
  ((EQ 'single V156)
   #'(LAMBDA (Sequents)
      (if (THE SYMBOL (empty? Sequents)) Sequents
       (LET ((Sequent (head Sequents)))
        (LET ((Conclusion (snd Sequent)))
         (LET ((Assumptions (fst Sequent)))
          (LET ((Tail (tail Sequents)))
           (LET ((Result (FUNCALL V157 Conclusion Assumptions Tail '_)))
            (if (qi_= Result 'success) Tail
             (if (THE SYMBOL (empty? Result)) Sequents Result))))))))))
  ((EQ 'multi V156)
   #'(LAMBDA (Sequents)
      (if (THE SYMBOL (empty? Sequents)) Sequents
       (LET ((Sequent (head Sequents)))
        (LET ((Conclusion (snd Sequent)))
         (LET ((Assumptions (fst Sequent)))
          (LET ((Tail (tail Sequents)))
           (LET ((Multi (SETQ *multi* NIL)))
            (LET ((Result (FUNCALL V157 Conclusion Assumptions Tail '_)))
             Result)))))))))
  (T (implementration_error 'rule-abstraction))))