; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFUN lineread NIL (lineread_loop (READ-CHAR) NIL))

(DEFUN lineread_loop (V3 V4)
 (COND ((abort? V3 V4) (error "line read aborted"))
  ((MEMBER V3 (LIST #\Newline #\Return) :TEST 'CHAR-EQUAL)
   (LET ((Line (compile '<st_input> V4)))
    (IF (OR (EQ Line 'fail!) (NULL Line))
        (lineread_loop (READ-CHAR) (APPEND V4 (LIST V3)))
        Line)))
  (T (lineread_loop (READ-CHAR) (APPEND V4 (LIST V3))))))

(DEFUN abort? (C Cs) (AND (CHAR-EQUAL C #\^) (unescaped? Cs)))

(DEFUN unescaped? (Cs)
  (COND ((NULL Cs))
        ((AND (CONSP Cs) (NULL (CDR Cs))) (NOT (EQL (CAR Cs) *esc*)))
        (T (unescaped? (CDR Cs)))))
 
(DEFUN read-file (V5)
 (LET
  ((ErrorString
    (FORMAT NIL "parse failure of file ~A here: ~~%~~%~~{~~C~~} ..." V5)))
  (LET ((Chars (read-file-as-charlist V5)))
       (compile '<st_input> Chars ErrorString))))

(DEFUN <st_input> (Stream)
 (OR
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\[))
    (LET
     ((<st_input1> (<st_input1> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <st_input1>))
      (IF
       (AND (CONSP (FIRST <st_input1>)) (EQL (FIRST (FIRST <st_input1>)) #\]))
       (LET
        ((<st_input2>
          (<st_input2>
           (LIST (REST (FIRST <st_input1>)) (SECOND <st_input1>)))))
        (IF (NOT (failure? <st_input2>))
         (LIST (FIRST <st_input2>)
          (CONS (user-syntax-in (cons_form (SECOND <st_input1>))) (SECOND <st_input2>)))
         NIL))
       NIL)
      NIL))
    NIL))
   (BLOCK localfailure
  (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\())
   (LET
    ((<st_input1> (<st_input1> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
    (IF (NOT (failure? <st_input1>))
     (IF
      (AND (CONSP (FIRST <st_input1>)) (EQL (FIRST (FIRST <st_input1>)) #\)))
      (LET
       ((<st_input2>
         (<st_input2>
          (LIST (REST (FIRST <st_input1>)) (SECOND <st_input1>)))))
       (IF (NOT (failure? <st_input2>))
        (LIST (FIRST <st_input2>)
         (CONS (user-syntax-in (proc_specialforms (SECOND <st_input1>))) (SECOND <st_input2>)))
        NIL))
      NIL)
     NIL))
   NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\|))
    (LET
     ((<st_input> (<st_input> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <st_input>))
      (LIST (FIRST <st_input>) (CONS 'bar# (SECOND <st_input>))) NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\{))
    (LET
     ((<st_input> (<st_input> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <st_input>))
      (LIST (FIRST <st_input>) (CONS '{ (SECOND <st_input>))) NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\}))
    (LET
     ((<st_input> (<st_input> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <st_input>))
      (LIST (FIRST <st_input>) (CONS '} (SECOND <st_input>))) NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\;))
    (LET
     ((<st_input> (<st_input> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <st_input>))
      (LIST (FIRST <st_input>) (CONS (semi-colon) (SECOND <st_input>))) NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\,))
    (LET
     ((<st_input> (<st_input> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <st_input>))
      (LIST (FIRST <st_input>) (CONS (comma) (SECOND <st_input>))) NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\"))
    (LET ((<string> (<string> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <string>))
      (IF (AND (CONSP (FIRST <string>)) (EQL (FIRST (FIRST <string>)) #\"))
       (LET
        ((<st_input>
          (<st_input> (LIST (REST (FIRST <string>)) (SECOND <string>)))))
        (IF (NOT (failure? <st_input>))
         (LIST (FIRST <st_input>)
          (CONS (FORMAT NIL "~{~A~}" (SECOND <string>)) (SECOND <st_input>)))
         NIL))
       NIL)
      NIL))
    NIL))
  (BLOCK localfailure
   (LET ((<character> (<character> Stream)))
    (IF (NOT (failure? <character>))
     (LET ((<st_input> (<st_input> <character>)))
      (IF (NOT (failure? <st_input>))
       (LIST (FIRST <st_input>)
        (CONS (user-syntax-in (tokenise (SECOND <character>))) (SECOND <st_input>)))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<comment> (<comment> Stream)))
    (IF (NOT (failure? <comment>))
     (LET ((<st_input> (<st_input> <comment>)))
      (IF (NOT (failure? <st_input>)) <st_input> NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<token> (<token> Stream)))
    (IF (NOT (failure? <token>))
     (LET ((<st_input> (<st_input> <token>)))
      (IF (NOT (failure? <st_input>))
       (LIST (FIRST <st_input>)
        (CONS (user-syntax-in (tokenise (SECOND <token>))) (SECOND <st_input>)))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<whitespaces> (<whitespaces> Stream)))
    (IF (NOT (failure? <whitespaces>))
     (LET ((<st_input> (<st_input> <whitespaces>)))
      (IF (NOT (failure? <st_input>)) <st_input> NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN comma () '|,|)

(DEFUN esc () #\Escape)

(DEFUN proc_specialforms (V1)
 (COND
  ((AND (CONSP V1) (EQ '/. (CAR V1)) (CONSP (CDR V1)) (CONSP (CDR (CDR V1)))
    (CONSP (CDR (CDR (CDR V1)))))
   (LET* ((V2 (CDR V1)))
    (LIST '/. (CAR V2) (proc_specialforms (CONS '/. (CDR V2))))))
  ((AND (CONSP V1) (EQ 'let (CAR V1)) (CONSP (CDR V1)) (CONSP (CDR (CDR V1)))
    (CONSP (CDR (CDR (CDR V1)))) (CONSP (CDR (CDR (CDR (CDR V1))))))
   (LET* ((V3 (CDR V1)) (V4 (CDR V3)))
    (LIST 'let (CAR V3) (CAR V4) (proc_specialforms (CONS 'let (CDR V4))))))
  ((AND (CONSP V1) (EQ '@p (CAR V1)) (CONSP (CDR V1)) (CONSP (CDR (CDR V1)))
    (CONSP (CDR (CDR (CDR V1)))))
   (LET* ((V5 (CDR V1)))
    (LIST '@p (CAR V5) (proc_specialforms (CONS '@p (CDR V5))))))
  ((AND (CONSP V1) (CONSP (CDR V1)) (CONSP (CDR (CDR V1)))
    (CONSP (CDR (CDR (CDR V1)))) (wrapper (associative? (CAR V1))))
   (LET* ((V6 (CAR V1)) (V7 (CDR V1)))
    (LIST V6 (CAR V7) (proc_specialforms (CONS V6 (CDR V7))))))
  ((AND (CONSP V1) (EQ 'define (CAR V1)) (CONSP (CDR V1))
    (CONSP (CDR (CDR V1))) (EQ '{ (CAR (CDR (CDR V1))))
    (MEMBER '} (CDR (CDR (CDR V1)))))
   (LET* ((V8 (CDR V1)) (V9 (CDR V8)) (V10 (CDR V9)))
    (LET ((Signature (normalise-type (curry-type (collect-signature V10)))))
     (LET ((Rules (collect-rules V10)))
      (CONS 'define
       (CONS (CAR V8)
        (CONS '{ (THE LIST (APPEND Signature (LIST '}) Rules)))))))))
  (T V1)))

(DEFUN semi-colon () '|;|)

(DEFUN user-syntax-in (X) (apply-user-syntax X *syntax-in*))

(DEFUN collect-rules (V557)
 (COND ((AND (CONSP V557) (EQ '} (CAR V557))) (CDR V557))
  ((CONSP V557) (collect-rules (CDR V557))) 
  (T (implementation_error 'collect-rules))))

(DEFUN collect-signature (V552)
 (COND ((AND (CONSP V552) (EQ '} (CAR V552))) NIL)
  ((CONSP V552) (CONS (CAR V552) (collect-signature (CDR V552))))
  (T (implementation_error 'collect-signature))))

(DEFUN associative? (V549)
 (COND ((EQ '+ V549) 'true) ((EQ '* V549) 'true) ((EQ 'and V549) 'true)
  ((EQ 'or V549) 'true) ((EQ 'append V549) 'true) (T 'false)))

(SETQ *syntax-in* NIL)

(DEFUN sugar (DIRECTION F N)
  (IF (NOT (SYMBOLP F)) (ERROR "~A must be a symbol~%" F))
  (COND ((EQ DIRECTION 'in) (SETQ *syntax-in* (set-user-syntax F N *syntax-in*)))
        ((EQ DIRECTION 'out) (SETQ *syntax-out* (set-user-syntax F N *syntax-out*)))
        (T (ERROR "direction must be in or out~%")))
  F)

(DEFUN sugar-list (DIRECTION)
  (COND ((EQ DIRECTION 'in) *syntax-in*)
        ((EQ DIRECTION 'out) *syntax-out*)
        (T (ERROR "direction must be in or out~%"))))
 
(DEFUN unsugar (F)
 (SETQ *syntax-in* (remove F *syntax-in*)) 
 (SETQ *syntax-out* (remove F *syntax-out*))
 F)   

(DEFUN apply-user-syntax (X Fs)
   (IF (NULL Fs)
       X
       (apply-user-syntax (FUNCALL (CAR Fs) X) (CDR Fs))))

(DEFUN syntax-in (F N)
  (SETQ *syntax-in* (set-user-syntax F N *syntax-in*)))

(DEFUN set-user-syntax (V5 V6 V7)
 (COND ((EQL -1 V6) (THE LIST (REMOVE V5 V7))) 
  ((EQL 1 V6) (CONS V5 V7))
  ((NULL V7) (LIST V5))
  ((CONSP V7) (CONS (CAR V7) (set-user-syntax V5 (1- V6) (CDR V7))))
  (T (implementation_error 'set-user-syntax))))
   
(DEFUN <character> (Stream)
 (OR
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\#))
    (IF
     (AND (CONSP (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))))
      (EQL (FIRST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))) #\\))
     (LET
      ((<token>
        (<token>
         (LIST (REST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))))
          (SECOND (LIST (REST (FIRST Stream)) (SECOND Stream)))))))
      (IF (NOT (failure? <token>))
       (LIST (FIRST <token>) (CONS #\# (CONS #\\ (SECOND <token>)))) NIL))
     NIL)
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\#))
    (IF
     (AND (CONSP (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))))
      (EQL (FIRST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))) #\\))
     (LET
      ((<it>
        (<it>
         (LIST (REST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))))
          (SECOND (LIST (REST (FIRST Stream)) (SECOND Stream)))))))
      (IF (NOT (failure? <it>))
       (LIST (FIRST <it>) (CONS #\# (CONS #\\ (SECOND <it>)))) NIL))
     NIL)
    NIL))))

(DEFUN <it> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (CONS (CAAR Stream) NIL))
    NIL))))

(DEFUN <st_input1> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<st_input> (<st_input> Stream)))
    (IF (NOT (failure? <st_input>)) <st_input> NIL)))))

(DEFUN <st_input2> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<st_input> (<st_input> Stream)))
    (IF (NOT (failure? <st_input>)) <st_input> NIL)))))

(DEFUN <comment> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<st> (<st> Stream)))
    (IF (NOT (failure? <st>))
     (LET ((<any> (<any> <st>)))
      (IF (NOT (failure? <any>)) (LIST (FIRST <any>) NIL) NIL))
     NIL)))))

(DEFUN <any> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<ed> (<ed> Stream))) (IF (NOT (failure? <ed>)) <ed> NIL)))
  (BLOCK localfailure
   (LET ((<comment> (<comment> Stream)))
    (IF (NOT (failure? <comment>))
     (LET ((<any> (<any> <comment>)))
      (IF (NOT (failure? <any>))
       (LIST (FIRST <any>) (APPEND (SECOND <comment>) (SECOND <any>))) NIL))
     NIL)))
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LET ((<any> (<any> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <any>))
      (LIST (FIRST <any>) (CONS (CAAR Stream) (SECOND <any>))) NIL))
    NIL))))

(DEFUN <st> (V1) (pre *st* V1))

(DEFUN <ed> (V2) (pre *ed* V2))

(DEFUN pre (V11 V12)
 (COND
  ((AND (NULL V11) (CONSP V12) (CONSP (CDR V12)) (NULL (CDR (CDR V12)))) V12)
  ((AND (CONSP V11) (CONSP V12) (CONSP (CAR V12)) (CONSP (CDR V12))
    (NULL (CDR (CDR V12))) (EQL (CAR (CAR V12)) (CAR V11)))
   (pre (CDR V11) (CONS (CDR (CAR V12)) (CDR V12))))
  (T NIL)))

(DEFUN set-comment-delimiter-start (V14) (SETQ *st* V14))

(DEFUN set-comment-delimiter-end (V15) (SETQ *ed* V15))

(SETQ *st* '(#\\))

(SETQ *ed* '(#\\))

(DEFUN <string> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<esc> (<esc> Stream)))
    (IF (NOT (failure? <esc>))
     (LET ((<it> (<it> <esc>)))
      (IF (NOT (failure? <it>))
       (LET ((<string> (<string> <it>)))
        (IF (NOT (failure? <string>))
         (LIST (FIRST <string>)
          (APPEND (SECOND <esc>) (APPEND (SECOND <it>) (SECOND <string>))))
         NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<string-char> (<string-char> Stream)))
    (IF (NOT (failure? <string-char>))
     (LET ((<string> (<string> <string-char>)))
      (IF (NOT (failure? <string>))
       (LIST (FIRST <string>)
        (APPEND (SECOND <string-char>) (SECOND <string>)))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN <string-char> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (IF (CHAR-EQUAL (CAAR Stream) #\") (RETURN-FROM localfailure NIL)
      (CONS (CAAR Stream) NIL)))
    NIL))))

(DEFUN <esc> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (IF (EQL (CAAR Stream) *esc*) NIL
      (RETURN-FROM localfailure NIL)))
    NIL))))

(DEFUN set-escape-character (V16) (SETQ *esc* V16))

(SETQ *esc* NIL)

(DEFUN <token> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<alphanum> (<alphanum> Stream)))
    (IF (NOT (failure? <alphanum>))
     (LET ((<token> (<token> <alphanum>)))
      (IF (NOT (failure? <token>))
       (LIST (FIRST <token>) (CONS (SECOND <alphanum>) (SECOND <token>))) NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<alphanum> (<alphanum> Stream)))
    (IF (NOT (failure? <alphanum>))
     (LIST (FIRST <alphanum>) (CONS (SECOND <alphanum>) NIL)) NIL)))))

(DEFUN tokenise (V121)
 (COND ((AND (CONSP V121) (EQL #\> (CAR V121)) (NULL (CDR V121))) 'qi_>)
  ((AND (CONSP V121) (EQL #\> (CAR V121)) (NULL (CDR V121))) 'qi_>)
  ((AND (CONSP V121) (EQL #\< (CAR V121)) (NULL (CDR V121))) 'qi_<)
  ((AND (CONSP V121) (EQL #\= (CAR V121)) (NULL (CDR V121))) 'qi_=)
  ((AND (CONSP V121) (EQL #\: (CAR V121)) (NULL (CDR V121))) (colon))
  ((AND (CONSP V121) (EQL #\> (CAR V121)) (CONSP (CDR V121))
    (EQL #\= (CAR (CDR V121))) (NULL (CDR (CDR V121))))
   'qi_>=)
  ((AND (CONSP V121) (EQL #\< (CAR V121)) (CONSP (CDR V121))
    (EQL #\= (CAR (CDR V121))) (NULL (CDR (CDR V121))))
   'qi_<=)
  (T (READ-FROM-STRING (FORMAT NIL "~{~C~}" V121)))))

(DEFUN colon () '|:|)

(DEFUN <alphanum> (Stream)
 (OR
  (BLOCK localfailure
   (IF
    (AND (CONSP (FIRST Stream)) (wrapper (alpha? (FIRST (FIRST Stream)))))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))) (CAAR Stream))
    NIL))))

(DEFUN alpha? (V17)
 (IF
  (MEMBER V17
   '(#\; #\, #\\ #\[ #\] #\( #\) #\} #\{ #\" #\Space #\Return #\Newline #\Tab #\|)
   :TEST 'CHAR-EQUAL)
  'false 'true))

(DEFUN <whitespaces> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<whitespace> (<whitespace> Stream)))
    (IF (NOT (failure? <whitespace>))
     (LET ((<whitespaces> (<whitespaces> <whitespace>)))
      (IF (NOT (failure? <whitespaces>)) (LIST (FIRST <whitespaces>) NIL) NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<whitespace> (<whitespace> Stream)))
    (IF (NOT (failure? <whitespace>)) (LIST (FIRST <whitespace>) NIL) NIL)))))

(DEFUN <whitespace> (Stream)
 (OR
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\Space))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (CONS #\Space NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\Return))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (CONS #\Return NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\Newline))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (CONS #\Newline NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQL (FIRST (FIRST Stream)) #\Tab))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (CONS #\Tab NIL))
    NIL))))

(DEFUN cons_form (V18)
 (COND ((NULL V18) NIL) 
  ((AND (CONSP V18) (CONSP (CDR V18)) (EQ 'bar# (CAR (CDR V18)))
    (CONSP (CDR (CDR V18))) (NULL (CDR (CDR (CDR V18)))))
   (CONS 'cons (CONS (CAR V18) (CDR (CDR V18)))))
  ((CONSP V18) (LIST 'cons (CAR V18) (cons_form (CDR V18))))
  (T V18)))
