/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.xquery.XQException;
import net.xqj.core.Factory;
import net.xqj.core.XQToolkit;
import net.xqj.core.XQueryCorrectorWriter;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.toolkit.ReoFactory;
import net.xqj.core.util.StringWriter;
import net.xqj.core.xqitem.XQItemBase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class MemoryXMLXQItem
extends XQItemBase
implements Cloneable {
    private char[] value;
    private int offset;
    private int length;
    private Node nodeValue = null;

    private MemoryXMLXQItem(char[] lexicalRepresentation) {
        this(lexicalRepresentation, 0, lexicalRepresentation.length);
    }

    private MemoryXMLXQItem(char[] lexicalRepresentation, int offset, int length) {
        this.value = lexicalRepresentation;
        this.offset = offset;
        this.length = length;
    }

    public void setTextValue(char[] buffer, int offset, int length) {
        this.nodeValue = null;
        this.value = buffer;
        this.offset = offset;
        this.length = length;
    }

    static final MemoryXMLXQItem newInstance(char[] lexicalRepresentation) {
        return new MemoryXMLXQItem(lexicalRepresentation);
    }

    static final MemoryXMLXQItem newInstance(char[] lexicalRepresentation, int offset, int length) {
        return new MemoryXMLXQItem(lexicalRepresentation, offset, length);
    }

    @Override
    public Node getNode() throws XQException {
        if (this.nodeValue != null) {
            return this.nodeValue;
        }
        DOMResult result = new DOMResult();
        this.writeItemToResult(result);
        this.nodeValue = ((Document)result.getNode()).getDocumentElement();
        return this.nodeValue;
    }

    @Override
    public Object getObject() throws XQException {
        return this.getNode();
    }

    @Override
    public XMLStreamReader getItemAsStream() throws XQException {
        return Factory.newXMLStreamReader(new CharArrayReader(this.value, this.offset, this.length));
    }

    @Override
    public String getItemAsString(Properties props) throws XQException {
        StringWriter writer = ReoFactory.getInstance().getStringWriter();
        this.writeItem(writer, props);
        String retValue = writer.toString();
        ReoFactory.getInstance().returnStringWriter(writer);
        return retValue;
    }

    @Override
    public void writeItem(OutputStream out, Properties properties) throws XQException {
        this.writeItem(Factory.newWriter(out, properties == null ? null : properties.getProperty("encoding"), properties == null ? false : "yes".equals(properties.getProperty("byte-order-mark"))), properties);
    }

    @Override
    public void writeItem(Writer writer, Properties properties) throws XQException {
        if (!XQToolkit.isToWriteXQuery(properties)) {
            XQToolkit.writeXML(this.value, this.offset, this.length, writer, properties);
            return;
        }
        XQueryCorrectorWriter xqWriter = Factory.newXQueryCorrector(writer);
        XQToolkit.writeXML(this.value, this.offset, this.length, xqWriter, properties);
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJMX001", e);
        }
    }

    @Override
    public void writeItemToSAX(ContentHandler saxhdlr) throws XQException {
        XQToolkit.writeXML(this.value, this.offset, this.length, saxhdlr);
    }

    @Override
    public void writeItemToResult(Result result) throws XQException {
        XQToolkit.writeXML(this.value, this.offset, this.length, result);
    }

    @Override
    public Object clone() {
        MemoryXMLXQItem newItem = (MemoryXMLXQItem)super.clone();
        newItem.value = XQToolkit.copyOfRange(this.value, this.offset, this.offset + this.length);
        newItem.offset = 0;
        if (newItem.nodeValue != null) {
            newItem.nodeValue = this.nodeValue.cloneNode(true);
        }
        return newItem;
    }
}

