/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.grammar;

import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.Arrays;

public class Literal
extends Term {
    private final boolean deleted;
    private final String value;
    private final boolean isHex;
    private int[] codepoints;
    private final int hashCode;

    public Literal(boolean deleted, String value, boolean isHex) {
        int[] nArray;
        this.deleted = deleted;
        this.value = value;
        this.isHex = isHex;
        if (isHex) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = Codepoint.of(value.substring(1));
        } else {
            nArray = value.codePoints().toArray();
        }
        this.codepoints = nArray;
        int prime = 31;
        int h = 1;
        h = 31 * h + Arrays.hashCode(this.codepoints);
        this.hashCode = h = 31 * h + (deleted ? 1231 : 1237);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int[] getCodepoints() {
        return this.codepoints;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public String toString() {
        return (this.deleted ? "-" : "") + (String)(this.isHex ? this.value : "'" + this.value.replace("'", "''") + "'");
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Literal)) {
            return false;
        }
        Literal other = (Literal)obj;
        if (this.deleted != other.deleted) {
            return false;
        }
        return Arrays.equals(this.codepoints, other.codepoints);
    }
}

