/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.websocket.common;

import java.nio.ByteBuffer;
import org.eclipse.jetty.ee9.websocket.api.Frame;

public class JettyWebSocketFrame
implements Frame {
    private final org.eclipse.jetty.websocket.core.Frame frame;

    public JettyWebSocketFrame(org.eclipse.jetty.websocket.core.Frame frame) {
        this.frame = frame;
    }

    public byte[] getMask() {
        return this.frame.getMask();
    }

    public byte getOpCode() {
        return this.frame.getOpCode();
    }

    public ByteBuffer getPayload() {
        return this.frame.getPayload().asReadOnlyBuffer();
    }

    public int getPayloadLength() {
        return this.frame.getPayloadLength();
    }

    public Frame.Type getType() {
        return Frame.Type.from((byte)this.getOpCode());
    }

    public boolean hasPayload() {
        return this.frame.hasPayload();
    }

    public boolean isFin() {
        return this.frame.isFin();
    }

    public boolean isMasked() {
        return this.frame.isMasked();
    }

    public boolean isRsv1() {
        return this.frame.isRsv1();
    }

    public boolean isRsv2() {
        return this.frame.isRsv2();
    }

    public boolean isRsv3() {
        return this.frame.isRsv3();
    }

    public String toString() {
        return this.frame.toString();
    }
}

