/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Map;
import java.util.TimerTask;
import org.basex.api.client.ClientSession;
import org.basex.core.BaseXException;
import org.basex.core.CLI;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.server.ClientListener;
import org.basex.server.LoginException;
import org.basex.util.MainParser;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.log.LogType;

public final class BaseXServer
extends CLI
implements Runnable {
    private final HashSet<ClientListener> authorizing = new HashSet();
    private volatile boolean running;
    private volatile boolean stop;
    private ServerSocket socket;
    private boolean service;
    private boolean daemon;
    private boolean quiet;
    private IOFile stopFile;

    public static void main(String ... args) {
        try {
            new BaseXServer(args);
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    public BaseXServer(String ... args) throws IOException {
        this(new Context(), args);
        this.context.initServer();
    }

    public BaseXServer(Context ctx, String ... args) throws IOException {
        super(ctx, args);
        InetAddress addr;
        if (!this.quiet && !this.daemon) {
            Util.println(this.header(), new Object[0]);
        }
        StaticOptions sopts = this.context.soptions;
        int port = sopts.get(StaticOptions.SERVERPORT);
        String host = sopts.get(StaticOptions.SERVERHOST);
        InetAddress inetAddress = addr = host.isEmpty() ? null : InetAddress.getByName(host);
        if (this.stop) {
            this.stop();
            if (!this.quiet) {
                Util.println(Text.SRV_STOPPED_PORT_X, port);
            }
            Performance.sleep(1000L);
            return;
        }
        if (this.service) {
            BaseXServer.start(port, args);
            if (!this.quiet) {
                Util.println(Text.SRV_STARTED_PORT_X, port);
            }
            Performance.sleep(1000L);
            return;
        }
        try {
            this.socket = new ServerSocket();
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(addr, port));
            this.stopFile = BaseXServer.stopFile(this.getClass(), port);
        }
        catch (BindException ex) {
            this.context.log.writeServer(LogType.ERROR, Util.message(ex));
            Util.debug(ex);
            throw new BaseXException(Text.SRV_RUNNING_X, port);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.context.log.writeServer(LogType.ERROR, Util.message(ex));
            Util.debug(ex);
            throw new BaseXException(ex.getLocalizedMessage(), new Object[0]);
        }
        new Thread(this).start();
        String startX = Util.info(Text.SRV_STARTED_PORT_X, port);
        if (!this.quiet) {
            Util.println(startX, new Object[0]);
        }
        this.context.log.writeServer(LogType.OK, startX);
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        for (Map.Entry command : this.commands) {
            if (this.execute(command)) continue;
            return;
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Socket s = this.socket.accept();
                s.setTcpNoDelay(true);
                if (this.stopFile.exists()) {
                    this.close();
                    continue;
                }
                long ka = (long)this.context.soptions.get(StaticOptions.KEEPALIVE).intValue() * 1000L;
                if (ka > 0L) {
                    long ms = System.currentTimeMillis();
                    for (ClientListener cl : this.context.sessions) {
                        if (ms - cl.last <= ka) continue;
                        cl.close();
                    }
                }
                final ClientListener cl = new ClientListener(s, this.context, this);
                if (ka > 0L) {
                    cl.timeout.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            cl.close();
                        }
                    }, ka);
                    this.authorizing.add(cl);
                }
                cl.start();
            }
            catch (SocketException ex) {
                Util.debug(ex);
                break;
            }
            catch (Throwable ex) {
                Util.errln(ex, new Object[0]);
                this.context.log.writeServer(LogType.ERROR, Util.message(ex));
                break;
            }
        }
    }

    public void stop() throws IOException {
        StaticOptions sopts = this.context.soptions;
        int port = sopts.get(StaticOptions.SERVERPORT);
        String host = sopts.get(StaticOptions.SERVERHOST);
        BaseXServer.stop(host.isEmpty() ? "localhost" : host, port);
    }

    private synchronized void close() {
        if (!this.running) {
            return;
        }
        for (ClientListener cl : this.authorizing) {
            this.remove(cl);
            cl.close();
        }
        this.context.sessions.close();
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
            this.context.log.writeServer(LogType.ERROR, Util.message(ex));
        }
        int port = this.context.soptions.get(StaticOptions.SERVERPORT);
        String stopX = Util.info(Text.SRV_STOPPED_PORT_X, port);
        if (!this.quiet) {
            Util.println(stopX, new Object[0]);
        }
        this.context.log.writeServer(LogType.OK, stopX);
        this.context.close();
        if (!this.stopFile.delete()) {
            this.context.log.writeServer(LogType.ERROR, Util.info(Text.FILE_NOT_DELETED_X, this.stopFile));
        }
        this.running = false;
    }

    @Override
    protected void parseArgs() throws IOException {
        MainParser arg = new MainParser(this);
        block12: while (arg.more()) {
            if (arg.dash()) {
                switch (arg.next()) {
                    case 'c': {
                        this.commands.add(BaseXServer.commands(arg.string()));
                        continue block12;
                    }
                    case 'C': {
                        this.commands.add(BaseXServer.script(arg.string()));
                        continue block12;
                    }
                    case 'd': {
                        Prop.debug = true;
                        continue block12;
                    }
                    case 'D': {
                        this.daemon = true;
                        continue block12;
                    }
                    case 'n': {
                        this.context.soptions.set(StaticOptions.SERVERHOST, arg.string());
                        continue block12;
                    }
                    case 'p': {
                        this.context.soptions.set(StaticOptions.SERVERPORT, arg.number());
                        continue block12;
                    }
                    case 'q': {
                        this.quiet = true;
                        continue block12;
                    }
                    case 'v': {
                        this.verbose = true;
                        continue block12;
                    }
                    case 'S': {
                        this.service = !this.daemon;
                        continue block12;
                    }
                    case 'z': {
                        this.context.soptions.set(StaticOptions.LOG, "");
                        continue block12;
                    }
                }
                throw arg.usage();
            }
            if ("stop".equalsIgnoreCase(arg.string())) {
                this.stop = true;
                continue;
            }
            throw arg.usage();
        }
        if (this.service) {
            this.commands.clear();
        }
    }

    @Override
    public String header() {
        return Util.info(Text.S_CONSOLE_X, "Server");
    }

    @Override
    public String usage() {
        return Text.S_SERVERINFO;
    }

    public static void start(int port, String ... args) throws BaseXException {
        String error = Util.error(Util.start(BaseXServer.class, args), 2000);
        if (error != null) {
            throw new BaseXException(error.trim(), new Object[0]);
        }
        if (!BaseXServer.ping("localhost", port)) {
            throw new BaseXException(Text.CONNECTION_ERROR_X, port);
        }
    }

    public static boolean ping(String host, int port) {
        try {
            ClientSession cs = new ClientSession(host, port, "", "");
            cs.close();
            return false;
        }
        catch (LoginException ex) {
            Util.debug(ex);
            return true;
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }

    public static void stop(String host, int port) throws IOException {
        IOFile stopFile = BaseXServer.stopFile(BaseXServer.class, port);
        stopFile.parent().md();
        stopFile.touch();
        try (Socket s = new Socket(host, port);){
            do {
                Performance.sleep(10L);
            } while (stopFile.exists());
        }
        catch (IOException ex) {
            Util.debug(ex);
            stopFile.delete();
            throw new BaseXException(Text.CONNECTION_ERROR_X, port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ClientListener client) {
        HashSet<ClientListener> hashSet = this.authorizing;
        synchronized (hashSet) {
            client.timeout.cancel();
            this.authorizing.remove(client);
        }
    }
}

