/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Databases;
import org.basex.core.Text;
import org.basex.core.cmd.AUser;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.User;
import org.basex.core.users.Users;
import org.basex.util.Strings;

public final class AlterUser
extends AUser {
    public AlterUser(String name, String newname) {
        super(name, newname);
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        String newname = this.args[1];
        if (!Databases.validName(name)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        if (!Databases.validName(newname)) {
            return this.error(Text.NAME_INVALID_X, newname);
        }
        if (Strings.eq("admin", name, newname)) {
            return this.error(Text.ADMIN_STATIC, new Object[0]);
        }
        Users users = this.context.users;
        User user = users.get(name);
        if (user == null) {
            return this.error(Text.UNKNOWN_USER_X, name);
        }
        if (users.get(newname) != null) {
            return this.error(Text.USER_EXISTS_X, newname);
        }
        users.alter(user, newname);
        users.write();
        return this.info(Text.USER_RENAMED_X_X, name, newname);
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(String.valueOf((Object)Commands.Cmd.ALTER) + " " + String.valueOf((Object)Commands.CmdAlter.USER)).arg(0);
        if (!cb.password()) {
            cb.arg(1);
        }
    }
}

