/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.util.HashMap;
import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbNew;
import org.basex.query.up.Updates;
import org.basex.query.up.primitives.DataUpdate;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.up.primitives.db.DBAdd;
import org.basex.query.up.primitives.db.DBDelete;
import org.basex.query.up.primitives.db.DBPutBinary;
import org.basex.query.up.primitives.node.DeleteNode;
import org.basex.query.up.primitives.node.ReplaceDoc;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.list.IntList;

public final class DbPut
extends DbNew {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Data data = this.toData(qc);
        Item input = this.toNodeOrAtomItem(this.arg(1), false, qc);
        String path = this.toDbPath(this.arg(2), qc);
        HashMap<String, String> options = this.toOptions(this.arg(3), qc);
        Updates updates = qc.updates();
        IntList docs = data.resources.docs(path);
        int d = 0;
        if (input instanceof Bin) {
            if (data.inMemory()) {
                throw QueryError.DB_MAINMEM_X.get(this.info, data.meta.name);
            }
            updates.add(new DBPutBinary(data, input, path, this.info), qc);
        } else {
            DataUpdate dataUpdate;
            NewInput ni = this.toNewInput(input, path);
            if (docs.isEmpty()) {
                dataUpdate = new DBAdd(data, ni, options, true, qc, this.info);
            } else {
                ++d;
                dataUpdate = new ReplaceDoc(docs.get(d), data, ni, options, qc, this.info);
            }
            DataUpdate update = dataUpdate;
            updates.add(update, qc);
            for (ResourceType type : Resources.BINARIES) {
                IOFile bin = data.meta.file(path, type);
                if (bin == null || !bin.exists()) continue;
                updates.add(new DBDelete(data, bin, this.info), qc);
            }
        }
        int ds = docs.size();
        while (d < ds) {
            updates.add(new DeleteNode(docs.get(d), data, this.info), qc);
            ++d;
        }
        return Empty.VALUE;
    }
}

