/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.w3c.dom.ProcessingInstruction;

public final class FPI
extends FNode {
    public static final byte[] OPEN = new byte[]{60, 63};
    public static final byte[] CLOSE = new byte[]{63, 62};
    private final QNm name;
    private final byte[] value;

    public FPI(QNm name, byte[] value) {
        super(NodeType.PROCESSING_INSTRUCTION);
        this.name = name;
        this.value = value;
    }

    public FPI(ProcessingInstruction pi) {
        this(new QNm(pi.getTarget()), Token.token(pi.getData()));
    }

    @Override
    public QNm qname() {
        return this.name;
    }

    @Override
    public byte[] name() {
        return this.name.string();
    }

    @Override
    public byte[] string() {
        return this.value;
    }

    @Override
    public FPI materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) {
        return this.materialized(test, ii) ? this : new FPI(this.name, this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FPI)) return false;
        FPI f = (FPI)obj;
        if (!this.name.eq(f.name)) return false;
        if (!Token.eq(this.value, f.value)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name.string(), "value", this.value), new ExprInfo[0]);
    }

    @Override
    public void toString(QueryString qs) {
        qs.concat(OPEN, this.name.string(), " ", QueryString.toValue(this.value), CLOSE);
    }

    public static byte[] parse(byte[] atom, InputInfo info) throws QueryException {
        if (Token.contains(atom, CLOSE)) {
            throw QueryError.CPICONT_X.get(info, new Object[]{atom});
        }
        return atom;
    }
}

