/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;
import java.util.function.BiConsumer;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public abstract class ASet {
    public static final int INITIAL_CAPACITY = 2;
    protected int[] buckets;
    protected int[] next;
    protected int size = 1;

    protected ASet() {
    }

    protected ASet(long capacity) {
        int s = Array.checkCapacity(Long.highestOneBit(capacity + 1L) << 1);
        this.buckets = new int[s];
        this.next = new int[s];
    }

    protected void clear() {
        Arrays.fill(this.buckets, 0);
        this.size = 1;
    }

    public final int size() {
        return this.size - 1;
    }

    public final boolean isEmpty() {
        return this.size == 1;
    }

    protected final boolean checkCapacity() {
        return this.checkCapacity((index, bucket) -> {});
    }

    protected final boolean checkCapacity(BiConsumer<Integer, Integer> relocateAction) {
        if (this.size < this.capacity()) {
            return false;
        }
        int newSize = this.size << 1;
        int[] bckts = new int[newSize];
        int[] nArray = this.buckets;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int bucket;
            int i2 = bucket = nArray[i];
            while (i2 != 0) {
                int b = this.hashCode(i2) & newSize - 1;
                int nx = this.next[i2];
                relocateAction.accept(i2, b);
                this.next[i2] = bckts[b];
                bckts[b] = i2;
                i2 = nx;
            }
        }
        this.buckets = bckts;
        this.next = Arrays.copyOf(this.next, newSize);
        this.rehash(newSize);
        return true;
    }

    public final int capacity() {
        return this.next.length;
    }

    protected abstract int hashCode(int var1);

    protected abstract void rehash(int var1);

    public String toString(Object[] keys) {
        return this.toString(keys, null);
    }

    public String toString(Object[] keys, Object[] values) {
        TokenBuilder tb = new TokenBuilder().add(Util.className(this)).add(91);
        boolean more = false;
        for (int i = 1; i < this.size; ++i) {
            Object key = keys[i];
            if (key == null) continue;
            if (more) {
                tb.add(44);
            }
            tb.add(key);
            if (values != null) {
                tb.add(61).add(values[i]);
            }
            more = true;
        }
        return tb.add(93).toString();
    }
}

