/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.ASet;

public final class WeakTokenSet
extends ASet {
    private WeakTokenRef[] keys;
    private ReferenceQueue<byte[]> gcedKeys = new ReferenceQueue();
    private int free;

    public WeakTokenSet() {
        super(2L);
        this.keys = new WeakTokenRef[this.capacity()];
    }

    public byte[] put(byte[] key) {
        int s;
        int h = Token.hashCode(key);
        int c = this.capacity();
        int b = h & c - 1;
        int i2 = this.buckets[b];
        while (i2 != 0) {
            byte[] stored = (byte[])this.keys[i2].get();
            if (Token.eq(key, stored)) {
                return stored;
            }
            i2 = this.next[i2];
        }
        if (this.size == c && this.free == 0) {
            this.cleanUp();
        }
        if (this.free != 0) {
            s = this.free;
            this.free = this.next[s];
        } else {
            if (this.checkCapacity((i, bucket) -> {
                this.keys[i.intValue()].bucket = bucket;
            })) {
                b = h & this.capacity() - 1;
            }
            s = this.size++;
        }
        this.next[s] = this.buckets[b];
        this.keys[s] = new WeakTokenRef(key, b, this.gcedKeys);
        this.buckets[b] = s;
        return key;
    }

    private void cleanUp() {
        WeakTokenRef key;
        block0: while ((key = (WeakTokenRef)this.gcedKeys.poll()) != null) {
            int b = key.bucket;
            int p = 0;
            int i = this.buckets[b];
            while (true) {
                if (i == 0) {
                    throw Util.notExpected();
                }
                if (key == this.keys[i]) {
                    if (p == 0) {
                        this.buckets[b] = this.next[i];
                    } else {
                        this.next[p] = this.next[i];
                    }
                    this.keys[i] = null;
                    this.next[i] = this.free;
                    this.free = i;
                    continue block0;
                }
                p = i;
                i = this.next[i];
            }
        }
    }

    @Override
    protected int hashCode(int index) {
        byte[] token = (byte[])this.keys[index].get();
        return token == null ? this.keys[index].bucket : Token.hashCode(token);
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Arrays.copyOf(this.keys, newSize);
    }

    @Override
    protected void clear() {
        this.gcedKeys = new ReferenceQueue();
        this.free = 0;
        Arrays.fill(this.keys, null);
        super.clear();
    }

    public String toString() {
        return this.toString(this.keys);
    }

    private static final class WeakTokenRef
    extends WeakReference<byte[]> {
        private int bucket;

        private WeakTokenRef(byte[] key, int bucket, ReferenceQueue<byte[]> queue) {
            super(key, queue);
            this.bucket = bucket;
        }

        public String toString() {
            byte[] token = (byte[])this.get();
            return token == null ? "null" : Token.string(token);
        }
    }
}

