/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.Value;
import org.basex.util.Strings;

public final class FileResolvePath
extends FileFn {
    @Override
    public Value eval(QueryContext qc) throws QueryException {
        Path abs;
        Path path = this.toPath(this.toString(this.arg(0), qc));
        String base = this.toStringOrNull(this.arg(1), qc);
        if (base != null) {
            Path bs = this.toPath(base);
            if (!bs.isAbsolute()) {
                throw QueryError.FILE_IS_RELATIVE_X.get(this.info, bs);
            }
            if (!Strings.endsWith(base, '/') && !Strings.endsWith(base, '\\')) {
                bs = bs.getParent();
            }
            abs = bs.resolve(path).normalize();
        } else {
            abs = FileResolvePath.absolute(path);
        }
        return FileResolvePath.get(abs, Files.isDirectory(abs, new LinkOption[0]));
    }
}

