/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import java.util.Comparator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryRTException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ValueList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.Types;

public class FnSortWith
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        Item item;
        Iter input = this.arg(0).iter(qc);
        final ValueList values = new ValueList(Seq.initialCapacity(input.size()));
        while ((item = qc.next(input)) != null) {
            values.add(item);
        }
        this.sort(values, qc);
        return new BasicIter<Item>((long)values.size()){

            @Override
            public Item get(long l) {
                return (Item)values.get((int)l);
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    protected final void sort(ValueList values, QueryContext qc) throws QueryException {
        Value comparators = this.arg(1).value(qc);
        if (comparators.isEmpty()) {
            throw QueryError.typeError((Expr)comparators, Types.ITEM_OM, this.info);
        }
        FItem[] cmps = new FItem[(int)comparators.size()];
        int c = 0;
        for (Item item : comparators) {
            cmps[c++] = this.toFunction(item, 2, qc);
        }
        Comparator comparator = (value1, value2) -> {
            try {
                for (FItem cmp : cmps) {
                    long diff = this.toLong(cmp.invoke(qc, this.info, (Value)value1, (Value)value2).item(qc, this.info));
                    if (diff == 0L) continue;
                    return Long.signum(diff);
                }
                return 0;
            }
            catch (QueryException ex) {
                throw new QueryRTException(ex);
            }
        };
        try {
            Arrays.sort((Value[])values.list, 0, values.size(), comparator);
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr input = this.arg(0);
        return this.adoptType(input);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode == CompileContext.Simplify.COUNT ? this.arg(0) : this, mode);
    }

    @Override
    public int hofIndex() {
        return 1;
    }
}

