/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.session;

import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import org.basex.http.HTTPConnection;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.java.JavaCall;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.InputInfo;
import org.basex.util.XMLToken;
import org.basex.util.list.TokenList;

public final class ASession {
    private final HttpSession session;

    public ASession(HttpSession session) {
        this.session = session;
    }

    public Str id() {
        return Str.get((String)this.session.getId());
    }

    public Dtm created() {
        return Dtm.get((long)this.session.getCreationTime());
    }

    public Dtm accessed() {
        return Dtm.get((long)this.session.getLastAccessedTime());
    }

    public Value names() {
        TokenList tl = new TokenList();
        for (String name : Collections.list(this.session.getAttributeNames())) {
            byte[] token = XMLToken.token((Object)name, (boolean)true);
            if (token == null) continue;
            tl.add((Object)token);
        }
        return StrSeq.get((TokenList)tl);
    }

    public Value get(String key, QueryContext qc, InputInfo info) throws QueryException {
        Object value = HTTPConnection.getAttribute(this.session, key);
        return value != null ? JavaCall.toValue((Object)value, (QueryContext)qc, (InputInfo)info) : null;
    }

    public void set(String name, Value value) {
        this.session.setAttribute(name, (Object)value);
    }

    public void delete(String key) {
        this.session.removeAttribute(key);
    }

    public void close() {
        this.session.invalidate();
    }
}

