/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Set;
import org.basex.query.expr.Union;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ANodeBuilder;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Except
extends Set {
    public Except(InputInfo info, Expr ... exprs) {
        super(info, exprs);
    }

    @Override
    Expr opt(CompileContext cc) throws QueryException {
        SeqType st = this.exprs[0].seqType();
        if (st.zero()) {
            return this.exprs[0];
        }
        if (!(st.type instanceof NodeType)) {
            return null;
        }
        int el = this.exprs.length;
        if (el > 2) {
            Expr union = new Union(this.info, Arrays.copyOfRange(this.exprs, 1, el)).optimize(cc);
            return new Except(this.info, this.exprs[0], union).optimize(cc);
        }
        ExprList list = new ExprList(el);
        for (Expr expr : this.exprs) {
            if (expr == Empty.VALUE || !list.isEmpty() && st.intersect(expr.seqType()) == null) {
                cc.info("remove % from %", expr, this::description);
                continue;
            }
            if (!expr.has(Flag.CNS, Flag.NDT)) {
                int same = ((Checks<Expr>)ex -> ex.equals(expr)).index(list);
                if (same == 0) {
                    return Empty.VALUE;
                }
                if (same > 0) {
                    cc.info("remove % from %", expr, this::description);
                    continue;
                }
                list.add(expr);
                continue;
            }
            list.add(expr);
        }
        this.exprs = (Expr[])list.finish();
        this.exprType.assign(st.union(Occ.ZERO)).data(this.exprs[0]);
        return null;
    }

    @Override
    And mergePredicates(Expr[] preds, CompileContext cc) throws QueryException {
        ExprList list = new ExprList(preds.length);
        for (Expr pred : preds) {
            list.add(list.isEmpty() ? pred : cc.function(Function.NOT, this.info, pred));
        }
        return new And(this.info, (Expr[])list.finish());
    }

    @Override
    Value nodes(QueryContext qc) throws QueryException {
        Item item;
        ANodeBuilder nodes = new ANodeBuilder();
        Iter iter = this.exprs[0].iter(qc);
        while ((item = qc.next(iter)) != null) {
            nodes.add(this.toNode(item));
        }
        nodes.ddo();
        int el = this.exprs.length;
        for (int e = 1; e < el && !nodes.isEmpty(); ++e) {
            Item item2;
            iter = this.exprs[e].iter(qc);
            while ((item2 = qc.next(iter)) != null) {
                nodes.removeAll(this.toNode(item2));
            }
        }
        return nodes.value(this);
    }

    @Override
    NodeIter iterate(QueryContext qc) throws QueryException {
        return new Set.SetIter(qc, this.iters(qc)){

            @Override
            public ANode next() throws QueryException {
                int i;
                int il;
                if (this.nodes == null) {
                    il = this.iter.length;
                    this.nodes = new ANode[il];
                    for (i = 0; i < il; ++i) {
                        this.next(i);
                    }
                }
                il = this.nodes.length;
                for (i = 1; i < il; ++i) {
                    if (this.nodes[0] == null) {
                        return null;
                    }
                    if (this.nodes[i] == null) continue;
                    int d = this.nodes[0].compare(this.nodes[i]);
                    if (d < 0 && i + 1 == il) break;
                    if (d == 0) {
                        this.next(0);
                        i = 0;
                    }
                    if (d <= 0) continue;
                    this.next(i--);
                }
                ANode temp = this.nodes[0];
                this.next(0);
                return temp;
            }
        };
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        Except ex = new Except(this.info, Except.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
        ex.iterative = this.iterative;
        return this.copyType(ex);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Except && super.equals(obj);
    }
}

