/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CNode;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;

abstract class CName
extends CNode {
    Expr name;

    CName(InputInfo info, SeqType seqType, boolean computed, Expr name, Expr ... exprs) {
        super(info, seqType, computed, exprs);
        this.name = name;
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.name);
        super.checkUp();
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.name = this.name.compile(cc);
        return super.compile(cc);
    }

    final QNm qname(boolean elem, QueryContext qc) throws QueryException {
        Item item = this.name.atomItem(qc, this.info);
        Type type = item.type;
        if (type == AtomType.QNAME) {
            return (QNm)item;
        }
        if (!type.isStringOrUntyped() || type == AtomType.ANY_URI) {
            throw QueryError.STRQNM_X_X.get(this.info, item.seqType(), item);
        }
        QNm qnm = qc.shared.parseQName(item.string(this.info), elem, this.sc());
        if (qnm != null) {
            return qnm;
        }
        throw QueryError.INVQNAME_X.get(this.info, item);
    }

    final byte[] ncname(boolean empty, QueryContext qc) throws QueryException {
        Item item = this.name.atomItem(qc, this.info);
        if (item == Empty.VALUE) {
            if (empty) {
                return Token.EMPTY;
            }
        } else {
            Type type = item.type;
            if (type.isStringOrUntyped() && type != AtomType.ANY_URI) {
                return Token.trim(item.string(this.info));
            }
        }
        throw QueryError.STRNCN_X_X.get(this.info, item.seqType(), item);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return this.name.inlineable(ic) && super.inlineable(ic);
    }

    @Override
    public final boolean has(Flag ... flags) {
        return this.name.has(flags) || super.has(flags);
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        return this.name.accept(visitor) && CName.visitAll(visitor, this.exprs);
    }

    @Override
    public final VarUsage count(Var var) {
        return this.name.count(var).plus(super.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = ic.inline(this.exprs);
        Expr inlined = this.name.inline(ic);
        if (inlined != null) {
            this.name = inlined;
            changed = true;
        }
        return changed ? this.optimize(ic.cc) : null;
    }

    @Override
    public final int exprSize() {
        int size = 1;
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size + this.name.exprSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CName)) return false;
        CName cname = (CName)obj;
        if (!this.name.equals(cname.name)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public final void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.name, this.exprs});
    }

    @Override
    public final void toString(QueryString qs, String kind) {
        qs.token(kind);
        Expr expr = this.name;
        if (expr instanceof QNm) {
            QNm qnm = (QNm)expr;
            qs.token(qnm.unique());
        } else {
            qs.brace(this.name);
        }
        super.toString(qs, null);
    }
}

