/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import org.basex.io.IO;
import org.basex.io.out.BufferOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveCreate;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.Value;
import org.basex.query.value.seq.Empty;

public class FileWriteBinary
extends FileFn {
    @Override
    public Value eval(QueryContext qc) throws IOException, QueryException {
        this.write(false, qc);
        return Empty.VALUE;
    }

    final void write(boolean append, QueryContext qc) throws QueryException, IOException {
        Path path = this.toTarget(this.arg(0), qc);
        Long offset = this.toLongOrNull(this.arg(2), qc);
        if (offset != null) {
            try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "rw");){
                long length = raf.length();
                if (offset < 0L || offset > length) {
                    throw QueryError.FILE_OUT_OF_RANGE_X_X.get(this.info, offset, length);
                }
                raf.seek(offset);
                raf.write(this.toBin(this.arg(1), qc).binary(this.info));
            }
        }
        try (BufferOutput out = BufferOutput.get(new FileOutputStream(path.toFile(), append));){
            if (this.arg(1).getClass() == ArchiveCreate.class) {
                ((ArchiveCreate)this.arg(1)).create(out, qc);
            } else {
                IO.write(this.toBin(this.arg(1), qc).input(this.info), out);
            }
        }
    }
}

