/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Timer;
import org.basex.BaseXServer;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.BinaryPut;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Put;
import org.basex.core.parse.CommandParser;
import org.basex.core.users.Algorithm;
import org.basex.core.users.Code;
import org.basex.core.users.User;
import org.basex.io.in.BufferInput;
import org.basex.io.in.ServerInput;
import org.basex.io.out.PrintOutput;
import org.basex.io.out.ServerOutput;
import org.basex.query.QueryException;
import org.basex.query.QueryTracer;
import org.basex.server.ClientInfo;
import org.basex.server.ServerCmd;
import org.basex.server.ServerQuery;
import org.basex.util.Performance;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.list.ByteList;
import org.basex.util.log.LogType;

public final class ClientListener
extends Thread
implements ClientInfo {
    private static final QueryTracer TRACER = new QueryTracer(){

        @Override
        public boolean moreTraces(int count) {
            return count <= 10000;
        }
    };
    public final Timer timeout = new Timer();
    public long last;
    private final HashMap<String, ServerQuery> queries = new HashMap();
    private final Performance perf = new Performance();
    private final Context context;
    private final BaseXServer server;
    private final Socket socket;
    private BufferInput in;
    private PrintOutput out;
    private Command command;
    private int id;
    private volatile boolean authenticated;
    private boolean closed;

    public ClientListener(Socket socket, Context context, BaseXServer server) {
        this.context = new Context(context, this);
        this.context.setExternal(TRACER);
        this.socket = socket;
        this.server = server;
        this.last = System.currentTimeMillis();
        this.setDaemon(true);
    }

    @Override
    public void run() {
        if (!this.authenticate()) {
            return;
        }
        try {
            while (this.authenticated) {
                String info;
                String cmd;
                ServerCmd sc;
                this.command = null;
                try {
                    int b = this.in.read();
                    if (b == -1) {
                        this.close();
                        break;
                    }
                    this.last = System.currentTimeMillis();
                    this.perf.nanoRuntime();
                    sc = ServerCmd.get(b);
                    cmd = null;
                    if (sc == ServerCmd.CREATE) {
                        this.create();
                    } else if (sc == ServerCmd.ADD) {
                        this.add();
                    } else if (sc == ServerCmd.PUT) {
                        this.put();
                    } else if (sc == ServerCmd.PUTBINARY) {
                        this.putBinary();
                    } else if (sc != ServerCmd.EXECUTE) {
                        this.query(sc);
                    } else {
                        cmd = new ByteList().add(b).add(this.in.readBytes()).toString();
                    }
                }
                catch (IOException ex) {
                    Util.debug(ex);
                    this.close();
                    break;
                }
                if (sc != ServerCmd.EXECUTE) continue;
                try {
                    this.command = CommandParser.get(cmd, this.context).parseSingle();
                    this.log(LogType.REQUEST, this.command.toString(true));
                }
                catch (QueryException ex) {
                    String msg = ex.getMessage();
                    this.log(LogType.REQUEST, cmd);
                    this.log(LogType.ERROR, msg);
                    this.out.write(0);
                    this.out.print(msg);
                    this.out.write(0);
                    this.send(false);
                    continue;
                }
                boolean ok = true;
                try {
                    this.command.execute(this.context, new ServerOutput(this.out));
                    info = this.command.info();
                }
                catch (BaseXException ex) {
                    Util.debug(ex);
                    ok = false;
                    info = ex.getMessage();
                }
                this.out.write(0);
                this.info(info, ok);
                if (!(this.command instanceof Exit)) continue;
                this.command = null;
                this.close();
            }
        }
        catch (IOException ex) {
            this.log(LogType.ERROR, Util.message(ex));
            this.command = null;
            this.close();
        }
        this.command = null;
    }

    private boolean authenticate() {
        boolean ok;
        block5: {
            ok = false;
            try {
                String nonce = Long.toString(System.nanoTime());
                byte[] address = this.socket.getInetAddress().getAddress();
                this.out = PrintOutput.get(this.socket.getOutputStream());
                this.out.print("BaseX:" + nonce);
                this.send(true);
                this.in = BufferInput.get(this.socket.getInputStream());
                String name = this.in.readString();
                String hash = this.in.readString();
                User user = this.context.users.get(name);
                boolean bl = ok = user != null && user.enabled() && Strings.md5(user.code(Algorithm.DIGEST, Code.HASH) + nonce).equals(hash);
                if (ok) {
                    this.context.user(user);
                    this.send(true);
                    this.context.blocker.remove(address);
                    this.context.sessions.add(this);
                } else {
                    if (!name.isEmpty()) {
                        this.log(LogType.ERROR, Util.info(Text.ACCESS_DENIED_X, name));
                    }
                    this.context.blocker.delay(address);
                    this.send(false);
                }
            }
            catch (IOException ex) {
                if (!ok) break block5;
                Util.stack(ex);
                this.log(LogType.ERROR, Util.message(ex));
                ok = false;
            }
        }
        this.server.remove(this);
        this.authenticated = ok;
        return ok;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Command c = this.command;
        if (c != null) {
            c.stop();
            do {
                Performance.sleep(1L);
            } while (this.command != null);
        }
        this.context.sessions.remove(this);
        try {
            if (this.context.user() != null) {
                Close.close(this.context);
            }
            this.socket.close();
        }
        catch (Throwable ex) {
            this.log(LogType.ERROR, Util.message(ex));
            Util.stack(ex);
        }
    }

    public Context context() {
        return this.context;
    }

    @Override
    public String clientName() {
        User user = this.context.user();
        return user != null ? user.name() : null;
    }

    @Override
    public String clientAddress() {
        return this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[").append(this.clientAddress()).append(']');
        if (this.context.data() != null) {
            sb.append(": ").append(this.context.data().meta.name);
        }
        return sb.toString();
    }

    private void error(String info) throws IOException {
        this.info(info, false);
    }

    private void success(String info) throws IOException {
        this.info(info, true);
    }

    private void info(String info, boolean ok) throws IOException {
        this.log(ok ? LogType.OK : LogType.ERROR, info);
        this.out.print(info);
        this.out.write(0);
        this.send(ok);
    }

    private void create() throws IOException {
        this.execute(new CreateDB(this.in.readString()));
    }

    private void add() throws IOException {
        this.execute(new Add(this.in.readString()));
    }

    private void put() throws IOException {
        this.execute(new Put(this.in.readString()));
    }

    private void putBinary() throws IOException {
        this.execute(new BinaryPut(this.in.readString()));
    }

    private void execute(Command cmd) throws IOException {
        this.log(LogType.REQUEST, String.valueOf(cmd) + " [...]");
        ServerInput si = new ServerInput(this.in);
        try {
            cmd.setInput(si);
            cmd.execute(this.context);
            this.success(cmd.info());
        }
        catch (BaseXException ex) {
            si.flush();
            this.error(ex.getMessage());
        }
    }

    private void query(ServerCmd sc) throws IOException {
        String arg = this.in.readString();
        String error = null;
        try {
            StringBuilder info = new StringBuilder();
            if (sc == ServerCmd.QUERY) {
                String query = arg;
                ServerQuery qp = new ServerQuery(query, this.context);
                arg = Integer.toString(this.id++);
                this.queries.put(arg, qp);
                this.out.print(arg);
                this.out.write(0);
                info.append(query);
            } else {
                ServerQuery qp = this.queries.get(arg);
                if (qp == null) {
                    if (sc != ServerCmd.CLOSE) {
                        throw new IOException("Unknown Query ID: " + arg);
                    }
                } else if (sc == ServerCmd.BIND) {
                    String key = this.in.readString();
                    String val = this.in.readString();
                    String typ = this.in.readString();
                    qp.bind(key, val, typ);
                    info.append(key).append('=').append(val);
                    if (!typ.isEmpty()) {
                        info.append(" as ").append(typ);
                    }
                } else if (sc == ServerCmd.CONTEXT) {
                    String val = this.in.readString();
                    String typ = this.in.readString();
                    qp.context(val, typ);
                    info.append(val);
                    if (!typ.isEmpty()) {
                        info.append(" as ").append(typ);
                    }
                } else if (sc == ServerCmd.RESULTS) {
                    qp.execute(this.out, true, true, false);
                } else if (sc == ServerCmd.EXEC) {
                    qp.execute(this.out, false, true, false);
                } else if (sc == ServerCmd.FULL) {
                    qp.execute(this.out, true, true, true);
                } else if (sc == ServerCmd.INFO) {
                    this.out.print(qp.info());
                } else if (sc == ServerCmd.OPTIONS) {
                    this.out.print(qp.parameters());
                } else if (sc == ServerCmd.UPDATING) {
                    this.out.print(Boolean.toString(qp.updating()));
                } else if (sc == ServerCmd.CLOSE) {
                    this.queries.remove(arg);
                } else if (sc == ServerCmd.NEXT) {
                    throw new Exception("Protocol for query iteration is out-of-date.");
                }
                this.out.write(0);
            }
            this.out.write(0);
            this.log(LogType.OK, sc.toString() + "[" + arg + "] " + String.valueOf(info));
        }
        catch (Throwable ex) {
            error = ex instanceof RuntimeException ? Util.bug(ex) : Util.message(ex);
            this.log(LogType.REQUEST, String.valueOf((Object)sc) + "[" + arg + "]");
            this.log(LogType.ERROR, error);
            this.queries.remove(arg);
        }
        if (error != null) {
            this.out.write(0);
            this.out.write(1);
            this.out.print(error);
            this.out.write(0);
        }
        this.out.flush();
    }

    private void send(boolean ok) throws IOException {
        this.out.write(ok ? 0 : 1);
        this.out.flush();
    }

    private void log(LogType type, String info) {
        this.context.log.write((Object)type, info, this.perf, this.context);
    }
}

