/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.tools.st;

import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import io.github.applecommander.applesingle.AppleSingle;
import io.github.applecommander.applesingle.Utilities;
import io.github.applecommander.bastools.api.Configuration;
import io.github.applecommander.bastools.api.Parser;
import io.github.applecommander.bastools.api.TokenReader;
import io.github.applecommander.bastools.api.Visitors;
import io.github.applecommander.bastools.api.model.Program;
import io.github.applecommander.bastools.api.shapes.BitmapShape;
import io.github.applecommander.bastools.api.shapes.Shape;
import io.github.applecommander.bastools.api.shapes.ShapeGenerator;
import io.github.applecommander.bastools.api.shapes.ShapeTable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="generate", description={"Generate a shape table from source code"}, parameterListHeading="%nParameters:%n", descriptionHeading="%n", optionListHeading="%nOptions:%n")
public class GenerateCommand
implements Callable<Void> {
    public static final int BIN = 6;
    @CommandLine.Option(names={"-h", "--help"}, description={"Show help for subcommand"}, usageHelp=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--stdin"}, description={"Read from stdin"})
    private boolean stdinFlag;
    @CommandLine.Option(names={"--stdout"}, description={"Write to stdout"})
    private boolean stdoutFlag;
    @CommandLine.Option(names={"--single"}, description={"Write to AppleSingle file (requires address, defaults to 0x6000)"})
    private boolean applesingleFlag;
    @CommandLine.Option(names={"--address"}, description={"Address for AppleSingle file"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int address = 24576;
    @CommandLine.Option(names={"--name"}, description={"Filename assign in AppleSingle file"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String realName = "SHAPES.BIN";
    @CommandLine.Option(names={"--demo-code"}, description={"Generate a ProDOS .po image with Applesoft BASIC code demoing the shape table"})
    private boolean demoCodeFlag;
    @CommandLine.Option(names={"-o", "--output"}, description={"Write output to file"})
    private Path outputFile;
    @CommandLine.Parameters(arity="0..1", description={"File to process"})
    private Path inputFile;

    @Override
    public Void call() throws IOException, DiskException {
        this.validateArguments();
        ShapeTable st = this.stdinFlag ? ShapeGenerator.generate((InputStream)System.in) : ShapeGenerator.generate((Path)this.inputFile);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        st.write((OutputStream)byteStream);
        if (this.demoCodeFlag) {
            byteStream.reset();
            byteStream.write(this.generateDemoCode(st));
        } else if (this.applesingleFlag) {
            AppleSingle applesingle = AppleSingle.builder().realName(this.realName).dataFork(byteStream.toByteArray()).auxType(this.address).fileType(6).build();
            byteStream.reset();
            applesingle.save((OutputStream)byteStream);
        }
        if (this.stdoutFlag) {
            System.out.write(byteStream.toByteArray());
        } else {
            try (OutputStream outputStream = Files.newOutputStream(this.outputFile, new OpenOption[0]);){
                outputStream.write(byteStream.toByteArray());
            }
        }
        return null;
    }

    private void validateArguments() throws IOException {
        if (this.stdoutFlag && this.outputFile != null) {
            throw new IOException("Please choose one of stdout or output file");
        }
        if (this.stdinFlag && this.inputFile != null || !this.stdinFlag && this.inputFile == null) {
            throw new IOException("Please select ONE of stdin or file");
        }
        if (this.demoCodeFlag && this.applesingleFlag) {
            System.err.println("Warning: Demo code and AppleSingle exclusive, ignoring AppleSingle request.");
            this.applesingleFlag = false;
        }
        if (!this.stdoutFlag && this.outputFile == null) {
            this.outputFile = Paths.get("shape.out", new String[0]);
        }
    }

    private byte[] generateDemoCode(ShapeTable shapeTable) throws IOException, DiskException {
        List blist = shapeTable.shapes.stream().map(Shape::toBitmap).collect(Collectors.toList());
        int width = blist.stream().mapToInt(BitmapShape::getWidth).max().getAsInt();
        int height = blist.stream().mapToInt(BitmapShape::getHeight).max().getAsInt();
        String demoProgram = new String(Utilities.toByteArray((InputStream)this.getClass().getResourceAsStream("/demo-template.bas"))).replace("$SOURCE$", this.stdinFlag ? "STDIN" : this.inputFile.toFile().getName().toUpperCase()).replace("$COUNT$", Integer.toString(shapeTable.shapes.size())).replace("$WIDTH$", Integer.toString(width)).replace("$HEIGHT$", Integer.toString(height));
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(demoProgram.getBytes());
        Configuration config = Configuration.builder().sourceFile(new File("FAKEFILE")).build();
        Queue tokens = TokenReader.tokenize((InputStream)sourceStream);
        Parser parser = new Parser(tokens);
        Program program = parser.parse();
        byte[] programBytes = Visitors.byteVisitor((Configuration)config).dump(program);
        ByteArrayOutputStream shapeTableStream = new ByteArrayOutputStream();
        shapeTable.write((OutputStream)shapeTableStream);
        byte[] shapeTableBytes = shapeTableStream.toByteArray();
        byte[] templateBytes = Utilities.toByteArray((InputStream)this.getClass().getResourceAsStream("/template.po"));
        ByteArrayImageLayout layout = new ByteArrayImageLayout(templateBytes.length);
        ProdosOrder imageOrder = new ProdosOrder(layout);
        ProdosFormatDisk[] disks = ProdosFormatDisk.create((String)"DELETEME", (String)"GONESOON", (ImageOrder)imageOrder);
        ProdosFormatDisk template = disks[0];
        template.getDiskImageManager().setDiskImage(templateBytes);
        FileEntry basicFile = template.createFile();
        basicFile.setFilename("STARTUP");
        basicFile.setFiletype("BAS");
        basicFile.setAddress(config.startAddress);
        basicFile.setFileData(programBytes);
        FileEntry shapeFile = template.createFile();
        shapeFile.setFilename("SHAPES.BIN");
        shapeFile.setFiletype("BIN");
        shapeFile.setAddress(24576);
        shapeFile.setFileData(shapeTableBytes);
        return template.getDiskImageManager().getDiskImage();
    }
}

