/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FS_POSIX
extends FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS_POSIX.class);
    private static final String DEFAULT_GIT_LOCATION = "/usr/bin/git";
    private static final int DEFAULT_UMASK = 18;
    private volatile int umask = -1;
    private static final Map<FileStore, Boolean> CAN_HARD_LINK = new ConcurrentHashMap<FileStore, Boolean>();
    private volatile AtomicFileCreation supportsAtomicFileCreation = AtomicFileCreation.UNDEFINED;

    protected FS_POSIX() {
    }

    protected FS_POSIX(FS src) {
        super(src);
        if (src instanceof FS_POSIX) {
            this.umask = ((FS_POSIX)src).umask;
        }
    }

    @Override
    public FS newInstance() {
        return new FS_POSIX(this);
    }

    public void setUmask(int umask) {
        this.umask = umask;
    }

    private int umask() {
        int u = this.umask;
        if (u == -1) {
            this.umask = u = FS_POSIX.readUmask();
        }
        return u;
    }

    private static int readUmask() {
        BufferedReader lineRead;
        block13: {
            int n;
            block14: {
                Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "umask"}, null, null);
                Throwable throwable = null;
                Object var2_4 = null;
                lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), SystemReader.getInstance().getDefaultCharset().name()));
                try {
                    String s2;
                    if (p.waitFor() != 0 || (s2 = lineRead.readLine()) == null || !s2.matches("0?\\d{3}")) break block13;
                    n = Integer.parseInt(s2, 8);
                    if (lineRead == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (lineRead != null) {
                                lineRead.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        return 18;
                    }
                }
                lineRead.close();
            }
            return n;
        }
        if (lineRead != null) {
            lineRead.close();
        }
        return 18;
    }

    @Override
    protected File discoverGitExe() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_POSIX.searchPath(path, "git");
        if (SystemReader.getInstance().isMacOS()) {
            String w;
            if ((gitExe == null || DEFAULT_GIT_LOCATION.equals(gitExe.getPath())) && FS_POSIX.searchPath(path, "bash") != null) {
                try {
                    w = FS_POSIX.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, SystemReader.getInstance().getDefaultCharset().name());
                    if (!StringUtils.isEmptyOrNull(w)) {
                        gitExe = new File(w);
                    }
                }
                catch (CommandFailedException e) {
                    LOG.warn(e.getMessage());
                }
            }
            if (gitExe != null && DEFAULT_GIT_LOCATION.equals(gitExe.getPath())) {
                try {
                    w = FS_POSIX.readPipe(this.userHome(), new String[]{"xcode-select", "-p"}, SystemReader.getInstance().getDefaultCharset().name());
                    if (StringUtils.isEmptyOrNull(w)) {
                        gitExe = null;
                    } else {
                        File realGitExe = new File(new File(w), DEFAULT_GIT_LOCATION.substring(1));
                        if (!realGitExe.exists()) {
                            gitExe = null;
                        }
                    }
                }
                catch (CommandFailedException e) {
                    gitExe = null;
                }
            }
        }
        return gitExe;
    }

    @Override
    public boolean isCaseSensitive() {
        return !SystemReader.getInstance().isMacOS();
    }

    @Override
    public boolean supportsExecute() {
        return true;
    }

    @Override
    public boolean canExecute(File f) {
        if (!this.isFile(f)) {
            return false;
        }
        try {
            Path path = FileUtils.toPath(f);
            Set<PosixFilePermission> pset = Files.getPosixFilePermissions(path, new LinkOption[0]);
            return pset.contains((Object)PosixFilePermission.OWNER_EXECUTE);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean setExecute(File f, boolean canExecute) {
        if (!this.isFile(f)) {
            return false;
        }
        if (!canExecute) {
            return f.setExecutable(false, false);
        }
        try {
            Path path = FileUtils.toPath(f);
            Set<PosixFilePermission> pset = Files.getPosixFilePermissions(path, new LinkOption[0]);
            pset.add(PosixFilePermission.OWNER_EXECUTE);
            int mask = this.umask();
            FS_POSIX.apply(pset, mask, PosixFilePermission.GROUP_EXECUTE, 8);
            FS_POSIX.apply(pset, mask, PosixFilePermission.OTHERS_EXECUTE, 1);
            Files.setPosixFilePermissions(path, pset);
            return true;
        }
        catch (IOException e) {
            boolean debug = Boolean.parseBoolean(SystemReader.getInstance().getProperty("jgit.fs.debug"));
            if (debug) {
                System.err.println(e);
            }
            return false;
        }
    }

    private static void apply(Set<PosixFilePermission> set, int umask, PosixFilePermission perm, int test) {
        if ((umask & test) == 0) {
            set.add(perm);
        } else {
            set.remove((Object)perm);
        }
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(5 + args.length);
        argv.add("sh");
        if (SystemReader.getInstance().isMacOS()) {
            argv.add("-l");
        }
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    @Override
    String shellQuote(String cmd) {
        return QuotedString.BOURNE.quote(cmd);
    }

    @Override
    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args, OutputStream outRedirect, OutputStream errRedirect, String stdinArgs) throws JGitInternalException {
        return this.internalRunHookIfPresent(repository, hookName, args, outRedirect, errRedirect, stdinArgs);
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return false;
    }

    @Override
    public void setHidden(File path, boolean hidden) throws IOException {
    }

    @Override
    public FS.Attributes getAttributes(File path) {
        return FileUtils.getFileAttributesPosix(this, path);
    }

    @Override
    public File normalize(File file) {
        return FileUtils.normalize(file);
    }

    @Override
    public String normalize(String name) {
        return FileUtils.normalize(name);
    }

    @Override
    public boolean supportsAtomicCreateNewFile() {
        if (this.supportsAtomicFileCreation == AtomicFileCreation.UNDEFINED) {
            try {
                StoredConfig config = SystemReader.getInstance().getUserConfig();
                String value = config.getString("core", null, "supportsatomicfilecreation");
                this.supportsAtomicFileCreation = value != null ? (StringUtils.toBoolean(value) ? AtomicFileCreation.SUPPORTED : AtomicFileCreation.NOT_SUPPORTED) : AtomicFileCreation.SUPPORTED;
            }
            catch (IOException | ConfigInvalidException e) {
                LOG.warn(JGitText.get().assumeAtomicCreateNewFile, e);
                this.supportsAtomicFileCreation = AtomicFileCreation.SUPPORTED;
            }
        }
        return this.supportsAtomicFileCreation == AtomicFileCreation.SUPPORTED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public boolean createNewFile(File lock) throws IOException {
        Path link;
        block16: {
            block15: {
                if (!lock.createNewFile()) {
                    return false;
                }
                if (this.supportsAtomicCreateNewFile()) {
                    return true;
                }
                Path lockPath = lock.toPath();
                link = null;
                FileStore store = null;
                try {
                    store = Files.getFileStore(lockPath);
                }
                catch (SecurityException e) {
                    return true;
                }
                try {
                    Boolean canLink = CAN_HARD_LINK.computeIfAbsent(store, s2 -> Boolean.TRUE);
                    if (Boolean.FALSE.equals(canLink)) {
                        return true;
                    }
                    link = Files.createLink(Paths.get(lock.getAbsolutePath() + ".lnk", new String[0]), lockPath);
                    Integer nlink = (Integer)Files.getAttribute(lockPath, "unix:nlink", new LinkOption[0]);
                    if (nlink > 2) {
                        LOG.warn(MessageFormat.format(JGitText.get().failedAtomicFileCreation, lockPath, nlink));
                        if (link == null) return false;
                        break block15;
                    }
                    if (nlink < 2) {
                        CAN_HARD_LINK.put(store, Boolean.FALSE);
                    }
                    if (link == null) return true;
                    break block16;
                }
                catch (IllegalArgumentException | UnsupportedOperationException e) {
                    CAN_HARD_LINK.put(store, Boolean.FALSE);
                    return true;
                }
            }
            Files.delete(link);
            return false;
        }
        Files.delete(link);
        return true;
        finally {
            if (link != null) {
                Files.delete(link);
            }
        }
    }

    @Override
    public FS.LockToken createNewFileAtomic(File file) throws IOException {
        Path path;
        try {
            path = file.toPath();
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException | InvalidPathException e) {
            return FS_POSIX.token(false, null);
        }
        if (this.supportsAtomicCreateNewFile()) {
            return FS_POSIX.token(true, null);
        }
        Path link = null;
        FileStore store = null;
        try {
            store = Files.getFileStore(path);
        }
        catch (SecurityException e) {
            return FS_POSIX.token(true, null);
        }
        try {
            Boolean canLink = CAN_HARD_LINK.computeIfAbsent(store, s2 -> Boolean.TRUE);
            if (Boolean.FALSE.equals(canLink)) {
                return FS_POSIX.token(true, null);
            }
            link = Files.createLink(Paths.get(FS_POSIX.uniqueLinkPath(file), new String[0]), path);
            Integer nlink = (Integer)Files.getAttribute(path, "unix:nlink", new LinkOption[0]);
            if (nlink > 2) {
                LOG.warn(MessageFormat.format(JGitText.get().failedAtomicFileCreation, path, nlink));
                return FS_POSIX.token(false, link);
            }
            if (nlink < 2) {
                CAN_HARD_LINK.put(store, Boolean.FALSE);
            }
            return FS_POSIX.token(true, link);
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException | FileSystemException e) {
            CAN_HARD_LINK.put(store, Boolean.FALSE);
            return FS_POSIX.token(true, link);
        }
    }

    private static FS.LockToken token(boolean created, @Nullable Path p) {
        return p != null && Files.exists(p, new LinkOption[0]) ? new FS.LockToken(created, Optional.of(p)) : new FS.LockToken(created, Optional.empty());
    }

    private static String uniqueLinkPath(File file) {
        UUID id = UUID.randomUUID();
        return file.getAbsolutePath() + "." + Long.toHexString(id.getMostSignificantBits()) + Long.toHexString(id.getLeastSignificantBits());
    }

    private static enum AtomicFileCreation {
        SUPPORTED,
        NOT_SUPPORTED,
        UNDEFINED;

    }
}

