/*
 * Decompiled with CFR 0.152.
 */
package jasmin;

abstract class ScannerUtils {
    ScannerUtils() {
    }

    public static Number convertNumber(String str) throws NumberFormatException {
        if ((str = str.toUpperCase()).startsWith("0X")) {
            switch (str.charAt(str.length() - 1)) {
                case 'L': {
                    return Long.parseLong(str.substring(2, str.length() - 1), 16);
                }
            }
            return Integer.parseInt(str.substring(2), 16);
        }
        if (str.startsWith("0N") || str.startsWith("0P")) {
            if (str.equals("0NAN_F")) {
                return Float.valueOf(Float.NaN);
            }
            if (str.equals("0NAN_D")) {
                return Double.NaN;
            }
            if (str.equals("0NEG_INFI_F")) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            if (str.equals("0NEG_INFI_D")) {
                return Double.NEGATIVE_INFINITY;
            }
            if (str.equals("0POS_INFI_F")) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (str.equals("0POS_INFI_D")) {
                return Double.POSITIVE_INFINITY;
            }
            throw new IllegalArgumentException("malformed number : " + str);
        }
        switch (str.charAt(str.length() - 1)) {
            case 'D': {
                return Double.parseDouble(str.substring(0, str.length() - 1));
            }
            case 'L': {
                return Long.parseLong(str.substring(0, str.length() - 1));
            }
            case 'F': {
                return Float.valueOf(Float.parseFloat(str.substring(0, str.length() - 1)));
            }
        }
        if (str.indexOf(46) >= 0) {
            return Double.parseDouble(str);
        }
        return Integer.parseInt(str);
    }

    public static String convertDots(String orig_name) {
        return ScannerUtils.convertChars(orig_name, ".", '/');
    }

    public static String convertChars(String orig_name, String chars, char toChar) {
        StringBuffer tmp = new StringBuffer(orig_name);
        for (int i = 0; i < tmp.length(); ++i) {
            if (chars.indexOf(tmp.charAt(i)) == -1) continue;
            tmp.setCharAt(i, toChar);
        }
        return new String(tmp);
    }

    public static String[] splitClassMethodSignature(String name) {
        String[] result = new String[3];
        int pos = 0;
        int sigpos = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '.' || c == '/') {
                pos = i;
                continue;
            }
            if (c != '(') continue;
            sigpos = i;
            break;
        }
        try {
            result[0] = ScannerUtils.convertDots(name.substring(0, pos));
            result[1] = name.substring(pos + 1, sigpos);
            result[2] = ScannerUtils.convertDots(name.substring(sigpos));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("malformed signature : " + name);
        }
        return result;
    }

    public static String[] splitClassField(String name) {
        String[] result = new String[2];
        int pos = -1;
        boolean sigpos = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != '.' && c != '/') continue;
            pos = i;
        }
        if (pos == -1) {
            result[0] = null;
            result[1] = name;
        } else {
            result[0] = ScannerUtils.convertDots(name.substring(0, pos));
            result[1] = name.substring(pos + 1);
        }
        return result;
    }

    public static String[] splitMethodSignature(String name) {
        String[] result = new String[2];
        int sigpos = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != '(') continue;
            sigpos = i;
            break;
        }
        result[0] = name.substring(0, sigpos);
        result[1] = ScannerUtils.convertDots(name.substring(sigpos));
        return result;
    }

    public static int getArgumentsAndReturnSizes(String desc) {
        int n = 1;
        int c = 1;
        while (true) {
            char car;
            if ((car = desc.charAt(c++)) == ')') {
                car = desc.charAt(c);
                return n << 2 | (car == 'V' ? 0 : (car == 'D' || car == 'J' ? 2 : 1));
            }
            if (car == 'L') {
                while (desc.charAt(c++) != ';') {
                }
                ++n;
                continue;
            }
            if (car == '[') {
                while ((car = desc.charAt(c)) == '[') {
                    ++c;
                }
                if (car != 'D' && car != 'J') continue;
                --n;
                continue;
            }
            if (car == 'D' || car == 'J') {
                n += 2;
                continue;
            }
            ++n;
        }
    }
}

