/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    static final int DELAY = 100;
    static final int TIMER_ID = 100;
    static final int MINIMUM_WIDTH = 100;
    static final int ProgressBarProc;
    static final TCHAR ProgressBarClass;

    static {
        ProgressBarClass = new TCHAR(0, "msctls_progress32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ProgressBarClass, wNDCLASS);
        ProgressBarProc = wNDCLASS.lpfnWndProc;
        int n = OS.GetModuleHandle(null);
        int n2 = OS.GetProcessHeap();
        wNDCLASS.hInstance = n;
        wNDCLASS.style &= 0xFFFFBFFF;
        wNDCLASS.style |= 8;
        int n3 = ProgressBarClass.length() * TCHAR.sizeof;
        int n4 = OS.HeapAlloc(n2, 8, n3);
        OS.MoveMemory(n4, ProgressBarClass, n3);
        wNDCLASS.lpszClassName = n4;
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n2, 0, n4);
    }

    public ProgressBar(Composite composite, int n) {
        super(composite, ProgressBar.checkStyle(n));
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ProgressBarProc, n, n2, n3, n4);
    }

    static int checkStyle(int n) {
        return ProgressBar.checkBits(n |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        if ((this.style & 0x100) != 0) {
            n4 += OS.GetSystemMetrics(21) * 10;
            n5 += OS.GetSystemMetrics(3);
        } else {
            n4 += OS.GetSystemMetrics(2);
            n5 += OS.GetSystemMetrics(20) * 10;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void createHandle() {
        super.createHandle();
        this.startTimer();
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_HIGHLIGHT);
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1031, 0, 0);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1031, 1, 0);
    }

    public int getSelection() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1032, 0, 0);
    }

    public int getState() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            int n = OS.SendMessage(this.handle, 1041, 0, 0);
            switch (n) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 4;
                }
            }
        }
        return 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.stopTimer();
    }

    void startTimer() {
        if ((this.style & 2) != 0) {
            int n = OS.GetWindowLong(this.handle, -16);
            if (OS.COMCTL32_MAJOR < 6 || (n & 8) == 0) {
                OS.SetTimer(this.handle, 100, 100, 0);
            } else {
                OS.SendMessage(this.handle, 1034, 1, 100);
            }
        }
    }

    void stopTimer() {
        if ((this.style & 2) != 0) {
            int n = OS.GetWindowLong(this.handle, -16);
            if (OS.COMCTL32_MAJOR < 6 || (n & 8) == 0) {
                OS.KillTimer(this.handle, 100);
            } else {
                OS.SendMessage(this.handle, 1034, 0, 0);
            }
        }
    }

    void setBackgroundPixel(int n) {
        if (n == -1) {
            n = -16777216;
        }
        OS.SendMessage(this.handle, 8193, 0, n);
    }

    void setForegroundPixel(int n) {
        if (n == -1) {
            n = -16777216;
        }
        OS.SendMessage(this.handle, 1033, 0, n);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 1031, 1, 0);
        if (n2 >= 0 && n2 < n) {
            OS.SendMessage(this.handle, 1030, n2, n);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 1031, 0, 0);
        if (n >= 0 && n < n2) {
            OS.SendMessage(this.handle, 1030, n, n2);
        }
    }

    public void setSelection(int n) {
        int n2;
        this.checkWidget();
        OS.SendMessage(this.handle, 1026, n, 0);
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && (n2 = OS.SendMessage(this.handle, 1041, 0, 0)) != 1) {
            OS.SendMessage(this.handle, 1026, n, 0);
        }
    }

    public void setState(int n) {
        this.checkWidget();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            switch (n) {
                case 0: {
                    OS.SendMessage(this.handle, 1040, 1, 0);
                    break;
                }
                case 1: {
                    OS.SendMessage(this.handle, 1040, 2, 0);
                    break;
                }
                case 4: {
                    OS.SendMessage(this.handle, 1040, 3, 0);
                }
            }
        }
    }

    int widgetStyle() {
        int n = super.widgetStyle();
        if ((this.style & 0x10000) != 0) {
            n |= 1;
        }
        if ((this.style & 0x200) != 0) {
            n |= 4;
        }
        if ((this.style & 2) != 0) {
            n |= 8;
        }
        return n;
    }

    TCHAR windowClass() {
        return ProgressBarClass;
    }

    int windowProc() {
        return ProgressBarProc;
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(256);
    }

    LRESULT WM_SIZE(int n, int n2) {
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 2) != 0 && (OS.WIN32_VERSION == OS.VERSION(5, 1) || OS.COMCTL32_MAJOR >= 6 && !OS.IsAppThemed())) {
            int n3;
            this.forceResize();
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            int n4 = n3 = OS.GetWindowLong(this.handle, -16);
            n4 = rECT.right - rECT.left < 100 ? (n4 &= 0xFFFFFFF7) : (n4 |= 8);
            if (n4 != n3) {
                this.stopTimer();
                OS.SetWindowLong(this.handle, -16, n4);
                this.startTimer();
            }
        }
        return lRESULT;
    }

    LRESULT WM_TIMER(int n, int n2) {
        LRESULT lRESULT = super.WM_TIMER(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 2) != 0) {
            int n3 = OS.GetWindowLong(this.handle, -16);
            if ((OS.COMCTL32_MAJOR < 6 || (n3 & 8) == 0) && n == 100) {
                OS.SendMessage(this.handle, 1029, 0, 0);
            }
        }
        return lRESULT;
    }
}

