/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.FanObj;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;
import fanx.serial.Literal;
import fanx.serial.ObjEncoder;

public final class Duration
extends FanObj
implements Literal {
    public static final Duration Zero;
    public static final long nsPerDay = 86400000000000L;
    public static final long nsPerHr = 3600000000000L;
    public static final long nsPerMin = 60000000000L;
    public static final long nsPerSec = 1000000000L;
    public static final long nsPerMilli = 1000000L;
    public static final long secPerDay = 86400L;
    public static final long secPerHr = 3600L;
    public static final long secPerMin = 60L;
    public static final Duration defVal;
    public static final Duration minVal;
    public static final Duration maxVal;
    public static final Duration oneDay;
    public static final Duration oneSec;
    public static final Duration oneMin;
    public static final Duration negOneDay;
    public final long ticks;
    private String str;

    public static Duration fromStr(String string) {
        return Duration.fromStr(string, true);
    }

    public static Duration fromStr(String string, boolean bl) {
        try {
            int n = string.length();
            char c = string.charAt(n - 1);
            char c2 = string.charAt(n - 2);
            char c3 = string.charAt(n - 3);
            boolean bl2 = string.indexOf(46) > 0;
            long l = -1L;
            int n2 = -1;
            switch (c) {
                case 's': {
                    if (c2 == 'n') {
                        l = 1L;
                        n2 = 2;
                    }
                    if (c2 != 'm') break;
                    l = 1000000L;
                    n2 = 2;
                    break;
                }
                case 'c': {
                    if (c2 != 'e' || c3 != 's') break;
                    l = 1000000000L;
                    n2 = 3;
                    break;
                }
                case 'n': {
                    if (c2 != 'i' || c3 != 'm') break;
                    l = 60000000000L;
                    n2 = 3;
                    break;
                }
                case 'r': {
                    if (c2 != 'h') break;
                    l = 3600000000000L;
                    n2 = 2;
                    break;
                }
                case 'y': {
                    if (c2 != 'a' || c3 != 'd') break;
                    l = 86400000000000L;
                    n2 = 3;
                }
            }
            if (l < 0L) {
                throw new Exception();
            }
            string = string.substring(0, n - n2);
            if (bl2) {
                return Duration.make((long)(Double.parseDouble(string) * (double)l));
            }
            return Duration.make(Long.parseLong(string) * l);
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Duration", string);
        }
    }

    public static Duration make(long l) {
        if (l == 0L) {
            return Zero;
        }
        return new Duration(l);
    }

    public static Duration makeMillis(long l) {
        return Duration.make(l * 1000000L);
    }

    public static Duration makeSec(long l) {
        return Duration.make(l * 1000000000L);
    }

    public static Duration now() {
        return new Duration(System.nanoTime());
    }

    public static long nowTicks() {
        return System.nanoTime();
    }

    public static long nowMillis() {
        return System.nanoTime() / 1000000L;
    }

    public static Duration boot() {
        return Sys.bootDuration;
    }

    public static Duration uptime() {
        return new Duration(System.nanoTime() - Duration.boot().ticks);
    }

    private Duration(long l) {
        this.ticks = l;
    }

    public final boolean equals(Object object) {
        if (object instanceof Duration) {
            return this.ticks == ((Duration)object).ticks;
        }
        return false;
    }

    public final long compare(Object object) {
        long l = ((Duration)object).ticks;
        if (this.ticks < l) {
            return -1L;
        }
        return this.ticks == l ? 0L : 1L;
    }

    public final int hashCode() {
        return (int)(this.ticks ^ this.ticks >>> 32);
    }

    public final long hash() {
        return this.ticks;
    }

    public final long ticks() {
        return this.ticks;
    }

    public final Type typeof() {
        return Sys.DurationType;
    }

    public final Duration negate() {
        return Duration.make(-this.ticks);
    }

    public final Duration plus(Duration duration) {
        return Duration.make(this.ticks + duration.ticks);
    }

    public final Duration minus(Duration duration) {
        return Duration.make(this.ticks - duration.ticks);
    }

    public final Duration mult(long l) {
        return Duration.make(this.ticks * l);
    }

    public final Duration multFloat(double d) {
        return Duration.make((long)((double)this.ticks * d));
    }

    public final Duration div(long l) {
        return Duration.make(this.ticks / l);
    }

    public final Duration divFloat(double d) {
        return Duration.make((long)((double)this.ticks / d));
    }

    public final Duration floor(Duration duration) {
        if (this.ticks % duration.ticks == 0L) {
            return this;
        }
        return Duration.make(this.ticks - this.ticks % duration.ticks);
    }

    public final Duration min(Duration duration) {
        return this.ticks <= duration.ticks ? this : duration;
    }

    public final Duration max(Duration duration) {
        return this.ticks >= duration.ticks ? this : duration;
    }

    public final Duration abs() {
        if (this.ticks >= 0L) {
            return this;
        }
        return Duration.make(-this.ticks);
    }

    public String toStr() {
        if (this.ticks == 0L) {
            return "0ns";
        }
        long l = this.ticks;
        if (l % 1000000L == 0L) {
            if (l % 86400000000000L == 0L) {
                return l / 86400000000000L + "day";
            }
            if (l % 3600000000000L == 0L) {
                return l / 3600000000000L + "hr";
            }
            if (l % 60000000000L == 0L) {
                return l / 60000000000L + "min";
            }
            if (l % 1000000000L == 0L) {
                return l / 1000000000L + "sec";
            }
            return l / 1000000L + "ms";
        }
        return l + "ns";
    }

    public void encode(ObjEncoder objEncoder) {
        objEncoder.w(this.toStr());
    }

    public String toCode() {
        return this.toStr();
    }

    public final long toMillis() {
        return this.ticks / 1000000L;
    }

    public final long toSec() {
        return this.ticks / 1000000000L;
    }

    public final long toMin() {
        return this.ticks / 60000000000L;
    }

    public final long toHour() {
        return this.ticks / 3600000000000L;
    }

    public final long toDay() {
        return this.ticks / 86400000000000L;
    }

    public String toLocale() {
        long l = this.ticks;
        if (l < 1000L) {
            return l + "ns";
        }
        if (l < 2000000L) {
            StringBuilder stringBuilder = new StringBuilder();
            long l2 = l / 1000000L;
            long l3 = (l - l2 * 1000000L) / 1000L;
            stringBuilder.append(l2);
            stringBuilder.append('.');
            if (l3 < 100L) {
                stringBuilder.append('0');
            }
            if (l3 < 10L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l3);
            if (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            if (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            stringBuilder.append("ms");
            return stringBuilder.toString();
        }
        if (l < 2000000000L) {
            return l / 1000000L + "ms";
        }
        if (l < 60000000000L) {
            return l / 1000000000L + "sec";
        }
        long l4 = l / 86400000000000L;
        long l5 = (l -= l4 * 86400000000000L) / 3600000000000L;
        long l6 = (l -= l5 * 3600000000000L) / 60000000000L;
        long l7 = (l -= l6 * 60000000000L) / 1000000000L;
        StringBuilder stringBuilder = new StringBuilder();
        if (l4 > 0L) {
            stringBuilder.append(l4).append(l4 == 1L ? "day " : "days ");
        }
        if (l5 > 0L) {
            stringBuilder.append(l5).append("hr ");
        }
        if (l6 > 0L) {
            stringBuilder.append(l6).append("min ");
        }
        if (l7 > 0L) {
            stringBuilder.append(l7).append("sec ");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public String toIso() {
        StringBuilder stringBuilder = new StringBuilder();
        long l = this.ticks;
        if (l == 0L) {
            return "PT0S";
        }
        if (l < 0L) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        long l2 = Math.abs(l);
        long l3 = l2 / 1000000000L;
        long l4 = l2 % 1000000000L;
        if (l3 > 86400L) {
            stringBuilder.append(l3 / 86400L).append('D');
            l3 %= 86400L;
        }
        if (l3 == 0L && l4 == 0L) {
            return stringBuilder.toString();
        }
        stringBuilder.append('T');
        if (l3 > 3600L) {
            stringBuilder.append(l3 / 3600L).append('H');
            l3 %= 3600L;
        }
        if (l3 > 60L) {
            stringBuilder.append(l3 / 60L).append('M');
            l3 %= 60L;
        }
        if (l3 == 0L && l4 == 0L) {
            return stringBuilder.toString();
        }
        stringBuilder.append(l3);
        if (l4 != 0L) {
            stringBuilder.append('.');
            for (int i = 10; i <= 100000000; i *= 10) {
                if (l4 >= (long)i) continue;
                stringBuilder.append('0');
            }
            stringBuilder.append(l4);
            while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
        }
        stringBuilder.append('S');
        return stringBuilder.toString();
    }

    public static Duration fromIso(String string) {
        return Duration.fromIso(string, true);
    }

    public static Duration fromIso(String string, boolean bl) {
        try {
            long l = 0L;
            boolean bl2 = false;
            IsoParser isoParser = new IsoParser(string);
            if (isoParser.cur == 45) {
                bl2 = true;
                isoParser.consume();
            } else if (isoParser.cur == 43) {
                isoParser.consume();
            }
            isoParser.consume(80);
            if (isoParser.cur == -1) {
                throw new Exception();
            }
            int n = 0;
            if (isoParser.cur != 84) {
                n = isoParser.num();
                isoParser.consume(68);
                l += (long)n * 86400000000000L;
                if (isoParser.cur == -1) {
                    return new Duration(l);
                }
            }
            isoParser.consume(84);
            if (isoParser.cur == -1) {
                throw new Exception();
            }
            n = isoParser.num();
            if (n >= 0 && isoParser.cur == 72) {
                isoParser.consume();
                l += (long)n * 3600000000000L;
                n = isoParser.num();
            }
            if (n >= 0 && isoParser.cur == 77) {
                isoParser.consume();
                l += (long)n * 60000000000L;
                n = isoParser.num();
            }
            if (n >= 0 && isoParser.cur == 83 || isoParser.cur == 46) {
                l += (long)n * 1000000000L;
                if (isoParser.cur == 46) {
                    isoParser.consume();
                    l += (long)isoParser.frac();
                }
                isoParser.consume(83);
            }
            if (isoParser.cur != -1) {
                throw new Exception();
            }
            if (bl2) {
                l = -l;
            }
            return new Duration(l);
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("ISO 8601 Duration", string);
        }
    }

    public long sec() {
        return this.ticks / 1000000000L;
    }

    public long millis() {
        return this.ticks / 1000000L;
    }

    static {
        defVal = Zero = new Duration(0L);
        minVal = Duration.make(Long.MIN_VALUE);
        maxVal = Duration.make(Long.MAX_VALUE);
        oneDay = Duration.make(86400000000000L);
        oneSec = Duration.make(1000000000L);
        oneMin = Duration.make(60000000000L);
        negOneDay = Duration.make(-86400000000000L);
    }

    static class IsoParser {
        String s;
        int off;
        int cur;
        boolean curIsDigit;

        IsoParser(String string) {
            this.s = string;
            this.cur = string.charAt(0);
        }

        int num() {
            if (!this.curIsDigit && this.cur != -1 && this.cur != 46) {
                throw new IllegalStateException();
            }
            int n = 0;
            while (this.curIsDigit) {
                n = n * 10 + this.digit();
                this.consume();
            }
            return n;
        }

        int frac() {
            int n = 0;
            for (int i = 100000000; i >= 0 && this.curIsDigit; i /= 10) {
                n += this.digit() * i;
                this.consume();
            }
            return n;
        }

        int digit() {
            return this.cur - 48;
        }

        void consume(int n) {
            if (this.cur != n) {
                throw new IllegalStateException();
            }
            this.consume();
        }

        void consume() {
            ++this.off;
            if (this.off < this.s.length()) {
                this.cur = this.s.charAt(this.off);
                this.curIsDigit = 48 <= this.cur && this.cur <= 57;
            } else {
                this.cur = -1;
                this.curIsDigit = false;
            }
        }
    }
}

