/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Charset;
import fan.sys.Duration;
import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.FanStr;
import fan.sys.Map;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.Uri;

public final class MimeType
extends FanObj {
    static final Uri etcUri = Uri.fromStr("ext2mime.props");
    static Map emptyQuery;
    static final MimeType imagePng;
    static final MimeType imageGif;
    static final MimeType imageJpeg;
    static final MimeType textPlain;
    static final MimeType textHtml;
    static final MimeType textXml;
    static final MimeType dir;
    static final MimeType textPlainUtf8;
    static final MimeType textHtmlUtf8;
    static final MimeType textXmlUtf8;
    private String mediaType;
    private String subType;
    private Map params;
    private String str;

    public static MimeType fromStr(String string) {
        return MimeType.fromStr(string, true);
    }

    public static MimeType fromStr(String string, boolean bl) {
        try {
            switch (string.charAt(0)) {
                case 'i': {
                    if (string.equals("image/png")) {
                        return imagePng;
                    }
                    if (string.equals("image/jpeg")) {
                        return imageJpeg;
                    }
                    if (!string.equals("image/gif")) break;
                    return imageGif;
                }
                case 't': {
                    if (string.equals("text/plain")) {
                        return textPlain;
                    }
                    if (string.equals("text/html")) {
                        return textHtml;
                    }
                    if (string.equals("text/xml")) {
                        return textXml;
                    }
                    if (string.equals("text/plain; charset=utf-8")) {
                        return textPlainUtf8;
                    }
                    if (string.equals("text/html; charset=utf-8")) {
                        return textHtmlUtf8;
                    }
                    if (!string.equals("text/xml; charset=utf-8")) break;
                    return textXmlUtf8;
                }
                case 'x': {
                    if (!string.equals("x-directory/normal")) break;
                    return dir;
                }
            }
            return MimeType.parse(string);
        }
        catch (ParseErr parseErr) {
            if (!bl) {
                return null;
            }
            throw parseErr;
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("MimeType", string);
        }
    }

    private static MimeType parse(String string) {
        int n = string.indexOf(47);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        Map map = MimeType.emptyParams();
        int n2 = string3.indexOf(59);
        if (n2 > 0) {
            map = MimeType.doParseParams(string3, n2 + 1);
            string3 = string3.substring(0, n2).trim();
        }
        MimeType mimeType = new MimeType();
        mimeType.str = string;
        mimeType.mediaType = FanStr.lower(string2);
        mimeType.subType = FanStr.lower(string3);
        mimeType.params = map.ro();
        return mimeType;
    }

    public static Map parseParams(String string) {
        return MimeType.parseParams(string, true);
    }

    public static Map parseParams(String string, boolean bl) {
        try {
            return MimeType.doParseParams(string, 0);
        }
        catch (ParseErr parseErr) {
            if (!bl) {
                return null;
            }
            throw parseErr;
        }
        catch (Exception exception) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("MimeType params", string);
        }
    }

    private static Map doParseParams(String string, int n) {
        Map map = new Map(Sys.StrType, Sys.StrType);
        map.caseInsensitive(true);
        boolean bl = false;
        int n2 = n;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        boolean bl2 = false;
        for (int i = n2; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(' && !bl) {
                throw ParseErr.make("MimeType", string, "comments not supported");
            }
            if (c == '=' && !bl) {
                n5 = i++;
                while (FanInt.isSpace(string.charAt(i))) {
                    ++i;
                }
                if (string.charAt(i) == '\"') {
                    bl = true;
                    c = string.charAt(++i);
                } else {
                    bl = false;
                }
                n3 = i;
            }
            if (n5 < 0) continue;
            if (c == '\\' && bl) {
                ++i;
                bl2 = true;
                continue;
            }
            if (c == '\"' && bl) {
                n4 = i - 1;
                bl = false;
            }
            if (c != ';' || bl) continue;
            if (n4 < 0) {
                n4 = i - 1;
            }
            String string2 = string.substring(n2, n5).trim();
            String string3 = string.substring(n3, n4 + 1).trim();
            if (bl2) {
                string3 = MimeType.unescape(string3);
            }
            map.set(string2, string3);
            n2 = i + 1;
            n4 = -1;
            n3 = -1;
            n5 = -1;
            bl2 = false;
        }
        if (n2 < string.length()) {
            if (n4 < 0) {
                n4 = string.length() - 1;
            }
            String string4 = string.substring(n2, n5).trim();
            String string5 = string.substring(n3, n4 + 1).trim();
            if (bl2) {
                string5 = MimeType.unescape(string5);
            }
            map.set(string4, string5);
        }
        return map;
    }

    private static String unescape(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            if (string.charAt(i + 1) != '\\') continue;
            stringBuilder.append('\\');
            ++i;
        }
        return stringBuilder.toString();
    }

    public static MimeType forExt(String string) {
        if (string == null) {
            return null;
        }
        try {
            String string2 = (String)Sys.sysPod.props(etcUri, Duration.oneMin).get(FanStr.lower(string));
            if (string2 == null) {
                return null;
            }
            return MimeType.fromStr(string2);
        }
        catch (Exception exception) {
            System.out.println("MimeType.forExt: " + string);
            exception.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MimeType)) {
            return false;
        }
        MimeType mimeType = (MimeType)object;
        return this.mediaType.equals(mimeType.mediaType) && this.subType.equals(mimeType.subType) && this.params.equals(mimeType.params);
    }

    public int hashCode() {
        return this.mediaType.hashCode() ^ this.subType.hashCode() ^ this.params.hashCode();
    }

    public long hash() {
        return this.hashCode();
    }

    public String toStr() {
        return this.str;
    }

    public Type typeof() {
        return Sys.MimeTypeType;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public String subType() {
        return this.subType;
    }

    public Map params() {
        return this.params;
    }

    public Charset charset() {
        String string = (String)this.params().get("charset");
        if (string == null) {
            return Charset.utf8;
        }
        return Charset.fromStr(string);
    }

    static Map emptyParams() {
        Map map = emptyQuery;
        if (map == null) {
            map = new Map(Sys.StrType, Sys.StrType);
            map.caseInsensitive(true);
            emptyQuery = map = (Map)map.toImmutable();
        }
        return map;
    }

    static {
        imagePng = MimeType.parse("image/png");
        imageGif = MimeType.parse("image/gif");
        imageJpeg = MimeType.parse("image/jpeg");
        textPlain = MimeType.parse("text/plain");
        textHtml = MimeType.parse("text/html");
        textXml = MimeType.parse("text/xml");
        dir = MimeType.parse("x-directory/normal");
        textPlainUtf8 = MimeType.parse("text/plain; charset=utf-8");
        textHtmlUtf8 = MimeType.parse("text/html; charset=utf-8");
        textXmlUtf8 = MimeType.parse("text/xml; charset=utf-8");
    }
}

