/*
 * Decompiled with CFR 0.152.
 */
package fanx.util;

import fan.sys.Env;
import fan.sys.Pod;
import fan.sys.Sys;
import fan.sys.Type;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class FanUtil {
    private static HashMap javaToFanTypes = new HashMap();
    private static HashMap javaImmutables;

    public static Type toFanType(Class clazz, boolean bl) {
        String string = clazz.getName();
        Type type = (Type)javaToFanTypes.get(string);
        if (type != null) {
            return type;
        }
        if (string.startsWith("fan.")) {
            int n = string.lastIndexOf(46);
            String string2 = string.substring(4, n);
            String string3 = string.substring(n + 1);
            Pod pod = Pod.find(string2, bl);
            if (pod == null) {
                return null;
            }
            return pod.type(string3, bl);
        }
        return Env.cur().loadJavaType(clazz);
    }

    public static boolean isJavaImmutable(Class clazz) {
        return javaImmutables.get(clazz.getName()) != null;
    }

    public static boolean isJavaRepresentation(Type type) {
        if (type.pod() != Sys.sysPod) {
            return false;
        }
        return type == Sys.ObjType || type == Sys.BoolType || type == Sys.StrType || type == Sys.IntType || type == Sys.FloatType || type == Sys.NumType || type == Sys.DecimalType;
    }

    public static String toJavaClassName(String string, String string2) {
        if (string.equals("sys")) {
            switch (string2.charAt(0)) {
                case 'B': {
                    if (!string2.equals("Bool")) break;
                    return "java.lang.Boolean";
                }
                case 'D': {
                    if (!string2.equals("Decimal")) break;
                    return "java.math.BigDecimal";
                }
                case 'F': {
                    if (!string2.equals("Float")) break;
                    return "java.lang.Double";
                }
                case 'I': {
                    if (!string2.equals("Int")) break;
                    return "java.lang.Long";
                }
                case 'N': {
                    if (!string2.equals("Num")) break;
                    return "java.lang.Number";
                }
                case 'O': {
                    if (!string2.equals("Obj")) break;
                    return "java.lang.Object";
                }
                case 'S': {
                    if (!string2.equals("Str")) break;
                    return "java.lang.String";
                }
            }
        }
        if (string.charAt(0) == '[') {
            return FanUtil.ffiToJavaClass(string, string2, false);
        }
        return "fan." + string + "." + string2;
    }

    public static String toJavaImplClassName(String string, String string2) {
        if (string.equals("sys")) {
            switch (string2.charAt(0)) {
                case 'B': {
                    if (!string2.equals("Bool")) break;
                    return "fan.sys.FanBool";
                }
                case 'D': {
                    if (!string2.equals("Decimal")) break;
                    return "fan.sys.FanDecimal";
                }
                case 'F': {
                    if (!string2.equals("Float")) break;
                    return "fan.sys.FanFloat";
                }
                case 'I': {
                    if (!string2.equals("Int")) break;
                    return "fan.sys.FanInt";
                }
                case 'N': {
                    if (!string2.equals("Num")) break;
                    return "fan.sys.FanNum";
                }
                case 'O': {
                    if (!string2.equals("Obj")) break;
                    return "fan.sys.FanObj";
                }
                case 'S': {
                    if (!string2.equals("Str")) break;
                    return "fan.sys.FanStr";
                }
            }
        }
        if (string.charAt(0) == '[') {
            return FanUtil.ffiToJavaClass(string, string2, false);
        }
        return "fan." + string + "." + string2;
    }

    public static String toJavaTypeSig(String string, String string2, boolean bl) {
        if (string.equals("sys")) {
            switch (string2.charAt(0)) {
                case 'B': {
                    if (!string2.equals("Bool")) break;
                    return bl ? "java/lang/Boolean" : "Z";
                }
                case 'D': {
                    if (!string2.equals("Decimal")) break;
                    return "java/math/BigDecimal";
                }
                case 'F': {
                    if (!string2.equals("Float")) break;
                    return bl ? "java/lang/Double" : "D";
                }
                case 'I': {
                    if (!string2.equals("Int")) break;
                    return bl ? "java/lang/Long" : "J";
                }
                case 'N': {
                    if (!string2.equals("Num")) break;
                    return "java/lang/Number";
                }
                case 'O': {
                    if (!string2.equals("Obj")) break;
                    return "java/lang/Object";
                }
                case 'S': {
                    if (!string2.equals("Str")) break;
                    return "java/lang/String";
                }
                case 'V': {
                    if (!string2.equals("Void")) break;
                    return "V";
                }
            }
        }
        if (string.charAt(0) == '[') {
            return FanUtil.ffiToJavaClass(string, string2, true);
        }
        return "fan/" + string + "/" + string2;
    }

    private static String ffiToJavaClass(String string, String string2, boolean bl) {
        boolean bl2;
        if (!string.startsWith("[java]")) {
            throw new UnsupportedOperationException("Invalid FFI: " + string);
        }
        if (string.length() == 6) {
            if (string2.equals("int")) {
                return bl ? "I" : "int";
            }
            if (string2.equals("char")) {
                return bl ? "C" : "char";
            }
            if (string2.equals("byte")) {
                return bl ? "B" : "byte";
            }
            if (string2.equals("short")) {
                return bl ? "S" : "short";
            }
            if (string2.equals("float")) {
                return bl ? "F" : "float";
            }
        }
        if (string.equals("[java]fanx.interop")) {
            if (string2.equals("BooleanArray")) {
                return "[Z";
            }
            if (string2.equals("ByteArray")) {
                return "[B";
            }
            if (string2.equals("ShortArray")) {
                return "[S";
            }
            if (string2.equals("CharArray")) {
                return "[C";
            }
            if (string2.equals("IntArray")) {
                return "[I";
            }
            if (string2.equals("LongArray")) {
                return "[J";
            }
            if (string2.equals("FloatArray")) {
                return "[F";
            }
            if (string2.equals("DoubleArray")) {
                return "[D";
            }
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length());
        boolean bl3 = bl2 = string2.charAt(0) == '[';
        if (bl2) {
            while (string2.charAt(0) == '[') {
                stringBuilder.append('[');
                string2 = string2.substring(1);
            }
            stringBuilder.append('L');
        }
        for (int i = 6; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                stringBuilder.append(bl ? (char)'/' : '.');
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append(bl ? (char)'/' : '.').append(string2);
        if (bl2) {
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public static String toJavaTypeSig(Type type) {
        return FanUtil.toJavaTypeSig(type.podName(), type.name(), type.isNullable());
    }

    public static String toJavaMemberSig(Type type) {
        String string = FanUtil.toJavaTypeSig(type);
        if (string.length() == 1) {
            return string;
        }
        if (string.charAt(0) == '[') {
            return string;
        }
        return "L" + string + ";";
    }

    public static int toJavaStackType(Type type) {
        if (!type.isNullable()) {
            if (type == Sys.VoidType) {
                return 86;
            }
            if (type == Sys.BoolType) {
                return 73;
            }
            if (type == Sys.IntType) {
                return 74;
            }
            if (type == Sys.FloatType) {
                return 68;
            }
            if (type.isJava() && type.podName().equals("[java]")) {
                if (type.name().equals("byte")) {
                    return 73;
                }
                if (type.name().equals("char")) {
                    return 73;
                }
                if (type.name().equals("short")) {
                    return 73;
                }
                if (type.name().equals("int")) {
                    return 73;
                }
                if (type.name().equals("float")) {
                    return 70;
                }
                if (type.name().equals("long")) {
                    return 76;
                }
                if (type.name().equals("boolean")) {
                    return 70;
                }
                if (type.name().equals("double")) {
                    return 68;
                }
            }
        }
        return 65;
    }

    public static String toJavaImplSig(String string) {
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case 'Z': {
                    return "fan/sys/FanBool";
                }
                case 'J': {
                    return "fan/sys/FanInt";
                }
                case 'D': {
                    return "fan/sys/FanFloat";
                }
            }
            throw new IllegalStateException(string);
        }
        if (string.charAt(0) == 'j') {
            if (string.equals("java/lang/Object")) {
                return "fan/sys/FanObj";
            }
            if (string.equals("java/lang/Boolean")) {
                return "fan/sys/FanBool";
            }
            if (string.equals("java/lang/String")) {
                return "fan/sys/FanStr";
            }
            if (string.equals("java/lang/Long")) {
                return "fan/sys/FanInt";
            }
            if (string.equals("java/lang/Double")) {
                return "fan/sys/FanFloat";
            }
            if (string.equals("java/lang/Number")) {
                return "fan/sys/FanNum";
            }
            if (string.equals("java/math/BigDecimal")) {
                return "fan/sys/FanDecimal";
            }
        }
        return string;
    }

    public static int classModifiersToFanFlags(int n) {
        int n2 = 0;
        if (Modifier.isAbstract(n)) {
            n2 |= 1;
        }
        if (Modifier.isFinal(n)) {
            n2 |= 0x20;
        }
        if (Modifier.isInterface(n)) {
            n2 |= 0x100;
        }
        n2 = Modifier.isPublic(n) ? (n2 |= 0x2000) : (n2 |= 0x80);
        return n2;
    }

    public static int memberModifiersToFanFlags(int n) {
        int n2 = 0;
        if (Modifier.isAbstract(n)) {
            n2 |= 1;
        }
        if (Modifier.isStatic(n)) {
            n2 |= 0x8000;
        }
        n2 = Modifier.isFinal(n) ? (n2 |= 0x20) : (n2 |= 0x40000);
        n2 = Modifier.isPublic(n) ? (n2 |= 0x2000) : (Modifier.isPrivate(n) ? (n2 |= 0x800) : (Modifier.isProtected(n) ? (n2 |= 0x1000) : (n2 |= 0x80)));
        return n2;
    }

    static {
        if (Sys.ObjType == null) {
            Thread.dumpStack();
        }
        javaToFanTypes.put("void", Sys.VoidType);
        javaToFanTypes.put("boolean", Sys.BoolType);
        javaToFanTypes.put("long", Sys.IntType);
        javaToFanTypes.put("double", Sys.FloatType);
        javaToFanTypes.put("java.lang.Object", Sys.ObjType);
        javaToFanTypes.put("java.lang.Boolean", Sys.BoolType);
        javaToFanTypes.put("java.lang.String", Sys.StrType);
        javaToFanTypes.put("java.lang.Number", Sys.NumType);
        javaToFanTypes.put("java.lang.Long", Sys.IntType);
        javaToFanTypes.put("java.lang.Double", Sys.FloatType);
        javaToFanTypes.put("java.math.BigDecimal", Sys.DecimalType);
        javaImmutables = new HashMap();
        javaImmutables.put("java.lang.Boolean", Boolean.TRUE);
        javaImmutables.put("java.lang.Byte", Boolean.TRUE);
        javaImmutables.put("java.lang.Character", Boolean.TRUE);
        javaImmutables.put("java.lang.Class", Boolean.TRUE);
        javaImmutables.put("java.lang.Double", Boolean.TRUE);
        javaImmutables.put("java.lang.Float", Boolean.TRUE);
        javaImmutables.put("java.lang.Integer", Boolean.TRUE);
        javaImmutables.put("java.lang.Long", Boolean.TRUE);
        javaImmutables.put("java.lang.Package", Boolean.TRUE);
        javaImmutables.put("java.lang.Short", Boolean.TRUE);
        javaImmutables.put("java.lang.String", Boolean.TRUE);
        javaImmutables.put("java.lang.reflect.Constructor", Boolean.TRUE);
        javaImmutables.put("java.lang.reflect.Field", Boolean.TRUE);
        javaImmutables.put("java.lang.reflect.Method", Boolean.TRUE);
        javaImmutables.put("java.math.BigDecimal", Boolean.TRUE);
        javaImmutables.put("java.math.BigInteger", Boolean.TRUE);
    }
}

