/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjaropenbeans;

import groovyjarjaropenbeans.IndexedPropertyChangeEvent;
import groovyjarjaropenbeans.PropertyChangeEvent;
import groovyjarjaropenbeans.PropertyChangeListener;
import groovyjarjaropenbeans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

public class PropertyChangeSupport
implements Serializable {
    private static final long serialVersionUID = 6401253773779951803L;
    private transient List<PropertyChangeListener> globalListeners = new ArrayList<PropertyChangeListener>();
    private Hashtable<String, PropertyChangeSupport> children = new Hashtable();
    private Object source;
    private int propertyChangeSupportSerializedDataVersion = 1;

    public PropertyChangeSupport(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.source = sourceBean;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = this.createPropertyChangeEvent(propertyName, oldValue, newValue);
        this.doFirePropertyChange(event);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.doFirePropertyChange(new IndexedPropertyChangeEvent(this.source, propertyName, oldValue, newValue, index));
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PropertyChangeSupport listeners;
        if (propertyName != null && listener != null && (listeners = this.children.get(propertyName)) != null) {
            listeners.removePropertyChangeListener(listener);
        }
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener != null && propertyName != null) {
            PropertyChangeSupport listeners = this.children.get(propertyName);
            if (listeners == null) {
                listeners = new PropertyChangeSupport(this.source);
                this.children.put(propertyName, listeners);
            }
            if (listener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
                listeners.addPropertyChangeListener(new PropertyChangeListenerProxy(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener()));
            } else {
                listeners.addPropertyChangeListener(listener);
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        PropertyChangeSupport listeners = null;
        if (propertyName != null) {
            listeners = this.children.get(propertyName);
        }
        return listeners == null ? new PropertyChangeListener[]{} : listeners.getPropertyChangeListeners();
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        PropertyChangeEvent event = this.createPropertyChangeEvent(propertyName, oldValue, newValue);
        this.doFirePropertyChange(event);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.fireIndexedPropertyChange(propertyName, index, (Object)oldValue, (Object)newValue);
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        PropertyChangeEvent event = this.createPropertyChangeEvent(propertyName, oldValue, newValue);
        this.doFirePropertyChange(event);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.fireIndexedPropertyChange(propertyName, index, (Object)oldValue, (Object)newValue);
        }
    }

    public synchronized boolean hasListeners(String propertyName) {
        if (this.globalListeners.size() > 0) {
            return true;
        }
        boolean result = false;
        if (propertyName != null) {
            PropertyChangeSupport listeners = this.children.get(propertyName);
            result = listeners != null && listeners.hasListeners(propertyName);
        }
        return result;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            String name = ((PropertyChangeListenerProxy)listener).getPropertyName();
            PropertyChangeListener lst = (PropertyChangeListener)((PropertyChangeListenerProxy)listener).getListener();
            this.removePropertyChangeListener(name, lst);
        } else {
            this.globalListeners.remove(listener);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            String name = ((PropertyChangeListenerProxy)listener).getPropertyName();
            PropertyChangeListener lst = (PropertyChangeListener)((PropertyChangeListenerProxy)listener).getListener();
            this.addPropertyChangeListener(name, lst);
        } else if (listener != null) {
            this.globalListeners.add(listener);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList<PropertyChangeListener> result = new ArrayList<PropertyChangeListener>(this.globalListeners);
        for (String propertyName : this.children.keySet()) {
            PropertyChangeSupport namedListener = this.children.get(propertyName);
            PropertyChangeListener[] listeners = namedListener.getPropertyChangeListeners();
            int i = 0;
            while (i < listeners.length) {
                result.add(new PropertyChangeListenerProxy(propertyName, listeners[i]));
                ++i;
            }
        }
        return result.toArray(new PropertyChangeListener[0]);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        PropertyChangeListener[] gListeners = this.globalListeners.toArray(new PropertyChangeListener[0]);
        int i = 0;
        while (i < gListeners.length) {
            if (gListeners[i] instanceof Serializable) {
                oos.writeObject(gListeners[i]);
            }
            ++i;
        }
        oos.writeObject(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.globalListeners = new LinkedList<PropertyChangeListener>();
        if (this.children == null) {
            this.children = new Hashtable();
        }
        Object listener = null;
        do {
            if ((listener = ois.readObject()) == null) continue;
            this.addPropertyChangeListener((PropertyChangeListener)listener);
        } while (listener != null);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        this.doFirePropertyChange(event);
    }

    private PropertyChangeEvent createPropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        return new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
    }

    private PropertyChangeEvent createPropertyChangeEvent(String propertyName, boolean oldValue, boolean newValue) {
        return new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
    }

    private PropertyChangeEvent createPropertyChangeEvent(String propertyName, int oldValue, int newValue) {
        return new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFirePropertyChange(PropertyChangeEvent event) {
        PropertyChangeSupport namedListener;
        PropertyChangeListener[] gListeners;
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeSupport propertyChangeSupport = this;
        synchronized (propertyChangeSupport) {
            gListeners = this.globalListeners.toArray(new PropertyChangeListener[0]);
        }
        int i = 0;
        while (i < gListeners.length) {
            gListeners[i].propertyChange(event);
            ++i;
        }
        if (event.getPropertyName() != null && (namedListener = this.children.get(event.getPropertyName())) != null) {
            namedListener.firePropertyChange(event);
        }
    }
}

