/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.PackageNameFilter;

class ExcludePackageNameFilter
implements PackageNameFilter {
    private final List<String> packageNames;
    private final String patternDescription;

    ExcludePackageNameFilter(String ... packageNames) {
        Preconditions.notEmpty((Object[])packageNames, (String)"packageNames must not be null or empty");
        Preconditions.containsNoNullElements((Object[])packageNames, (String)"packageNames must not contain null elements");
        this.packageNames = Arrays.asList(packageNames);
        this.patternDescription = Arrays.stream(packageNames).collect(Collectors.joining("' OR '", "'", "'"));
    }

    @Override
    public FilterResult apply(String packageName) {
        return this.findMatchingName(packageName).map(matchedName -> FilterResult.excluded(this.formatExclusionReason(packageName, (String)matchedName))).orElseGet(() -> FilterResult.included(this.formatInclusionReason(packageName)));
    }

    private String formatExclusionReason(String packageName, String matchedName) {
        return String.format("Package name [%s] matches excluded name: '%s'", packageName, matchedName);
    }

    private String formatInclusionReason(String packageName) {
        return String.format("Package name [%s] does not match any excluded names: %s", packageName, this.patternDescription);
    }

    @Override
    public Predicate<String> toPredicate() {
        return packageName -> !this.findMatchingName((String)packageName).isPresent();
    }

    private Optional<String> findMatchingName(String packageName) {
        return this.packageNames.stream().filter(name -> name.equals(packageName) || packageName.startsWith(name + ".")).findAny();
    }

    public String toString() {
        return "Excludes package names that start with " + this.patternDescription;
    }
}

