/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.testng.CommandLineArgs;
import org.testng.DataProviderHolder;
import org.testng.IAlterSuiteListener;
import org.testng.IAnnotationTransformer;
import org.testng.IClassListener;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IDataProviderInterceptor;
import org.testng.IDataProviderListener;
import org.testng.IDynamicGraph;
import org.testng.IExecutionListener;
import org.testng.IExecutionVisualiser;
import org.testng.IHookable;
import org.testng.IInjectorFactory;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestObjectFactory;
import org.testng.ITestRunnerFactory;
import org.testng.JarFileUtils;
import org.testng.SuiteRunner;
import org.testng.SuiteRunnerWorker;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ClassHelper;
import org.testng.internal.Configuration;
import org.testng.internal.DynamicGraph;
import org.testng.internal.ExitCode;
import org.testng.internal.ExitCodeListener;
import org.testng.internal.IConfiguration;
import org.testng.internal.OverrideProcessor;
import org.testng.internal.ReporterConfig;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Systematiser;
import org.testng.internal.Utils;
import org.testng.internal.Version;
import org.testng.internal.annotations.DefaultAnnotationTransformer;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.JDK15AnnotationFinder;
import org.testng.internal.invokers.SuiteRunnerMap;
import org.testng.internal.invokers.objects.GuiceContext;
import org.testng.internal.objects.DefaultTestObjectFactory;
import org.testng.internal.objects.Dispenser;
import org.testng.internal.objects.IObjectDispenser;
import org.testng.internal.objects.pojo.BasicAttributes;
import org.testng.internal.objects.pojo.CreationAttributes;
import org.testng.internal.thread.graph.SuiteWorkerFactory;
import org.testng.junit.JUnitTestFinder;
import org.testng.log4testng.Logger;
import org.testng.reporters.EmailableReporter;
import org.testng.reporters.EmailableReporter2;
import org.testng.reporters.FailedReporter;
import org.testng.reporters.JUnitReportReporter;
import org.testng.reporters.SuiteHTMLReporter;
import org.testng.reporters.VerboseReporter;
import org.testng.reporters.XMLReporter;
import org.testng.reporters.jq.Main;
import org.testng.thread.IExecutorFactory;
import org.testng.thread.ITestNGThreadPoolExecutor;
import org.testng.util.Strings;
import org.testng.xml.IPostProcessor;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.testng.xml.internal.Parser;
import org.testng.xml.internal.TestNamesMatcher;
import org.testng.xml.internal.XmlSuiteUtils;

public class TestNG {
    private static final Logger LOGGER = Logger.getLogger(TestNG.class);
    public static final String DEFAULT_COMMAND_LINE_SUITE_NAME = "Command line suite";
    public static final String DEFAULT_COMMAND_LINE_TEST_NAME = "Command line test";
    private static final String DEFAULT_THREADPOOL_FACTORY = "org.testng.internal.thread.DefaultThreadPoolExecutorFactory";
    public static final String DEFAULT_OUTPUTDIR = "test-output";
    private static TestNG m_instance;
    private static JCommander m_jCommander;
    private List<String> m_commandLineMethods;
    protected List<XmlSuite> m_suites = Lists.newArrayList();
    private List<XmlSuite> m_cmdlineSuites;
    private String m_outputDir = "test-output";
    private String[] m_includedGroups;
    private String[] m_excludedGroups;
    private Boolean m_isJUnit = XmlSuite.DEFAULT_JUNIT;
    private Boolean m_isMixed = XmlSuite.DEFAULT_MIXED;
    protected boolean m_useDefaultListeners = true;
    private boolean m_failIfAllTestsSkipped = false;
    private final List<String> m_listenersToSkipFromBeingWiredIn = new ArrayList<String>();
    private ITestRunnerFactory m_testRunnerFactory;
    private final Map<Class<? extends IClassListener>, IClassListener> m_classListeners = Maps.newLinkedHashMap();
    private final Map<Class<? extends ITestListener>, ITestListener> m_testListeners = Maps.newLinkedHashMap();
    private final Map<Class<? extends ISuiteListener>, ISuiteListener> m_suiteListeners = Maps.newLinkedHashMap();
    private final Map<Class<? extends IReporter>, IReporter> m_reporters = Maps.newLinkedHashMap();
    private final Map<Class<? extends IDataProviderListener>, IDataProviderListener> m_dataProviderListeners = Maps.newLinkedHashMap();
    private final Map<Class<? extends IDataProviderInterceptor>, IDataProviderInterceptor> m_dataProviderInterceptors = Maps.newLinkedHashMap();
    private IExecutorFactory m_executorFactory = null;
    public static final Integer DEFAULT_VERBOSE;
    private int m_threadCount = -1;
    private XmlSuite.ParallelMode m_parallelMode = null;
    private XmlSuite.FailurePolicy m_configFailurePolicy;
    private Class<?>[] m_commandLineTestClasses;
    private String m_defaultSuiteName = "Command line suite";
    private String m_defaultTestName = "Command line test";
    private final Map<String, Integer> m_methodDescriptors = Maps.newHashMap();
    private final Set<XmlMethodSelector> m_selectors = Sets.newLinkedHashSet();
    private static final ITestObjectFactory DEFAULT_OBJECT_FACTORY;
    private ITestObjectFactory m_objectFactory = DEFAULT_OBJECT_FACTORY;
    private final Map<Class<? extends IInvokedMethodListener>, IInvokedMethodListener> m_invokedMethodListeners = Maps.newLinkedHashMap();
    private Integer m_dataProviderThreadCount = null;
    private String m_jarPath;
    private String m_xmlPathInJar = "testng.xml";
    private List<String> m_stringSuites = Lists.newArrayList();
    private IHookable m_hookable;
    private IConfigurable m_configurable;
    protected long m_end;
    protected long m_start;
    private final Map<Class<? extends IAlterSuiteListener>, IAlterSuiteListener> m_alterSuiteListeners = Maps.newLinkedHashMap();
    private boolean m_isInitialized = false;
    private boolean isSuiteInitialized = false;
    private final ExitCodeListener exitCodeListener = new ExitCodeListener();
    private ExitCode exitCode;
    private final Map<Class<? extends IExecutionVisualiser>, IExecutionVisualiser> m_executionVisualisers = Maps.newLinkedHashMap();
    private Integer m_verbose = null;
    private final IAnnotationTransformer m_defaultAnnoProcessor;
    private IAnnotationTransformer m_annotationTransformer = this.m_defaultAnnoProcessor = new DefaultAnnotationTransformer();
    private Boolean m_skipFailedInvocationCounts = false;
    private final List<IMethodInterceptor> m_methodInterceptors = Lists.newArrayList();
    private List<String> m_testNames;
    private Integer m_suiteThreadPoolSize = CommandLineArgs.SUITE_THREAD_POOL_SIZE_DEFAULT;
    private boolean m_randomizeSuites = Boolean.FALSE;
    private boolean m_alwaysRun = Boolean.TRUE;
    private Boolean m_preserveOrder = XmlSuite.DEFAULT_PRESERVE_ORDER;
    private Boolean m_groupByInstances;
    private IConfiguration m_configuration;
    private URLClassLoader m_serviceLoaderClassLoader;
    private final Map<Class<? extends ITestNGListener>, ITestNGListener> serviceLoaderListeners = Maps.newHashMap();

    public TestNG() {
        this.init(true);
        if (RuntimeBehavior.isMemoryFriendlyMode()) {
            Logger.getLogger(TestNG.class).warn("TestNG is running in memory friendly mode.");
        }
    }

    public TestNG(boolean useDefaultListeners) {
        this.init(useDefaultListeners);
    }

    private void init(boolean useDefaultListeners) {
        m_instance = this;
        this.m_useDefaultListeners = useDefaultListeners;
        this.m_configuration = new Configuration();
    }

    public void toggleFailureIfAllTestsWereSkipped(boolean failIfAllTestsSkipped) {
        this.m_failIfAllTestsSkipped = failIfAllTestsSkipped;
    }

    public void setListenersToSkipFromBeingWiredInViaServiceLoaders(String ... listeners) {
        this.m_listenersToSkipFromBeingWiredIn.addAll(Arrays.asList(listeners));
    }

    public int getStatus() {
        if (this.exitCodeListener.noTestsFound()) {
            return 8;
        }
        return this.exitCode.getExitCode();
    }

    public void setOutputDirectory(String outputdir) {
        if (Utils.isStringNotEmpty(outputdir)) {
            this.m_outputDir = outputdir;
        }
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.m_useDefaultListeners = useDefaultListeners;
    }

    public void setTestJar(String jarPath) {
        this.m_jarPath = jarPath;
    }

    public void setXmlPathInJar(String xmlPathInJar) {
        this.m_xmlPathInJar = xmlPathInJar;
    }

    private void parseSuiteFiles() {
        OverrideProcessor processor = this.getProcessor();
        for (XmlSuite s : this.m_suites) {
            if (s.isParsed()) continue;
            for (String suiteFile : s.getSuiteFiles()) {
                try {
                    String fileNameToUse = s.getFileName();
                    if (fileNameToUse == null || fileNameToUse.trim().isEmpty()) {
                        fileNameToUse = suiteFile;
                    }
                    Collection<XmlSuite> childSuites = Parser.parse(fileNameToUse, (IPostProcessor)processor);
                    for (XmlSuite cSuite : childSuites) {
                        cSuite.setParentSuite(s);
                        s.getChildSuites().add(cSuite);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.out);
                }
            }
        }
    }

    private OverrideProcessor getProcessor() {
        return new OverrideProcessor(this.m_includedGroups, this.m_excludedGroups);
    }

    private Collection<XmlSuite> parseSuite(String suitePath) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("suiteXmlPath: \"" + suitePath + "\"");
        }
        try {
            return Parser.parse(suitePath, (IPostProcessor)this.getProcessor());
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        catch (Exception ex) {
            Throwable t = ex;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof TestNGException) {
                throw (TestNGException)t;
            }
            throw new TestNGException(t);
        }
        return Collections.emptySet();
    }

    private Collection<XmlSuite> processCommandLineArgs(Collection<XmlSuite> allSuites) {
        ArrayList<XmlSuite> result = new ArrayList<XmlSuite>();
        for (XmlSuite s : allSuites) {
            this.processParallelModeCommandLineArgs(s);
            if (this.m_testNames == null) {
                result.add(s);
                continue;
            }
            TestNamesMatcher testNamesMatcher = new TestNamesMatcher(s, this.m_testNames);
            List<String> missMatchedTestname = testNamesMatcher.getMissMatchedTestNames();
            if (!missMatchedTestname.isEmpty()) {
                throw new TestNGException("The test(s) <" + missMatchedTestname + "> cannot be found.");
            }
            result.addAll(testNamesMatcher.getSuitesMatchingTestNames());
        }
        return result;
    }

    private void processParallelModeCommandLineArgs(XmlSuite suite) {
        if (this.m_parallelMode != null) {
            suite.setParallel(this.m_parallelMode);
        }
        if (this.m_threadCount > 0) {
            suite.setThreadCount(this.m_threadCount);
        }
        if (suite.getChildSuites() != null) {
            suite.getChildSuites().forEach(this::processParallelModeCommandLineArgs);
        }
    }

    public void initializeSuitesAndJarFile() {
        Collection<XmlSuite> allSuites;
        if (this.isSuiteInitialized) {
            return;
        }
        this.isSuiteInitialized = true;
        if (!this.m_suites.isEmpty()) {
            this.parseSuiteFiles();
            return;
        }
        for (String string : this.m_stringSuites) {
            allSuites = this.parseSuite(string);
            this.m_suites.addAll(this.processCommandLineArgs(allSuites));
        }
        if (this.m_jarPath != null && !this.m_stringSuites.isEmpty()) {
            StringBuilder suites = new StringBuilder();
            for (String s : this.m_stringSuites) {
                suites.append(s);
            }
            Utils.log("TestNG", 2, "Ignoring the XML file inside " + this.m_jarPath + " and using " + suites + " instead");
            return;
        }
        if (Utils.isStringEmpty(this.m_jarPath)) {
            return;
        }
        File jarFile = new File(this.m_jarPath);
        JarFileUtils jarFileUtils = new JarFileUtils(this.getProcessor(), this.m_xmlPathInJar, this.m_testNames, this.m_parallelMode);
        allSuites = jarFileUtils.extractSuitesFrom(jarFile);
        this.m_suites.addAll(this.processCommandLineArgs(allSuites));
    }

    public void setThreadCount(int threadCount) {
        if (threadCount < 1) {
            TestNG.exitWithError("Cannot use a threadCount parameter less than 1; 1 > " + threadCount);
        }
        this.m_threadCount = threadCount;
    }

    @Deprecated
    public void setParallel(String parallel) {
        this.setParallel(XmlSuite.ParallelMode.getValidParallel(parallel));
    }

    public void setParallel(XmlSuite.ParallelMode parallel) {
        this.m_parallelMode = parallel;
    }

    public void setCommandLineSuite(XmlSuite suite) {
        this.m_cmdlineSuites = Lists.newArrayList();
        this.m_cmdlineSuites.add(suite);
        this.m_suites.add(suite);
    }

    public void setTestClasses(Class[] classes) {
        this.m_suites.clear();
        this.m_commandLineTestClasses = classes;
    }

    private String[] splitMethod(String m) {
        int index = m.lastIndexOf(".");
        if (index < 0) {
            throw new TestNGException("Bad format for command line method:" + m + ", expected <class>.<method>");
        }
        return new String[]{m.substring(0, index), m.substring(index + 1).replaceAll("\\*", "\\.\\*")};
    }

    private List<XmlSuite> createCommandLineSuitesForMethods(List<String> commandLineMethods) {
        Set classes = Sets.newHashSet();
        for (String m : commandLineMethods) {
            Class<?> c = ClassHelper.forName(this.splitMethod(m)[0]);
            if (c == null) continue;
            classes.add(c);
        }
        List<XmlSuite> result = this.createCommandLineSuitesForClasses(classes.toArray(new Class[0]));
        List<XmlClass> xmlClasses = Lists.newArrayList();
        for (XmlSuite s : result) {
            for (XmlTest t : s.getTests()) {
                xmlClasses.addAll(t.getClasses());
            }
        }
        for (XmlClass xc : xmlClasses) {
            for (String m : commandLineMethods) {
                String[] split = this.splitMethod(m);
                String className = split[0];
                if (!xc.getName().equals(className)) continue;
                XmlInclude includedMethod = new XmlInclude(split[1]);
                xc.getIncludedMethods().add(includedMethod);
            }
        }
        return result;
    }

    private List<XmlSuite> createCommandLineSuitesForClasses(Class[] classes) {
        XmlClass[] xmlClasses = (XmlClass[])Arrays.stream(classes).map(clazz -> new XmlClass((Class)clazz, true)).toArray(XmlClass[]::new);
        Map<String, XmlSuite> suites = Maps.newHashMap();
        IAnnotationFinder finder = this.m_configuration.getAnnotationFinder();
        for (int i = 0; i < classes.length; ++i) {
            Class c = classes[i];
            ITestAnnotation test = finder.findAnnotation(c, ITestAnnotation.class);
            String suiteName = this.getDefaultSuiteName();
            String testName = this.getDefaultTestName();
            boolean isJUnit = false;
            if (test != null) {
                suiteName = Utils.defaultIfStringEmpty(test.getSuiteName(), suiteName);
                testName = Utils.defaultIfStringEmpty(test.getTestName(), testName);
            } else if (this.m_isMixed.booleanValue() && JUnitTestFinder.isJUnitTest(c)) {
                isJUnit = true;
                testName = c.getName();
            }
            XmlSuite xmlSuite = (XmlSuite)suites.get(suiteName);
            if (xmlSuite == null) {
                xmlSuite = new XmlSuite();
                xmlSuite.setName(suiteName);
                suites.put(suiteName, xmlSuite);
            }
            if (this.m_dataProviderThreadCount != null) {
                xmlSuite.setDataProviderThreadCount(this.m_dataProviderThreadCount);
            }
            XmlTest xmlTest = null;
            for (XmlTest xt : xmlSuite.getTests()) {
                if (!xt.getName().equals(testName)) continue;
                xmlTest = xt;
                break;
            }
            if (xmlTest == null) {
                xmlTest = new XmlTest(xmlSuite);
                xmlTest.setName(testName);
                xmlTest.setJUnit(isJUnit);
            }
            xmlTest.getXmlClasses().add(xmlClasses[i]);
        }
        return new ArrayList<XmlSuite>(suites.values());
    }

    public void addMethodSelector(String className, int priority) {
        if (Strings.isNotNullAndNotEmpty(className)) {
            this.m_methodDescriptors.put(className, priority);
        }
    }

    public void addMethodSelector(XmlMethodSelector selector) {
        this.m_selectors.add(selector);
    }

    public void setReportAllDataDrivenTestsAsSkipped(boolean reportAllDataDrivenTestsAsSkipped) {
        this.m_configuration.setReportAllDataDrivenTestsAsSkipped(reportAllDataDrivenTestsAsSkipped);
    }

    public boolean getReportAllDataDrivenTestsAsSkipped() {
        return this.m_configuration.getReportAllDataDrivenTestsAsSkipped();
    }

    public void setTestSuites(List<String> suites) {
        this.m_stringSuites = suites;
    }

    public void setXmlSuites(List<XmlSuite> suites) {
        this.m_suites = suites;
    }

    public void setExcludedGroups(String groups) {
        this.m_excludedGroups = Utils.split(groups, ",");
    }

    public void setGroups(String groups) {
        this.m_includedGroups = Utils.split(groups, ",");
    }

    private void setTestRunnerFactoryClass(Class<? extends ITestRunnerFactory> testRunnerFactoryClass) {
        this.setTestRunnerFactory(this.m_objectFactory.newInstance(testRunnerFactoryClass, new Object[0]));
    }

    protected void setTestRunnerFactory(ITestRunnerFactory itrf) {
        this.m_testRunnerFactory = itrf;
    }

    public void setObjectFactory(Class<? extends ITestObjectFactory> c) {
        this.setObjectFactory(this.m_objectFactory.newInstance(c, new Object[0]));
    }

    public void setObjectFactory(ITestObjectFactory factory) {
        this.m_objectFactory = factory;
    }

    public void setListenerClasses(List<Class<? extends ITestNGListener>> classes) {
        for (Class<? extends ITestNGListener> cls : classes) {
            this.addListener(this.m_objectFactory.newInstance(cls, new Object[0]));
        }
    }

    @Deprecated
    public void addListener(Object listener) {
        if (!(listener instanceof ITestNGListener)) {
            TestNG.exitWithError("Listener " + listener + " must be one of ITestListener, ISuiteListener, IReporter,  IAnnotationTransformer, IMethodInterceptor or IInvokedMethodListener");
        }
        this.addListener((ITestNGListener)listener);
    }

    private static <E> void maybeAddListener(Map<Class<? extends E>, E> map, E value) {
        TestNG.maybeAddListener(map, value.getClass(), value, false);
    }

    private static <E> void maybeAddListener(Map<Class<? extends E>, E> map, Class<? extends E> type, E value, boolean quiet) {
        if (map.putIfAbsent(type, value) != null && !quiet) {
            LOGGER.warn("Ignoring duplicate listener : " + type.getName());
        }
    }

    public void addListener(ITestNGListener listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof IExecutionVisualiser) {
            IExecutionVisualiser visualiser = (IExecutionVisualiser)listener;
            TestNG.maybeAddListener(this.m_executionVisualisers, visualiser);
        }
        if (listener instanceof ISuiteListener) {
            ISuiteListener suite = (ISuiteListener)listener;
            TestNG.maybeAddListener(this.m_suiteListeners, suite);
        }
        if (listener instanceof ITestListener) {
            ITestListener test = (ITestListener)listener;
            TestNG.maybeAddListener(this.m_testListeners, test);
        }
        if (listener instanceof IClassListener) {
            IClassListener clazz = (IClassListener)listener;
            TestNG.maybeAddListener(this.m_classListeners, clazz);
        }
        if (listener instanceof IReporter) {
            IReporter reporter = (IReporter)listener;
            TestNG.maybeAddListener(this.m_reporters, reporter);
        }
        if (listener instanceof IAnnotationTransformer) {
            this.setAnnotationTransformer((IAnnotationTransformer)listener);
        }
        if (listener instanceof IMethodInterceptor) {
            this.m_methodInterceptors.add((IMethodInterceptor)listener);
        }
        if (listener instanceof IInvokedMethodListener) {
            IInvokedMethodListener method = (IInvokedMethodListener)listener;
            TestNG.maybeAddListener(this.m_invokedMethodListeners, method);
        }
        if (listener instanceof IHookable) {
            this.setHookable((IHookable)listener);
        }
        if (listener instanceof IConfigurable) {
            this.setConfigurable((IConfigurable)listener);
        }
        if (listener instanceof IExecutionListener) {
            this.m_configuration.addExecutionListenerIfAbsent((IExecutionListener)listener);
        }
        if (listener instanceof IConfigurationListener) {
            this.m_configuration.addConfigurationListener((IConfigurationListener)listener);
        }
        if (listener instanceof IAlterSuiteListener) {
            IAlterSuiteListener alter = (IAlterSuiteListener)listener;
            TestNG.maybeAddListener(this.m_alterSuiteListeners, alter);
        }
        if (listener instanceof IDataProviderListener) {
            IDataProviderListener dataProvider = (IDataProviderListener)listener;
            TestNG.maybeAddListener(this.m_dataProviderListeners, dataProvider);
        }
        if (listener instanceof IDataProviderInterceptor) {
            IDataProviderInterceptor interceptor = (IDataProviderInterceptor)listener;
            TestNG.maybeAddListener(this.m_dataProviderInterceptors, interceptor);
        }
    }

    public Set<IReporter> getReporters() {
        return Sets.newHashSet(this.m_reporters.values());
    }

    public List<ITestListener> getTestListeners() {
        return Lists.newArrayList(this.m_testListeners.values());
    }

    public List<ISuiteListener> getSuiteListeners() {
        return Lists.newArrayList(this.m_suiteListeners.values());
    }

    public void setVerbose(int verbose) {
        this.m_verbose = verbose;
    }

    public void setExecutorFactoryClass(String clazzName) {
        this.m_executorFactory = this.createExecutorFactoryInstanceUsing(clazzName);
    }

    private IExecutorFactory createExecutorFactoryInstanceUsing(String clazzName) {
        Class<?> cls = ClassHelper.forName(clazzName);
        Object instance = this.m_objectFactory.newInstance(cls, new Object[0]);
        if (instance instanceof IExecutorFactory) {
            return (IExecutorFactory)instance;
        }
        throw new IllegalArgumentException(clazzName + " does not implement " + IExecutorFactory.class.getName());
    }

    public void setExecutorFactory(IExecutorFactory factory) {
        this.m_executorFactory = factory;
    }

    public IExecutorFactory getExecutorFactory() {
        if (this.m_executorFactory == null) {
            this.m_executorFactory = this.createExecutorFactoryInstanceUsing(DEFAULT_THREADPOOL_FACTORY);
        }
        return this.m_executorFactory;
    }

    private void initializeCommandLineSuites() {
        if (this.m_commandLineTestClasses != null || this.m_commandLineMethods != null) {
            this.m_cmdlineSuites = null != this.m_commandLineMethods ? this.createCommandLineSuitesForMethods(this.m_commandLineMethods) : this.createCommandLineSuitesForClasses(this.m_commandLineTestClasses);
            for (XmlSuite s : this.m_cmdlineSuites) {
                for (XmlTest t : s.getTests()) {
                    t.setPreserveOrder(this.m_preserveOrder);
                }
                this.m_suites.add(s);
                if (this.m_groupByInstances == null) continue;
                s.setGroupByInstances(this.m_groupByInstances);
            }
        }
    }

    private void initializeCommandLineSuitesParams() {
        if (null == this.m_cmdlineSuites) {
            return;
        }
        for (XmlSuite s : this.m_cmdlineSuites) {
            if (this.m_threadCount != -1) {
                s.setThreadCount(this.m_threadCount);
            }
            if (this.m_parallelMode != null) {
                s.setParallel(this.m_parallelMode);
            }
            if (this.m_configFailurePolicy == null) continue;
            s.setConfigFailurePolicy(this.m_configFailurePolicy);
        }
    }

    private void initializeCommandLineSuitesGroups() {
        List<XmlSuite> suites;
        boolean hasIncludedGroups = null != this.m_includedGroups && this.m_includedGroups.length > 0;
        boolean hasExcludedGroups = null != this.m_excludedGroups && this.m_excludedGroups.length > 0;
        List<XmlSuite> list = suites = this.m_cmdlineSuites != null ? this.m_cmdlineSuites : this.m_suites;
        if (hasIncludedGroups || hasExcludedGroups) {
            for (XmlSuite s : suites) {
                TestNG.initializeCommandLineSuitesGroups(s, hasIncludedGroups, this.m_includedGroups, hasExcludedGroups, this.m_excludedGroups);
            }
        }
    }

    private static void initializeCommandLineSuitesGroups(XmlSuite s, boolean hasIncludedGroups, String[] m_includedGroups, boolean hasExcludedGroups, String[] m_excludedGroups) {
        if (hasIncludedGroups) {
            s.setIncludedGroups(Arrays.asList(m_includedGroups));
        }
        if (hasExcludedGroups) {
            s.setExcludedGroups(Arrays.asList(m_excludedGroups));
        }
        for (XmlSuite child : s.getChildSuites()) {
            TestNG.initializeCommandLineSuitesGroups(child, hasIncludedGroups, m_includedGroups, hasExcludedGroups, m_excludedGroups);
        }
    }

    private void addReporter(Class<? extends IReporter> r) {
        if (!this.m_reporters.containsKey(r)) {
            this.m_reporters.put(r, this.m_objectFactory.newInstance(r, new Object[0]));
        }
    }

    private void initializeDefaultListeners() {
        if (this.m_failIfAllTestsSkipped) {
            this.exitCodeListener.failIfAllTestsSkipped();
        }
        this.addListener(this.exitCodeListener);
        if (this.m_useDefaultListeners) {
            this.addReporter(SuiteHTMLReporter.class);
            this.addReporter(Main.class);
            this.addReporter(FailedReporter.class);
            this.addReporter(XMLReporter.class);
            if (RuntimeBehavior.useOldTestNGEmailableReporter()) {
                this.addReporter(EmailableReporter.class);
            } else if (RuntimeBehavior.useEmailableReporter()) {
                this.addReporter(EmailableReporter2.class);
            }
            this.addReporter(JUnitReportReporter.class);
            if (this.m_verbose != null && this.m_verbose > 4) {
                this.addListener(new VerboseReporter("[TestNG] "));
            }
        }
    }

    private void initializeConfiguration() {
        ITestObjectFactory factory = this.m_objectFactory;
        this.addServiceLoaderListeners();
        for (XmlSuite s : this.m_suites) {
            this.addListeners(s);
            for (XmlMethodSelector methodSelector : s.getMethodSelectors()) {
                this.addMethodSelector(methodSelector.getClassName(), methodSelector.getPriority());
                this.addMethodSelector(methodSelector);
            }
            if (s.getObjectFactoryClass() == null) continue;
            if (factory != DEFAULT_OBJECT_FACTORY) {
                throw new TestNGException("Found more than one object-factory tag in your suites");
            }
            factory = this.m_objectFactory.newInstance(s.getObjectFactoryClass(), new Object[0]);
        }
        this.m_configuration.setAnnotationFinder(new JDK15AnnotationFinder(this.getAnnotationTransformer()));
        this.m_configuration.setHookable(this.m_hookable);
        this.m_configuration.setConfigurable(this.m_configurable);
        this.m_configuration.setObjectFactory(factory);
        this.m_configuration.setAlwaysRunListeners(this.m_alwaysRun);
        this.m_configuration.setExecutorFactory(this.getExecutorFactory());
    }

    private void addListeners(XmlSuite s) {
        IObjectDispenser dispenser = Dispenser.newInstance(this.m_objectFactory);
        GuiceContext context = new GuiceContext(s, this.m_configuration);
        for (String listenerName : s.getListeners()) {
            Class<?> listenerClass = ClassHelper.forName(listenerName);
            if (listenerClass == null) {
                throw new TestNGException("Listener " + listenerName + " was not found in project's classpath");
            }
            BasicAttributes basic = new BasicAttributes(null, listenerClass);
            CreationAttributes attribute = new CreationAttributes(basic, context);
            Object listener = dispenser.dispense(attribute);
            this.addListener((ITestNGListener)listener);
        }
        List<XmlSuite> childSuites = s.getChildSuites();
        for (XmlSuite c : childSuites) {
            this.addListeners(c);
        }
    }

    private void addServiceLoaderListeners() {
        ServiceLoader<ITestNGListener> loader = this.m_serviceLoaderClassLoader != null ? ServiceLoader.load(ITestNGListener.class, this.m_serviceLoaderClassLoader) : ServiceLoader.load(ITestNGListener.class);
        for (ITestNGListener l : loader) {
            Utils.log("[TestNG]", 2, "Adding ServiceLoader listener:" + l);
            if (this.m_listenersToSkipFromBeingWiredIn.contains(l.getClass().getName())) {
                Utils.log("[TestNG]", 2, "Skipping adding the listener :" + l);
                continue;
            }
            this.addListener(l);
            this.addServiceLoaderListener(l);
        }
    }

    private void sanityCheck() {
        XmlSuiteUtils.validateIfSuitesContainDuplicateTests(this.m_suites);
        XmlSuiteUtils.adjustSuiteNamesToEnsureUniqueness(this.m_suites);
    }

    public void initializeEverything() {
        if (this.m_isInitialized) {
            return;
        }
        this.initializeSuitesAndJarFile();
        this.initializeConfiguration();
        this.initializeDefaultListeners();
        this.initializeCommandLineSuites();
        this.initializeCommandLineSuitesParams();
        this.initializeCommandLineSuitesGroups();
        this.m_isInitialized = true;
    }

    public void run() {
        this.initializeEverything();
        this.sanityCheck();
        this.runExecutionListeners(true);
        this.runSuiteAlterationListeners();
        this.m_start = System.currentTimeMillis();
        List<ISuite> suiteRunners = this.runSuites();
        this.m_end = System.currentTimeMillis();
        if (null != suiteRunners) {
            this.generateReports(suiteRunners);
        }
        this.runExecutionListeners(false);
        this.exitCode = this.exitCodeListener.getStatus();
        if (this.exitCodeListener.noTestsFound() && TestRunner.getVerbose() > 1) {
            System.err.println("[TestNG] No tests found. Nothing was run");
            TestNG.usage();
        }
        m_instance = null;
        m_jCommander = null;
    }

    protected List<ISuite> runSuites() {
        return this.runSuitesLocally();
    }

    private void runSuiteAlterationListeners() {
        for (IAlterSuiteListener l : this.m_alterSuiteListeners.values()) {
            l.alter(this.m_suites);
        }
    }

    private void runExecutionListeners(boolean start) {
        List<IExecutionListener> executionListeners = this.m_configuration.getExecutionListeners();
        if (start) {
            for (IExecutionListener l : executionListeners) {
                l.onExecutionStart();
            }
        } else {
            List<IExecutionListener> executionListenersReversed = Lists.newReversedArrayList(executionListeners);
            for (IExecutionListener l : executionListenersReversed) {
                l.onExecutionFinish();
            }
        }
    }

    private static void usage() {
        if (m_jCommander == null) {
            m_jCommander = new JCommander((Object)new CommandLineArgs());
        }
        m_jCommander.usage();
    }

    private void generateReports(List<ISuite> suiteRunners) {
        for (IReporter reporter : this.m_reporters.values()) {
            try {
                long start = System.currentTimeMillis();
                reporter.generateReport(this.m_suites, suiteRunners, this.m_outputDir);
                Utils.log("TestNG", 2, "Time taken by " + reporter + ": " + (System.currentTimeMillis() - start) + " ms");
            }
            catch (Exception ex) {
                System.err.println("[TestNG] Reporter " + reporter + " failed");
                ex.printStackTrace(System.err);
            }
        }
    }

    public List<ISuite> runSuitesLocally() {
        if (this.m_suites.isEmpty()) {
            TestNG.error("No test suite found. Nothing to run");
            TestNG.usage();
            return Collections.emptyList();
        }
        SuiteRunnerMap suiteRunnerMap = new SuiteRunnerMap();
        if (this.m_suites.get(0).getVerbose() >= 2) {
            Version.displayBanner();
        }
        for (XmlSuite xmlSuite : this.m_suites) {
            this.createSuiteRunners(suiteRunnerMap, xmlSuite);
        }
        if (this.m_suiteThreadPoolSize == 1 && !this.m_randomizeSuites) {
            for (XmlSuite xmlSuite : this.m_suites) {
                this.runSuitesSequentially(xmlSuite, suiteRunnerMap, this.getVerbose(xmlSuite), this.getDefaultSuiteName());
            }
            return Lists.newArrayList(suiteRunnerMap.values());
        }
        DynamicGraph<ISuite> suiteGraph = new DynamicGraph<ISuite>();
        for (XmlSuite xmlSuite : this.m_suites) {
            this.populateSuiteGraph(suiteGraph, suiteRunnerMap, xmlSuite);
        }
        SuiteWorkerFactory suiteWorkerFactory = new SuiteWorkerFactory(suiteRunnerMap, 0, this.getDefaultSuiteName());
        ITestNGThreadPoolExecutor pooledExecutor = this.getExecutorFactory().newSuiteExecutor("suites", suiteGraph, suiteWorkerFactory, this.m_suiteThreadPoolSize, this.m_suiteThreadPoolSize, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), null);
        Utils.log("TestNG", 2, "Starting executor for all suites");
        pooledExecutor.run();
        try {
            pooledExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            pooledExecutor.shutdownNow();
        }
        catch (InterruptedException handled) {
            Thread.currentThread().interrupt();
            TestNG.error("Error waiting for concurrent executors to finish " + handled.getMessage());
        }
        return Lists.newArrayList(suiteRunnerMap.values());
    }

    private static void error(String s) {
        LOGGER.error(s);
    }

    private int getVerbose(XmlSuite xmlSuite) {
        return xmlSuite.getVerbose() != null ? xmlSuite.getVerbose() : (this.m_verbose != null ? this.m_verbose : RuntimeBehavior.getDefaultVerboseLevel());
    }

    private void runSuitesSequentially(XmlSuite xmlSuite, SuiteRunnerMap suiteRunnerMap, int verbose, String defaultSuiteName) {
        for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
            this.runSuitesSequentially(childSuite, suiteRunnerMap, verbose, defaultSuiteName);
        }
        SuiteRunnerWorker srw = new SuiteRunnerWorker(suiteRunnerMap.get(xmlSuite), suiteRunnerMap, verbose, defaultSuiteName);
        srw.run();
    }

    private void populateSuiteGraph(IDynamicGraph<ISuite> suiteGraph, SuiteRunnerMap suiteRunnerMap, XmlSuite xmlSuite) {
        ISuite parentSuiteRunner = suiteRunnerMap.get(xmlSuite);
        suiteGraph.addNode(parentSuiteRunner);
        if (!xmlSuite.getChildSuites().isEmpty()) {
            for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
                suiteGraph.addEdge(0, parentSuiteRunner, suiteRunnerMap.get(childSuite));
                this.populateSuiteGraph(suiteGraph, suiteRunnerMap, childSuite);
            }
        }
    }

    private void createSuiteRunners(SuiteRunnerMap suiteRunnerMap, XmlSuite xmlSuite) {
        if (null != this.m_isJUnit && !this.m_isJUnit.equals(XmlSuite.DEFAULT_JUNIT)) {
            xmlSuite.setJUnit(this.m_isJUnit);
        }
        if (null != this.m_skipFailedInvocationCounts) {
            xmlSuite.setSkipFailedInvocationCounts(this.m_skipFailedInvocationCounts);
        }
        if (this.m_verbose != null) {
            xmlSuite.setVerbose(this.m_verbose);
        }
        if (null != this.m_configFailurePolicy) {
            xmlSuite.setConfigFailurePolicy(this.m_configFailurePolicy);
        }
        if (null != this.m_dataProviderThreadCount) {
            xmlSuite.setDataProviderThreadCount(this.m_dataProviderThreadCount);
        }
        Set selectors = Sets.newHashSet();
        for (XmlTest t : xmlSuite.getTests()) {
            for (Map.Entry<String, Integer> ms : this.m_methodDescriptors.entrySet()) {
                XmlMethodSelector xms = new XmlMethodSelector();
                xms.setName(ms.getKey());
                xms.setPriority(ms.getValue());
                selectors.add(xms);
            }
            selectors.addAll(this.m_selectors);
            t.getMethodSelectors().addAll(Lists.newArrayList(selectors));
        }
        suiteRunnerMap.put(xmlSuite, this.createSuiteRunner(xmlSuite));
        for (XmlSuite childSuite : xmlSuite.getChildSuites()) {
            this.createSuiteRunners(suiteRunnerMap, childSuite);
        }
    }

    private SuiteRunner createSuiteRunner(XmlSuite xmlSuite) {
        DataProviderHolder holder = new DataProviderHolder();
        holder.addListeners(this.m_dataProviderListeners.values());
        holder.addInterceptors(this.m_dataProviderInterceptors.values());
        SuiteRunner result = new SuiteRunner(this.getConfiguration(), xmlSuite, this.m_outputDir, this.m_testRunnerFactory, this.m_useDefaultListeners, this.m_methodInterceptors, this.m_invokedMethodListeners.values(), this.m_testListeners.values(), this.m_classListeners.values(), holder, Systematiser.getComparator());
        for (ISuiteListener isl : this.m_suiteListeners.values()) {
            result.addListener(isl);
        }
        for (IReporter r : result.getReporters()) {
            TestNG.maybeAddListener(this.m_reporters, r.getClass(), r, true);
        }
        for (IConfigurationListener cl : this.m_configuration.getConfigurationListeners()) {
            result.addConfigurationListener(cl);
        }
        this.m_executionVisualisers.values().forEach(result::addListener);
        return result;
    }

    protected IConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public static void main(String[] argv) {
        TestNG testng = TestNG.privateMain(argv, null);
        System.exit(testng.getStatus());
    }

    public static TestNG privateMain(String[] argv, ITestListener listener) {
        TestNG result = new TestNG();
        if (null != listener) {
            result.addListener(listener);
        }
        try {
            CommandLineArgs cla = new CommandLineArgs();
            m_jCommander = new JCommander((Object)cla);
            m_jCommander.parse(argv);
            TestNG.validateCommandLineParameters(cla);
            result.configure(cla);
        }
        catch (ParameterException ex) {
            TestNG.exitWithError(ex.getMessage());
        }
        try {
            result.run();
        }
        catch (TestNGException ex) {
            if (TestRunner.getVerbose() > 1) {
                ex.printStackTrace(System.out);
            } else {
                TestNG.error(ex.getMessage());
            }
            result.exitCode = ExitCode.newExitCodeRepresentingFailure();
        }
        return result;
    }

    protected void configure(CommandLineArgs cla) {
        ReporterConfig reporterConfig;
        Class<?> clazz;
        this.setReportAllDataDrivenTestsAsSkipped(cla.includeAllDataDrivenTestsWhenSkipping);
        if (cla.verbose != null) {
            this.setVerbose(cla.verbose);
        }
        if (cla.dependencyInjectorFactoryClass != null && (clazz = ClassHelper.forName(cla.dependencyInjectorFactoryClass)) != null && IInjectorFactory.class.isAssignableFrom(clazz)) {
            this.m_configuration.setInjectorFactory((IInjectorFactory)this.m_objectFactory.newInstance(clazz, new Object[0]));
        }
        if (cla.threadPoolFactoryClass != null) {
            this.setExecutorFactoryClass(cla.threadPoolFactoryClass);
        }
        this.setOutputDirectory(cla.outputDirectory);
        String testClasses = cla.testClass;
        if (null != testClasses) {
            String[] strClasses = testClasses.split(",");
            List classes = Lists.newArrayList();
            String[] stringArray = strClasses;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String c = stringArray[i];
                classes.add(ClassHelper.fileToClass(c));
            }
            this.setTestClasses(classes.toArray(new Class[0]));
        }
        this.setOutputDirectory(cla.outputDirectory);
        if (cla.testNames != null) {
            this.setTestNames(Arrays.asList(cla.testNames.split(",")));
        }
        if (cla.useDefaultListeners != null) {
            this.setUseDefaultListeners("true".equalsIgnoreCase(cla.useDefaultListeners));
        }
        this.setGroups(cla.groups);
        this.setExcludedGroups(cla.excludedGroups);
        this.setTestJar(cla.testJar);
        this.setXmlPathInJar(cla.xmlPathInJar);
        this.setJUnit(cla.junit);
        this.setMixed(cla.mixed);
        this.setSkipFailedInvocationCounts(cla.skipFailedInvocationCounts);
        this.toggleFailureIfAllTestsWereSkipped(cla.failIfAllTestsSkipped);
        this.setListenersToSkipFromBeingWiredInViaServiceLoaders(cla.spiListenersToSkip.split(","));
        this.m_configuration.setOverrideIncludedMethods(cla.overrideIncludedMethods);
        if (cla.parallelMode != null) {
            this.setParallel(cla.parallelMode);
        }
        if (cla.configFailurePolicy != null) {
            this.setConfigFailurePolicy(XmlSuite.FailurePolicy.getValidPolicy(cla.configFailurePolicy));
        }
        if (cla.threadCount != null) {
            this.setThreadCount(cla.threadCount);
        }
        if (cla.dataProviderThreadCount != null) {
            this.setDataProviderThreadCount(cla.dataProviderThreadCount);
        }
        if (cla.suiteName != null) {
            this.setDefaultSuiteName(cla.suiteName);
        }
        if (cla.testName != null) {
            this.setDefaultTestName(cla.testName);
        }
        if (cla.listener != null) {
            String sep = ";";
            if (cla.listener.contains(",")) {
                sep = ",";
            }
            String[] strs = Utils.split(cla.listener, sep);
            List<Class<? extends ITestNGListener>> classes = Lists.newArrayList();
            for (String cls : strs) {
                Class<?> clazz2 = ClassHelper.fileToClass(cls);
                if (!ITestNGListener.class.isAssignableFrom(clazz2)) continue;
                classes.add(clazz2);
            }
            this.setListenerClasses(classes);
        }
        if (null != cla.methodSelectors) {
            String[] strs;
            for (String cls : strs = Utils.split(cla.methodSelectors, ",")) {
                String[] sel = Utils.split(cls, ":");
                try {
                    if (sel.length == 2) {
                        this.addMethodSelector(sel[0], Integer.parseInt(sel[1]));
                        continue;
                    }
                    TestNG.error("Method selector value was not in the format org.example.Selector:4");
                }
                catch (NumberFormatException nfe) {
                    TestNG.error("Method selector value was not in the format org.example.Selector:4");
                }
            }
        }
        if (cla.objectFactory != null) {
            this.setObjectFactory(ClassHelper.fileToClass(cla.objectFactory));
        }
        if (cla.testRunnerFactory != null) {
            this.setTestRunnerFactoryClass(ClassHelper.fileToClass(cla.testRunnerFactory));
        }
        if ((reporterConfig = ReporterConfig.deserialize(cla.reporter)) != null) {
            this.addReporter(reporterConfig);
        }
        if (cla.commandLineMethods.size() > 0) {
            this.m_commandLineMethods = cla.commandLineMethods;
        }
        if (cla.suiteFiles != null) {
            this.setTestSuites(cla.suiteFiles);
        }
        this.setSuiteThreadPoolSize(cla.suiteThreadPoolSize);
        this.setRandomizeSuites(cla.randomizeSuites);
        this.alwaysRunListeners(cla.alwaysRunListeners);
    }

    public void setSuiteThreadPoolSize(Integer suiteThreadPoolSize) {
        this.m_suiteThreadPoolSize = suiteThreadPoolSize;
    }

    public Integer getSuiteThreadPoolSize() {
        return this.m_suiteThreadPoolSize;
    }

    public void setRandomizeSuites(boolean randomizeSuites) {
        this.m_randomizeSuites = randomizeSuites;
    }

    public void alwaysRunListeners(boolean alwaysRun) {
        this.m_alwaysRun = alwaysRun;
    }

    @Deprecated
    public void setSourcePath(String path) {
    }

    private static int parseInt(Object value) {
        if (value == null) {
            return -1;
        }
        if (value instanceof String) {
            return Integer.parseInt(String.valueOf(value));
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new IllegalArgumentException("Unable to parse " + value + " as an Integer.");
    }

    @Deprecated
    public void configure(Map cmdLineArgs) {
        String dependencyInjectorFactoryClass;
        String failurePolicy;
        String reporterConfigs;
        String runnerFactory;
        String objectFactory;
        Object listeners;
        String defaultTestName;
        String defaultSuiteName;
        String useDefaultListeners;
        String testNames;
        CommandLineArgs result = new CommandLineArgs();
        int value = TestNG.parseInt(cmdLineArgs.get("-log"));
        if (value != -1) {
            result.verbose = value;
        }
        result.outputDirectory = (String)cmdLineArgs.get("-d");
        String testClasses = (String)cmdLineArgs.get("-testclass");
        if (null != testClasses) {
            result.testClass = testClasses;
        }
        if ((testNames = (String)cmdLineArgs.get("-testnames")) != null) {
            result.testNames = testNames;
        }
        if (null != (useDefaultListeners = (String)cmdLineArgs.get("-usedefaultlisteners"))) {
            result.useDefaultListeners = useDefaultListeners;
        }
        result.groups = (String)cmdLineArgs.get("-groups");
        result.excludedGroups = (String)cmdLineArgs.get("-excludegroups");
        result.testJar = (String)cmdLineArgs.get("-testjar");
        result.xmlPathInJar = (String)cmdLineArgs.get("-xmlpathinjar");
        result.junit = (Boolean)cmdLineArgs.get("-junit");
        result.mixed = (Boolean)cmdLineArgs.get("-mixed");
        Object tmpValue = cmdLineArgs.get("-includeAllDataDrivenTestsWhenSkipping");
        if (tmpValue != null) {
            result.includeAllDataDrivenTestsWhenSkipping = Boolean.parseBoolean(tmpValue.toString());
        }
        result.skipFailedInvocationCounts = (Boolean)cmdLineArgs.get("-skipfailedinvocationcounts");
        result.failIfAllTestsSkipped = Boolean.parseBoolean(((Object)cmdLineArgs.getOrDefault("-failwheneverythingskipped", Boolean.FALSE)).toString());
        result.spiListenersToSkip = cmdLineArgs.getOrDefault("-spilistenerstoskip", "");
        String parallelMode = (String)cmdLineArgs.get("-parallel");
        if (parallelMode != null) {
            result.parallelMode = XmlSuite.ParallelMode.getValidParallel(parallelMode);
        }
        if ((value = TestNG.parseInt(cmdLineArgs.get("-threadcount"))) != -1) {
            result.threadCount = value;
        }
        if ((value = TestNG.parseInt(cmdLineArgs.get("-dataproviderthreadcount"))) != -1) {
            result.dataProviderThreadCount = value;
        }
        if ((defaultSuiteName = (String)cmdLineArgs.get("-suitename")) != null) {
            result.suiteName = defaultSuiteName;
        }
        if ((defaultTestName = (String)cmdLineArgs.get("-testname")) != null) {
            result.testName = defaultTestName;
        }
        result.listener = (listeners = cmdLineArgs.get("-listener")) instanceof List ? Utils.join((List)listeners, ",") : (String)listeners;
        String ms = (String)cmdLineArgs.get("-methodselectors");
        if (null != ms) {
            result.methodSelectors = ms;
        }
        if (null != (objectFactory = (String)cmdLineArgs.get("-objectfactory"))) {
            result.objectFactory = objectFactory;
        }
        if (null != (runnerFactory = (String)cmdLineArgs.get("-testrunfactory"))) {
            result.testRunnerFactory = runnerFactory;
        }
        if ((reporterConfigs = (String)cmdLineArgs.get("-reporter")) != null) {
            result.reporter = reporterConfigs;
        }
        if ((failurePolicy = (String)cmdLineArgs.get("-configfailurepolicy")) != null) {
            result.configFailurePolicy = failurePolicy;
        }
        if ((value = TestNG.parseInt(cmdLineArgs.get("-suitethreadpoolsize"))) != -1) {
            result.suiteThreadPoolSize = value;
        }
        if ((dependencyInjectorFactoryClass = (String)cmdLineArgs.get("-dependencyinjectorfactory")) != null) {
            result.dependencyInjectorFactoryClass = dependencyInjectorFactoryClass;
        }
        this.configure(result);
    }

    public void setTestNames(List<String> testNames) {
        this.m_testNames = testNames;
    }

    public void setSkipFailedInvocationCounts(Boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    private void addReporter(ReporterConfig reporterConfig) {
        IReporter instance = this.newReporterInstance(reporterConfig);
        if (instance != null) {
            this.addListener(instance);
        } else {
            LOGGER.warn("Could not find reporter class : " + reporterConfig.getClassName());
        }
    }

    private IReporter newReporterInstance(ReporterConfig config) {
        Class<?> reporterClass = ClassHelper.forName(config.getClassName());
        if (reporterClass == null) {
            return null;
        }
        if (!IReporter.class.isAssignableFrom(reporterClass)) {
            throw new TestNGException(config.getClassName() + " is not a IReporter");
        }
        IReporter reporter = (IReporter)this.m_objectFactory.newInstance(reporterClass, new Object[0]);
        reporter.getConfig().setProperties(config.getProperties());
        return reporter;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public void setMixed(Boolean isMixed) {
        if (isMixed == null) {
            return;
        }
        this.m_isMixed = isMixed;
    }

    protected static void validateCommandLineParameters(CommandLineArgs args) {
        String testClasses = args.testClass;
        List<String> testNgXml = args.suiteFiles;
        String testJar = args.testJar;
        List<String> methods = args.commandLineMethods;
        if (testClasses == null && testJar == null && (testNgXml == null || testNgXml.isEmpty()) && (methods == null || methods.isEmpty())) {
            throw new ParameterException("You need to specify at least one testng.xml, one class or one method");
        }
        String groups = args.groups;
        String excludedGroups = args.excludedGroups;
        if (!(testJar != null || null == groups && null == excludedGroups || testClasses != null || testNgXml != null && !testNgXml.isEmpty())) {
            throw new ParameterException("Groups option should be used with testclass option");
        }
        Boolean junit = args.junit;
        Boolean mixed = args.mixed;
        if (junit.booleanValue() && mixed.booleanValue()) {
            throw new ParameterException("-mixed can't be combined with -junit");
        }
    }

    public boolean hasFailure() {
        return this.exitCode.hasFailure();
    }

    public boolean hasFailureWithinSuccessPercentage() {
        return this.exitCode.hasFailureWithinSuccessPercentage();
    }

    public boolean hasSkip() {
        return this.exitCode.hasSkip();
    }

    static void exitWithError(String msg) {
        System.err.println(msg);
        TestNG.usage();
        System.exit(1);
    }

    public String getOutputDirectory() {
        return this.m_outputDir;
    }

    public IAnnotationTransformer getAnnotationTransformer() {
        return this.m_annotationTransformer;
    }

    private void setAnnotationTransformer(IAnnotationTransformer t) {
        if (this.m_annotationTransformer != this.m_defaultAnnoProcessor && this.m_annotationTransformer != t) {
            LOGGER.warn("AnnotationTransformer already set");
        }
        this.m_annotationTransformer = t;
    }

    public String getDefaultSuiteName() {
        return this.m_defaultSuiteName;
    }

    public void setDefaultSuiteName(String defaultSuiteName) {
        this.m_defaultSuiteName = defaultSuiteName;
    }

    public String getDefaultTestName() {
        return this.m_defaultTestName;
    }

    public void setDefaultTestName(String defaultTestName) {
        this.m_defaultTestName = defaultTestName;
    }

    public void setConfigFailurePolicy(XmlSuite.FailurePolicy failurePolicy) {
        this.m_configFailurePolicy = failurePolicy;
    }

    public XmlSuite.FailurePolicy getConfigFailurePolicy() {
        return this.m_configFailurePolicy;
    }

    @Deprecated
    public static TestNG getDefault() {
        return m_instance;
    }

    private void setConfigurable(IConfigurable c) {
        if (this.m_configurable != null && this.m_configurable != c) {
            LOGGER.warn("Configurable already set");
        }
        this.m_configurable = c;
    }

    private void setHookable(IHookable h) {
        if (this.m_hookable != null && this.m_hookable != h) {
            LOGGER.warn("Hookable already set");
        }
        this.m_hookable = h;
    }

    public void setMethodInterceptor(IMethodInterceptor methodInterceptor) {
        this.m_methodInterceptors.add(methodInterceptor);
    }

    public void setDataProviderThreadCount(int count) {
        this.m_dataProviderThreadCount = count;
    }

    public void addClassLoader(ClassLoader loader) {
        if (loader != null) {
            ClassHelper.addClassLoader(loader);
        }
    }

    public void setPreserveOrder(boolean b) {
        this.m_preserveOrder = b;
    }

    protected long getStart() {
        return this.m_start;
    }

    protected long getEnd() {
        return this.m_end;
    }

    public void setGroupByInstances(boolean b) {
        this.m_groupByInstances = b;
    }

    public void setServiceLoaderClassLoader(URLClassLoader ucl) {
        this.m_serviceLoaderClassLoader = ucl;
    }

    private void addServiceLoaderListener(ITestNGListener l) {
        if (!this.serviceLoaderListeners.containsKey(l.getClass())) {
            this.serviceLoaderListeners.put(l.getClass(), l);
        }
    }

    public List<ITestNGListener> getServiceLoaderListeners() {
        return Lists.newArrayList(this.serviceLoaderListeners.values());
    }

    public void setInjectorFactory(IInjectorFactory factory) {
        this.m_configuration.setInjectorFactory(factory);
    }

    static {
        DEFAULT_VERBOSE = 1;
        DEFAULT_OBJECT_FACTORY = new DefaultTestObjectFactory();
    }
}

