/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.VerificationError;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.ConstructorExp;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.ProcedureN;

public class InitializeProc
extends ProcedureN
implements Inlineable {
    private Method constructor;
    private ConstructorExp method;
    private boolean implicitThis;
    private int dummyArgs;

    public InitializeProc(Method constructor) {
        this(constructor, false, 0);
    }

    public InitializeProc(Method constructor, boolean implicitThis) {
        this(constructor, implicitThis, 0);
    }

    public InitializeProc(Method constructor, boolean implicitThis, int dummyArgs) {
        this.constructor = constructor;
        this.implicitThis = implicitThis;
        this.dummyArgs = dummyArgs;
    }

    public InitializeProc(ConstructorExp method) {
        this(method, false);
    }

    public InitializeProc(ConstructorExp method, boolean implicitThis) {
        this.method = method;
        this.implicitThis = implicitThis;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        if (this.constructor == null) {
            this.constructor = this.method.getMainMethod();
        }
        CodeAttr code = comp.getCode();
        Expression[] args = exp.getArgs();
        Type[] types = this.constructor.getParameterTypes();
        int arg = 0;
        int type = 0;
        if (this.implicitThis) {
            code.emitPushThis();
        } else {
            args[arg++].compile(comp, Target.pushObject);
        }
        while (arg < args.length) {
            args[arg].compile(comp, types[type++]);
            ++arg;
        }
        if (this.method != null) {
            this.dummyArgs = this.method.dummyArgs;
        }
        for (int i = 0; i < this.dummyArgs; ++i) {
            code.emitPushInt(0);
        }
        try {
            code.emitInvokeSpecial(this.constructor);
        }
        catch (VerificationError e) {
            throw User.error((Located)Location.make(exp), e.getMessage());
        }
    }

    public Type getReturnType(Expression[] args) {
        return Type.void_type;
    }

    public String toString() {
        String res = this.constructor != null ? this.constructor.toString() : (this.method != null ? this.method.toString() : "?");
        return "Initialization: " + res;
    }

    public Object applyN(Object[] args) {
        throw new Error("Not implemented");
    }
}

