/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.awt.Image;
import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.graphics.xobject.PDInlinedImage;
import org.pdfbox.util.BoundingBox;
import org.pdfbox.util.ImageParameters;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.PDFStreamEngine;

public class Type3StreamParser
extends PDFStreamEngine {
    private PDInlinedImage image = null;
    private BoundingBox box = null;

    public Image createImage(COSStream type3Stream) throws IOException {
        this.processStream(null, null, type3Stream);
        return this.image.createImage();
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        super.processOperator(operator, arguments);
        String operation = operator.getOperation();
        if (operation.equals("BI")) {
            ImageParameters params = operator.getImageParameters();
            this.image = new PDInlinedImage();
            this.image.setImageParameters(params);
            this.image.setImageData(operator.getImageData());
        }
        if (!operation.equals("d0") && operation.equals("d1")) {
            COSNumber llx = (COSNumber)arguments.get(2);
            COSNumber lly = (COSNumber)arguments.get(3);
            COSNumber urx = (COSNumber)arguments.get(4);
            COSNumber ury = (COSNumber)arguments.get(5);
            this.box = new BoundingBox();
            this.box.setLowerLeftX(llx.floatValue());
            this.box.setLowerLeftY(lly.floatValue());
            this.box.setUpperRightX(urx.floatValue());
            this.box.setUpperRightY(ury.floatValue());
        }
    }
}

