/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class CheckDocsDoclet {
    private static final String DEST_DIR_OPT = "-d";
    private static Map sDocumentationPages = new HashMap();

    private static DocumentationPage findDocumentationPage(ClassDoc aClassDoc) {
        PackageDoc packageDoc = aClassDoc.containingPackage();
        String packageName = packageDoc.name();
        DocumentationPage page = (DocumentationPage)sDocumentationPages.get(packageName);
        if (page == null) {
            page = new DocumentationPage(packageDoc);
            sDocumentationPages.put(packageName, page);
        }
        return page;
    }

    public static boolean start(RootDoc aRoot) throws IOException {
        ClassDoc[] classDocs = aRoot.classes();
        for (int i = 0; i < classDocs.length; ++i) {
            ClassDoc classDoc = classDocs[i];
            if (!classDoc.typeName().endsWith("Check") || classDoc.isAbstract()) continue;
            DocumentationPage page = CheckDocsDoclet.findDocumentationPage(classDoc);
            page.addCheck(classDoc);
        }
        Collection pages = sDocumentationPages.values();
        File destDir = new File(CheckDocsDoclet.getDestDir(aRoot.options()));
        Iterator it = pages.iterator();
        while (it.hasNext()) {
            DocumentationPage page = (DocumentationPage)it.next();
            String pageName = CheckDocsDoclet.getPageName(page);
            File outfile = new File(destDir, "config_" + pageName + ".xml");
            FileWriter writer = new FileWriter(outfile);
            page.write(writer);
            ((Writer)writer).close();
        }
        return true;
    }

    private static String getPageName(DocumentationPage aPage) {
        String packageName = aPage.getPackageName();
        String pageName = packageName.substring(packageName.lastIndexOf(46) + 1);
        if ("checks".equals(pageName)) {
            return "misc";
        }
        return pageName;
    }

    public static String getDestDir(String[][] aOptions) {
        for (int i = 0; i < aOptions.length; ++i) {
            String[] opt = aOptions[i];
            if (!DEST_DIR_OPT.equalsIgnoreCase(opt[0])) continue;
            return opt[1];
        }
        return null;
    }

    public static int optionLength(String aOption) {
        if (DEST_DIR_OPT.equals(aOption)) {
            return 2;
        }
        return 0;
    }

    private static final class DocumentationPage {
        private PackageDoc mPackageDoc;
        private Map mChecks = new TreeMap();
        private static final String PAGETITLE = "<span class=\"xdocspagetitle\">";
        private static final String PAGETITLE_END = "</span>";

        private DocumentationPage(PackageDoc aPackageDoc) {
            this.mPackageDoc = aPackageDoc;
        }

        private String getPackageName() {
            return this.mPackageDoc.name();
        }

        private void addCheck(ClassDoc aClassDoc) {
            String strippedClassName = aClassDoc.typeName();
            String checkName = strippedClassName.endsWith("Check") ? strippedClassName.substring(0, strippedClassName.length() - "Check".length()) : strippedClassName;
            this.mChecks.put(checkName, aClassDoc);
        }

        private void write(Writer aWriter) throws IOException {
            PrintWriter pw = new PrintWriter(aWriter);
            pw.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            pw.println("<document>");
            pw.println("<properties>");
            pw.println("<title>" + this.getTitle() + "</title>");
            pw.println("<author email=\"checkstyle-devel@lists.sourceforge.net\">Checkstyle Development Team</author>");
            pw.println("</properties>");
            pw.println("<body>");
            pw.flush();
            Tag[] packageInlineTags = this.mPackageDoc.inlineTags();
            for (int i = 0; i < packageInlineTags.length; ++i) {
                Tag packageInlineTag = packageInlineTags[i];
                String text = packageInlineTag.text();
                aWriter.write(text);
            }
            Set checkNames = this.mChecks.keySet();
            Iterator it = checkNames.iterator();
            while (it.hasNext()) {
                String checkName = (String)it.next();
                pw.println("<section name=\"" + checkName + "\">");
                ClassDoc classDoc = (ClassDoc)this.mChecks.get(checkName);
                Tag[] classInlineTags = classDoc.inlineTags();
                for (int j = 0; j < classInlineTags.length; ++j) {
                    Tag inlineTag = classInlineTags[j];
                    if ("@see".equals(inlineTag.kind())) {
                        SeeTag seeTag = (SeeTag)inlineTag;
                        String memberName = seeTag.referencedMemberName();
                        aWriter.write(memberName != null ? memberName : seeTag.text());
                        continue;
                    }
                    aWriter.write(inlineTag.text());
                }
                pw.println();
                pw.println("</section>\n");
            }
            pw.println("</body>");
            pw.println("</document>");
        }

        private void removeOpeningParagraphTag(StringBuffer aText) {
            String openTag = "<p>";
            int tagLen = "<p>".length();
            if (aText.length() > tagLen && aText.substring(0, tagLen).equals("<p>")) {
                aText.delete(0, tagLen);
            }
        }

        private void removeClosingDot(StringBuffer aText) {
            int lastIdx = aText.length() - 1;
            if (aText.length() > 0 && aText.charAt(lastIdx) == '.') {
                aText.delete(lastIdx, lastIdx + 1);
            }
        }

        private String getTitle() {
            StringBuffer text;
            Tag[] tags = this.mPackageDoc.firstSentenceTags();
            String tagText = tags[0].text();
            int pagetitleIdx = tagText.indexOf(PAGETITLE);
            if (pagetitleIdx != -1) {
                int titleEndIdx = tagText.indexOf(PAGETITLE_END, pagetitleIdx);
                int titleStartIdx = pagetitleIdx + PAGETITLE.length();
                text = new StringBuffer(tagText.substring(titleStartIdx, titleEndIdx));
            } else {
                text = new StringBuffer(tagText);
            }
            this.removeClosingDot(text);
            this.removeOpeningParagraphTag(text);
            return text.toString().trim();
        }
    }
}

