/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;

public class MethodParamPadCheck
extends AbstractOptionCheck {
    private boolean mAllowLineBreaks;

    public MethodParamPadCheck() {
        super(PadOption.NOSPACE);
    }

    public int[] getDefaultTokens() {
        return new int[]{8, 136, 27, 9, 42};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST parenAST;
        if (aAST.getType() == 27) {
            parenAST = aAST;
        } else {
            parenAST = aAST.findFirstToken(76);
            if (parenAST == null) {
                return;
            }
        }
        String line = this.getLines()[parenAST.getLineNo() - 1];
        if (Utils.whitespaceBefore(parenAST.getColumnNo(), line)) {
            if (!this.mAllowLineBreaks) {
                this.log(parenAST, "line.previous", (Object)parenAST.getText());
            }
        } else {
            int before = parenAST.getColumnNo() - 1;
            if (PadOption.NOSPACE == this.getAbstractOption() && Character.isWhitespace(line.charAt(before))) {
                this.log(parenAST, "ws.preceded", (Object)parenAST.getText());
            } else if (PadOption.SPACE == this.getAbstractOption() && !Character.isWhitespace(line.charAt(before))) {
                this.log(parenAST, "ws.notPreceded", (Object)parenAST.getText());
            }
        }
    }

    public void setAllowLineBreaks(boolean aAllowLineBreaks) {
        this.mAllowLineBreaks = aAllowLineBreaks;
    }
}

