/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Text;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgDatabaseSchema : PgAbstractDbSchema
	{
		#region Constructors

		public PgDatabaseSchema() : base("Database")
		{
		}

		#endregion

		#region Add Methods

		public override void AddTables()
		{
			AddTable("pg_database");
		}

		public override void AddRestrictionColumns()
		{
			AddRestrictionColumn("pg_database.datname", "DATABASE_NAME", null);
		}

		public override void AddDataColumns()
		{
			AddDataColumn("pg_database.datistemplate"	, "IS_TEMPLATE");
			AddDataColumn("pg_database.datallowconn"	, "ALLOW_CONNECTION");
			AddDataColumn("pg_database.datconfig"		, "DATABASE_CONFIG");
		}

		public override void AddJoins()
		{
		}

		public override void AddOrderByColumns()
		{
		}

		public override void AddWhereFilters()
		{
		}

		#endregion

		#region Parse Methods

		public override object[] ParseRestrictions(object[] restrictions)
		{
			object[] parsed = restrictions;

			return parsed;
		}

		#endregion
	}
}