/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Text;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgForeignKeysSchema : PgAbstractDbSchema
	{
		#region Constructors

		public PgForeignKeysSchema() : base("ForeignKeys")
		{
		}

		#endregion

		#region Add Methods

		public override void AddTables()
		{
			AddTable("pg_constraint");
		}

		public override void AddRestrictionColumns()
		{
			AddRestrictionColumn("pg_namespace.nspname"	, "PK_TABLE_SCHEMA", null);
			AddRestrictionColumn("pk_table.relname"		, "PK_TABLE_NAME", null);
			AddRestrictionColumn("pg_namespace.nspname"	, "FK_TABLE_SCHEMA", null);
			AddRestrictionColumn("fk_table.relname"		, "FK_TABLE_NAME", null);			
		}

		public override void AddDataColumns()
		{			
			AddDataColumn("pg_constraint.conkey"	, "PK_COLUMNS");
			AddDataColumn("pg_constraint.confkey"	, "FK_COLUMNS");
			AddDataColumn(getRuleExpression("pg_constraint.confupdtype"), "UPDATE_RULE");
			AddDataColumn(getRuleExpression("pg_constraint.confdeltype"), "DELETE_RULE");			
			AddDataColumn("pg_constraint.conname"	, "FK_NAME");
			AddDataColumn("pg_constraint.condeferrable"	, "DEFERRABILITY");
			AddDataColumn("pg_constraint.condeferred"	, "IS_DEFERRED");
			AddDataColumn("pg_description.description"	, "DESCRIPTION");
		}

		public override void AddJoins()
		{
			AddJoin("left join"	, "pg_namespace", "pg_constraint.connamespace = pg_namespace.oid");
			AddJoin("left join"	, "pg_class as pk_table", "pg_constraint.conrelid = pk_table.oid");
			AddJoin("right join", "pg_class as fk_table", "pg_constraint.confrelid = fk_table.oid");
			AddJoin("left join"	, "pg_description", "pg_constraint.oid = pg_description.objoid");
		}

		public override void AddOrderByColumns()
		{
			AddOrderBy("pg_namespace.nspname");
			AddOrderBy("pk_table.relname");
			AddOrderBy("pg_constraint.conname");
		}

		public override void AddWhereFilters()
		{
			// Get Only Primary Key information
			AddWhereFilter("pg_constraint.contype = 'f'");
		}

		#endregion

		#region Parse Methods

		public override object[] ParseRestrictions(object[] restrictions)
		{
			object[] parsed = restrictions;

			return parsed;
		}

		#endregion

		#region Private Methods

		private string getRuleExpression(string fieldName)
		{
			StringBuilder expression = new StringBuilder();

			expression.AppendFormat(" case {0} ", fieldName);
			expression.Append(" when 'a' THEN 'NO ACTION'");
			expression.Append(" when 'r' THEN 'RESTRICT'");
			expression.Append(" when 'c' THEN 'CASCADE'");
			expression.Append(" when 'd' THEN 'SET DEFAULT'");
			expression.Append(" when 'n' THEN 'SET NULL'");
			expression.Append(" END ");

			return expression.ToString();
		}

		#endregion
	}
}