/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Text;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgProviderTypesSchema : PgAbstractDbSchema
	{
		#region Constructors

		public PgProviderTypesSchema() : base("ProviderTypes")
		{
		}

		#endregion

		#region Add Methods

		public override void AddTables()
		{
			AddTable("pg_type");
		}

		public override void AddRestrictionColumns()
		{
			AddRestrictionColumn("pg_namespace.nspname", "TYPE_SCHEMA", null);
			AddRestrictionColumn("pg_type.typname", "TYPE_NAME", null);
			AddRestrictionColumn("pg_type.oid", "DATA_TYPE", null);
		}

		public override void AddDataColumns()
		{
			AddDataColumn("pg_type.typlen", "COLUMN_SIZE");
			AddDataColumn("pg_type.typnotnull", "IS_NOT_NULL");
			AddDataColumn("pg_type.typndims", "ARRAY_DIMENSIONS");
			AddDataColumn("pg_type.typelem", "ELEMENT_TYPE");
			AddDataColumn("pg_type.typbasetype", "BASE_TYPE");
			AddDataColumn("pg_type.typtypmod", "BASE_TYPE_MODIFIER");
			AddDataColumn("pg_description.description", "DESCRIPTION");
		}

		public override void AddJoins()
		{
			AddJoin("left join", "pg_namespace", "pg_type.typnamespace = pg_namespace.oid");
			AddJoin("left join", "pg_description", "pg_type.oid = pg_description.objoid");
		}

		public override void AddOrderByColumns()
		{
			AddOrderBy("pg_type.typname");
		}

		public override void AddWhereFilters()
		{
		}

		#endregion

		#region Parse Methods

		public override object[] ParseRestrictions(object[] restrictions)
		{
			object[] parsed = restrictions;

			return parsed;
		}

		#endregion
	}
}