/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Text;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgSchemataSchema : PgAbstractDbSchema
	{
		#region Constructors

		public PgSchemataSchema() : base("Schemata")
		{
		}

		#endregion

		#region Add Methods

		public override void AddTables()
		{
			AddTable("pg_namespace");
		}

		public override void AddRestrictionColumns()
		{
			AddRestrictionColumn("pg_namespace.nspname", "SCHEMA_NAME", null);
			AddRestrictionColumn("pg_shadow.usename", "SCHEMA_OWNER", null);
		}

		public override void AddDataColumns()
		{
			AddDataColumn("pg_description.description", "DESCRIPTION");
		}

		public override void AddJoins()
		{
			AddJoin("left join", "pg_shadow", "pg_namespace.nspowner = pg_shadow.usesysid");
			AddJoin("left join", "pg_description", "pg_namespace.oid = pg_description.objoid");
		}

		public override void AddOrderByColumns()
		{
			AddOrderBy("pg_namespace.nspname");
			AddOrderBy("pg_shadow.usename");
		}

		public override void AddWhereFilters()
		{
		}

		#endregion

		#region Parse Methods

		public override object[] ParseRestrictions(object[] restrictions)
		{
			object[] parsed = restrictions;

			return parsed;
		}

		#endregion
	}
}